/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jvnet.lafplugin.LafComponentPlugin;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.fonts.FontSet;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.painter.utils.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.border.SubstanceBorder;

public class SubstanceSwingxPlugin
implements LafComponentPlugin {
    public Object[] getDefaults(Object mSkin) {
        SubstanceSkin skin = (SubstanceSkin)mSkin;
        final SubstanceColorScheme mainActiveScheme = skin.getMainActiveColorScheme();
        SubstanceColorScheme mainDefaultScheme = skin.getMainDefaultColorScheme();
        SubstanceColorScheme mainDisabledScheme = skin.getMainDisabledColorScheme();
        ColorUIResource foregroundColor = SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)mainDefaultScheme);
        ColorUIResource backgroundColor = new ColorUIResource(mainActiveScheme.getBackgroundFillColor());
        ColorUIResource disabledForegroundColor = SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)mainDisabledScheme);
        ColorUIResource selectionBackgroundColor = new ColorUIResource(skin.getHighlightColorScheme(null, ComponentState.ACTIVE).getSelectionBackgroundColor());
        ColorUIResource selectionForegroundColor = new ColorUIResource(mainActiveScheme.getSelectionForegroundColor());
        FontSet fontSet = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null);
        FontUIResource controlFont = fontSet.getControlFont();
        Painter titlePanelPainter = new Painter(){

            public void paint(Graphics2D g, Object jxTitledPanel, int width, int height) {
                JComponent titledPanel = (JComponent)jxTitledPanel;
                Graphics2D g2d = (Graphics2D)g.create();
                DecorationAreaType decorationType = SubstanceDecorationUtilities.getDecorationType((Component)titledPanel);
                if (decorationType != null && SubstanceCoreUtilities.getSkin((Component)titledPanel).isRegisteredAsDecorationArea(decorationType)) {
                    SubstanceDecorationUtilities.paintDecorationBackground((Graphics)g2d, (Component)titledPanel, (boolean)false);
                } else {
                    SubstanceFillBackgroundDelegate.GLOBAL_INSTANCE.fillAndWatermark((Graphics)g2d, titledPanel, SubstanceColorSchemeUtilities.getColorScheme((Component)titledPanel, (ComponentState)ComponentState.ACTIVE).getBackgroundFillColor(), new Rectangle(0, 0, titledPanel.getWidth(), titledPanel.getHeight()));
                }
                g2d.dispose();
            }
        };
        SubstanceColorScheme headerDecorationTheme = skin.getMainDefaultColorScheme(DecorationAreaType.HEADER);
        ColorUIResource titlePaneForeground = new ColorUIResource(SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)headerDecorationTheme));
        Object[] defaults = new Object[]{"DatePickerUI", "org.jvnet.substance.swingx.SubstanceDatePickerUI", "MonthViewUI", "org.jvnet.substance.swingx.SubstanceMonthViewUI", "swingx/TaskPaneContainerUI", "org.jvnet.substance.swingx.SubstanceTaskPaneContainerUI", "swingx/TaskPaneUI", "org.jvnet.substance.swingx.SubstanceTaskPaneUI", "StatusBarUI", "org.jvnet.substance.swingx.SubstanceStatusBarUI", "HeaderUI", "org.jvnet.substance.swingx.SubstanceHeaderUI", "LoginPaneUI", "org.jvnet.substance.swingx.SubstanceLoginPaneUI", "swingx/TipOfTheDayUI", "org.jvnet.substance.swingx.SubstanceTipOfTheDayUI", "TitledPanelUI", "org.jvnet.substance.swingx.SubstanceTitledPanelUI", "ErrorPaneUI", "org.jvnet.substance.swingx.SubstanceErrorPaneUI", "HyperlinkUI", "org.jvnet.substance.swingx.SubstanceHyperlinkUI", "PanelUI", "org.jvnet.substance.swingx.SubstancePanelUI", "ColumnHeaderRenderer.upIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceImageCreator.getArrowIcon((int)SubstanceSizeUtils.getControlFontSize(), (int)1, (SubstanceColorScheme)mainActiveScheme));
            }
        }, "ColumnHeaderRenderer.downIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceImageCreator.getArrowIcon((int)SubstanceSizeUtils.getControlFontSize(), (int)5, (SubstanceColorScheme)mainActiveScheme));
            }
        }, "JXDatePicker.arrowIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceImageCreator.getArrowIcon((int)SubstanceSizeUtils.getControlFontSize(), (int)5, (SubstanceColorScheme)mainActiveScheme));
            }
        }, "JXLoginPane.bannerFont", new FontUIResource(controlFont.deriveFont(3.0f * (float)controlFont.getSize())), "JXLoginPane.bannerForeground", new ColorUIResource(SubstanceColorUtilities.getNegativeColor((Color)foregroundColor)), "JXLoginPane.bannerLightBackground", new ColorUIResource(mainActiveScheme.isDark() ? mainActiveScheme.getUltraLightColor() : mainActiveScheme.getLightColor()), "JXLoginPane.bannerDarkBackground", new ColorUIResource(mainActiveScheme.isDark() ? mainActiveScheme.getLightColor() : mainActiveScheme.getMidColor()), "JXMonthView.background", backgroundColor, "JXMonthView.foreground", foregroundColor, "JXMonthView.monthStringBackground", backgroundColor, "JXMonthView.monthStringForeground", foregroundColor, "JXMonthView.daysOfTheWeekForeground", foregroundColor, "JXMonthView.weekOfTheYearForeground", foregroundColor, "JXMonthView.unselectableDayForeground", new ColorUIResource(Color.RED), "JXMonthView.selectedBackground", selectionBackgroundColor, "JXMonthView.selectedForeground", selectionForegroundColor, "JXMonthView.flaggedDayForeground", new ColorUIResource(Color.RED), "JXMonthView.leadingDayForeground", disabledForegroundColor, "JXMonthView.trailingDayForeground", disabledForegroundColor, "TaskPane.titleForeground", foregroundColor, "TaskPane.titleOver", foregroundColor, "TaskPane.specialTitleForeground", foregroundColor, "TaskPane.specialTitleOver", foregroundColor, "TaskPaneContainer.background", backgroundColor, "TaskPaneContainer.backgroundPainter", null, "TaskPane.background", backgroundColor, "TaskPane.foreground", foregroundColor, "TaskPane.font", new FontUIResource(controlFont.deriveFont(1)), "TipOfTheDay.background", backgroundColor.darker(), "TipOfTheDay.foreground", foregroundColor, "TipOfTheDay.font", new FontUIResource(controlFont), "TipOfTheDay.tipFont", new FontUIResource(controlFont.deriveFont(4.0f + (float)controlFont.getSize())), "TipOfTheDay.border", new SubstanceBorder(), "TitledBorder.font", new FontUIResource(controlFont), "TitledBorder.titleColor", foregroundColor, "JXTitledPanel.titleForeground", titlePaneForeground, "JXTitledPanel.titleFont", new FontUIResource(controlFont.deriveFont(1)), "JXTitledPanel.titlePainter", new PainterUIResource(titlePanelPainter), "JXHeader.titleForeground", titlePaneForeground, "JXHeader.descriptionForeground", titlePaneForeground};
        return defaults;
    }

    public void initialize() {
    }

    public void uninitialize() {
    }
}

