/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.CmdLine;
import cz.vity.freerapid.core.Lng;
import cz.vity.freerapid.core.OneInstanceClient;
import cz.vity.freerapid.core.application.GlobalEDTExceptionHandler;
import cz.vity.freerapid.core.application.ListItemsConvertor;
import cz.vity.freerapid.core.tasks.CheckForNewVersionTask;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.LookAndFeels;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.TrayIconSupport;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.jdesktop.appframework.swingx.SingleXFrameApplication;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceConverter;

public class MainApp
extends SingleXFrameApplication {
    private ManagerDirector director;
    static boolean debug = false;
    private TrayIconSupport trayIconSupport = null;
    private AppPrefs appPrefs;
    private boolean minimizeOnStart = false;

    @Override
    protected void initialize(String[] stringArray) {
        CmdLine cmdLine = new CmdLine(this);
        List<String> list = cmdLine.processCommandLine(stringArray);
        LogUtils.initLogging(debug ? "logdebug.properties" : "logdefault.properties");
        this.minimizeOnStart = cmdLine.isMinimize();
        this.appPrefs = new AppPrefs(this.getContext(), cmdLine.getProperties(), cmdLine.isResetOptions());
        String string = Utils.getAppPath();
        int n = string.indexOf(43);
        if (n == -1) {
            n = string.indexOf("!/");
        }
        if (n == -1) {
            n = string.indexOf("!\\");
        }
        if (n > 0 || string.endsWith("!")) {
            Logger logger = Logger.getLogger(MainApp.class.getName());
            logger.severe("Application cannot be started on the path containing '+' or '!' characters ('" + string.substring(0, n + 1) + "'...)\nExiting.");
            System.exit(-1);
        }
        if (OneInstanceClient.checkInstance(list, this.appPrefs)) {
            this.exit();
            return;
        }
        Lng.loadLangProperties();
        LookAndFeels.getInstance().loadLookAndFeelSettings();
        super.initialize(stringArray);
        ResourceConverter.register(new ListItemsConvertor());
        this.getContext().getTaskMonitor().setAutoUpdateForegroundTask(false);
    }

    @Override
    protected void startup() {
        super.startup();
        this.director = new ManagerDirector(this.getContext());
        this.director.initComponents();
        this.initMainFrame();
        this.addExitListener(new MainAppExitListener());
        JFrame jFrame = this.getMainFrame();
        this.show(jFrame);
        this.getTrayIconSupport().setVisibleByDefault();
        this.setGlobalEDTExceptionHandler();
        if (this.minimizeOnStart) {
            Swinger.minimize(jFrame);
        }
    }

    private void initMainFrame() {
        JFrame jFrame = this.getMainFrame();
        if (AppPrefs.getProperty("decoratedFrames", false)) {
            jFrame.setUndecorated(true);
            jFrame.getRootPane().setWindowDecorationStyle(1);
            LookAndFeels.updateWindowUI(jFrame);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        jFrame.setJMenuBar(this.director.getMenuManager().getMenuBar());
        jFrame.setContentPane(this.director.getComponent());
        jFrame.setMinimumSize(new Dimension(30, 30));
        jFrame.pack();
        if (AppPrefs.getProperty("checkForNewVersionAuto", true) && !debug) {
            this.startCheckNewVersion();
        }
    }

    private void setGlobalEDTExceptionHandler() {
        GlobalEDTExceptionHandler globalEDTExceptionHandler = new GlobalEDTExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(globalEDTExceptionHandler);
        Thread.currentThread().setUncaughtExceptionHandler(globalEDTExceptionHandler);
    }

    @Override
    protected void injectSessionProperties() {
        super.injectSessionProperties();
    }

    public ManagerDirector getManagerDirector() {
        assert (this.director != null);
        return this.director;
    }

    public static void main(String[] stringArray) {
        Application.launch(MainApp.class, stringArray);
    }

    public static ApplicationContext getAContext() {
        return Application.getInstance(MainApp.class).getContext();
    }

    private void startCheckNewVersion() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                    MainApp.this.getContext().getTaskService().execute(new CheckForNewVersionTask(false));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public TrayIconSupport getTrayIconSupport() {
        if (this.trayIconSupport == null) {
            this.trayIconSupport = new TrayIconSupport();
        }
        return this.trayIconSupport;
    }

    private class MainAppExitListener
    implements Application.ExitListener {
        private MainAppExitListener() {
        }

        @Override
        public boolean canExit(EventObject eventObject) {
            if (AppPrefs.getProperty("minimizeOnClose", false) && eventObject instanceof WindowEvent) {
                Swinger.minimize(MainApp.this.getMainFrame());
                return false;
            }
            return true;
        }

        @Override
        public void willExit(EventObject eventObject) {
            MainApp.this.appPrefs.store();
        }
    }
}

