/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;

final class OneInstanceServer
extends Thread {
    private static final Logger logger = Logger.getLogger(OneInstanceServer.class.getName());
    private final AppPrefs prefs;

    public OneInstanceServer(AppPrefs appPrefs) {
        this.prefs = appPrefs;
        this.setPriority(1);
    }

    @Override
    public final void run() {
        this.setName("OneInstanceServer");
        Socket socket = null;
        try {
            logger.info("Creating a local socket server");
            String string = AppPrefs.getProperty("oneInstanceServerPort", null);
            ServerSocket serverSocket = null;
            if (string == null) {
                int n = 39871;
                int n2 = 10;
                while (--n2 > 0) {
                    try {
                        logger.info("Trying to create a local socket server on port " + n);
                        serverSocket = new ServerSocket(n, 1);
                        AppPrefs.storeProperty("oneInstanceServerPort", n);
                        this.prefs.store();
                        break;
                    }
                    catch (IOException iOException) {
                        logger.info("Failed to create a local socket server on port " + n + "  Reason:" + iOException.getMessage());
                        ++n;
                    }
                }
            } else {
                serverSocket = new ServerSocket(AppPrefs.getProperty("oneInstanceServerPort", 39871), 1);
            }
            if (serverSocket == null) {
                throw new IOException("Cannot find available free port for starting");
            }
            while (!this.isInterrupted()) {
                String string2;
                logger.info("Waiting for connection");
                socket = serverSocket.accept();
                logger.info("Got a connection");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() == 0 || string2.startsWith("-") || !"\n".equals(string2)) continue;
                }
                bufferedReader.close();
                socket.close();
                MainApp mainApp = MainApp.getInstance(MainApp.class);
                mainApp.getMainFrame().toFront();
            }
        }
        catch (IOException iOException) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    LogUtils.processException(logger, iOException);
                }
            }
            LogUtils.processException(logger, iOException);
        }
    }
}

