/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.application;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.utilities.Utils;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.logging.Logger;

public class ProxyHelper {
    private static final Logger logger = Logger.getLogger(ProxyHelper.class.getName());

    private ProxyHelper() {
    }

    public static void initProxy() {
        if (AppPrefs.getProperty("proxy", false)) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = AppPrefs.getProperty("proxy.url", "localhost");
            String string2 = AppPrefs.getProperty("proxy.port", "8080");
            stringBuilder.append("\nUrl-").append(string).append("\nPort-").append(string2);
            System.setProperty("proxySet", "true");
            System.setProperty("https.proxyHost", string);
            System.setProperty("https.proxyPort", string2);
            System.setProperty("proxyHost", string);
            System.setProperty("proxyPort", string2);
            if (AppPrefs.getProperty("proxy.login", false)) {
                String string3 = AppPrefs.getProperty("proxy.username", "");
                String string4 = Utils.generateXorString(AppPrefs.getProperty("proxy.password", ""));
                stringBuilder.append("\nProxy Login Name -").append(string3);
                Authenticator.setDefault(new HttpAuthenticateProxy(string3, string4));
            }
            logger.config("Setting proxy configuration ON with configuration: " + stringBuilder.toString());
        } else {
            System.setProperty("proxySet", "false");
            logger.config("Setting proxy configuration OFF");
        }
    }

    private static final class HttpAuthenticateProxy
    extends Authenticator {
        private final String proxyUsername;
        private final String proxyPassword;

        public HttpAuthenticateProxy(String string, String string2) {
            this.proxyUsername = string;
            this.proxyPassword = string2;
        }

        @Override
        protected final PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.proxyUsername, this.proxyPassword.toCharArray());
        }
    }
}

