/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CloseInTimeTask;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.DownloadTaskError;
import cz.vity.freerapid.core.tasks.MoveFileTask;
import cz.vity.freerapid.gui.managers.TaskServiceManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.exceptions.CaptchaEntryInputMismatchException;
import cz.vity.freerapid.plugins.exceptions.FailedToLoadCaptchaPictureException;
import cz.vity.freerapid.plugins.exceptions.NotEnoughSpaceException;
import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import cz.vity.freerapid.plugins.exceptions.URLNotAvailableAnymoreException;
import cz.vity.freerapid.plugins.exceptions.YouHaveToWaitException;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.HttpFile;
import cz.vity.freerapid.plugins.webclient.HttpFileDownloader;
import cz.vity.freerapid.plugins.webclient.ShareDownloadService;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Sound;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdesktop.application.Application;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class DownloadTask
extends CoreTask<Void, Long>
implements HttpFileDownloader {
    private static final Logger logger = Logger.getLogger(DownloadTask.class.getName());
    protected final HttpDownloadClient client;
    protected final DownloadFile downloadFile;
    private ShareDownloadService service;
    private long speedInBytes;
    private float averageSpeed;
    private volatile long counter;
    private Integer sleep = 0;
    private File outputFile;
    private File storeFile;
    private static Timer timer = new Timer();
    private DownloadTaskError serviceError;
    private int youHaveToSleepSecondsTime = 0;
    private volatile String captchaResult;
    private static final int NO_DATA_TIMEOUT_LIMIT = 100;
    private static final int INPUT_BUFFER_SIZE = 50000;
    private static final int OUTPUT_FILE_BUFFER_SIZE = 600000;
    private volatile boolean connectionTimeOut;
    private static final Object captchaLock = new Object();
    private int fileAlreadyExists;

    public DownloadTask(Application application, HttpDownloadClient httpDownloadClient, DownloadFile downloadFile, ShareDownloadService shareDownloadService) {
        super(application);
        this.client = httpDownloadClient;
        this.downloadFile = downloadFile;
        this.service = shareDownloadService;
        this.serviceError = DownloadTaskError.NO_ERROR;
        this.setInputBlocker(null);
        this.setUserCanCancel(true);
        this.youHaveToSleepSecondsTime = 0;
        this.connectionTimeOut = false;
        this.speedInBytes = 0L;
        this.averageSpeed = 0.0f;
        this.fileAlreadyExists = -2;
        downloadFile.setConnectionSettings(httpDownloadClient.getSettings());
    }

    protected Void doInBackground() throws Exception {
        this.client.getHTTPClient().setHttpConnectionManager((HttpConnectionManager)new SimpleHttpConnectionManager());
        int n = timer.purge();
        if (n > 0) {
            logger.info("Purged timers " + n);
        }
        this.client.getHTTPClient().getHttpConnectionManager().closeIdleConnections(0L);
        this.downloadFile.setDownloaded(0L);
        int n2 = AppPrefs.getProperty("firstSleepTime", 4);
        if (n2 > 0) {
            this.sleep(n2);
        }
        this.downloadFile.setState(DownloadState.GETTING);
        this.service.run(this);
        this.service = null;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream getFileOutputStream(File file, long l) throws NotEnoughSpaceException, IOException {
        OutputStream outputStream;
        if (file.getParentFile().getFreeSpace() < l + 0xA00000L) {
            throw new NotEnoughSpaceException();
        }
        if (AppPrefs.getProperty("preCreateFile", false)) {
            Class<DownloadTask> clazz = DownloadTask.class;
            synchronized (DownloadTask.class) {
                if (this.isTerminated()) {
                    // ** MonitorExit[var5_3] (shouldn't be in output)
                    return null;
                }
                outputStream = FileUtils.createEmptyFile(file, l, this);
                if (this.isTerminated()) {
                    // ** MonitorExit[var5_3] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var5_3] (shouldn't be in output)
            }
        } else {
            outputStream = new FileOutputStream(file);
        }
        return new BufferedOutputStream(outputStream, AppPrefs.getProperty("outputFileBufferSize", 600000));
    }

    protected void initBackground() {
    }

    @Override
    public boolean isTerminated() {
        return this.isCancelled() || Thread.currentThread().isInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToFile(InputStream inputStream) throws Exception {
        File file;
        boolean bl = AppPrefs.getProperty("useTemporaryFiles", true);
        byte[] byArray = new byte[AppPrefs.getProperty("inputBufferSize", 50000)];
        OutputStream[] outputStreamArray = new OutputStream[]{null};
        String string = this.downloadFile.getFileName();
        this.outputFile = this.downloadFile.getOutputFile();
        if (bl) {
            this.fileAlreadyExists = this.checkExists();
            if (this.fileAlreadyExists == 2) {
                this.cancel(true);
                return;
            }
        }
        if (!(file = this.downloadFile.getSaveToDirectory()).exists()) {
            file.mkdirs();
        }
        this.storeFile = bl ? File.createTempFile(string + ".", ".part", file) : this.outputFile;
        long l = this.downloadFile.getFileSize();
        if (bl) {
            this.storeFile.deleteOnExit();
        }
        try {
            try {
                int n;
                outputStreamArray[0] = this.getFileOutputStream(this.storeFile, l);
                if (this.isTerminated()) {
                    this.closeFileStream(outputStreamArray[0]);
                    this.checkDeleteTempFile();
                    return;
                }
                this.counter = 0L;
                this.downloadFile.setState(DownloadState.DOWNLOADING);
                this.setSpeed(0L);
                final long l2 = System.currentTimeMillis();
                timer.schedule(new TimerTask(){
                    private long lastSize = 0L;
                    private int noDataTimeOut = 0;

                    @Override
                    public void run() {
                        long l;
                        double d;
                        if (DownloadTask.this.isTerminated() || DownloadTask.this.downloadFile.getState() != DownloadState.DOWNLOADING) {
                            this.cancel();
                            return;
                        }
                        long l22 = DownloadTask.this.counter - this.lastSize;
                        DownloadTask.this.setSpeed(l22);
                        if (l22 == 0L) {
                            if (++this.noDataTimeOut >= 100) {
                                logger.info("Cancelling download - no downloaded data during 100 seconds");
                                DownloadTask.this.connectionTimeOut = true;
                                this.cancel();
                                DownloadTask.this.cancel(true);
                                return;
                            }
                        } else {
                            this.noDataTimeOut = 0;
                            this.lastSize = DownloadTask.this.counter;
                            DownloadTask.this.setDownloaded(DownloadTask.this.counter);
                        }
                        if ((d = (double)((l = System.currentTimeMillis()) - l2) / 1000.0) == 0.0) {
                            DownloadTask.this.setAverageSpeed(0.0f);
                        } else {
                            DownloadTask.this.setAverageSpeed((float)((double)DownloadTask.this.counter / d));
                        }
                    }
                }, 0L, 1000L);
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStreamArray[0].write(byArray, 0, n);
                    this.counter += (long)n;
                    if (!this.isTerminated()) continue;
                    outputStreamArray[0].flush();
                    break;
                }
                if (!this.isTerminated()) {
                    if (this.counter != l) {
                        throw new IOException("ErrorDuringDownload");
                    }
                    this.setDownloaded(l);
                } else {
                    logger.info("File downloading was terminated");
                }
            }
            catch (Exception exception) {
                if (this.storeFile != null && this.storeFile.exists()) {
                    this.closeFileStream(outputStreamArray[0]);
                    outputStreamArray[0] = null;
                    this.storeFile.delete();
                }
                throw exception;
            }
            finally {
                this.closeFileStream(outputStreamArray[0]);
                outputStreamArray[0] = null;
                this.checkDeleteTempFile();
            }
        }
        finally {
            this.setSpeed(0L);
            this.checkDeleteTempFile();
        }
    }

    private void closeFileStream(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error closing file stream", iOException);
        }
    }

    private void checkDeleteTempFile() {
        if (this.isTerminated() && this.storeFile.exists()) {
            logger.info("Deleting partial file " + this.storeFile);
            boolean bl = this.storeFile.delete();
            if (!bl) {
                logger.info("Deleting partial file failed (" + this.storeFile + ")");
            }
        }
    }

    @Override
    protected void cancelled() {
        if (this.connectionTimeOut) {
            this.downloadFile.setState(DownloadState.ERROR);
            this.setServiceError(DownloadTaskError.CONNECTION_TIMEOUT);
        } else {
            this.downloadFile.setState(DownloadState.CANCELLED);
        }
        this.downloadFile.setDownloaded(0L);
        this.setSpeed(0L);
        this.setAverageSpeed(0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSpeed(long l) {
        Long l2;
        Long l3;
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            l3 = this.speedInBytes;
            this.speedInBytes = l;
            l2 = this.speedInBytes;
        }
        this.firePropertyChange("speed", l3, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSleep(int n) {
        Integer n2;
        Integer n3;
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            n3 = this.sleep;
            n2 = this.sleep = Integer.valueOf(n);
        }
        this.firePropertyChange("sleep", n3, n2);
    }

    protected void setDownloaded(long l) {
        this.firePropertyChange("downloaded", 0, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAverageSpeed(float f) {
        float f2;
        float f3;
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            f3 = this.averageSpeed;
            f2 = this.averageSpeed = f;
        }
        this.firePropertyChange("averageSpeed", Float.valueOf(f3), Float.valueOf(f2));
    }

    @Override
    protected void failed(Throwable throwable) {
        Object object;
        if (!(throwable instanceof YouHaveToWaitException || throwable instanceof URLNotAvailableAnymoreException || throwable instanceof CaptchaEntryInputMismatchException)) {
            super.failed(throwable);
        }
        this.error(throwable);
        if (throwable instanceof NotEnoughSpaceException) {
            Swinger.showErrorMessage(this.getResourceMap(), "NotEnoughSpaceException", this.storeFile != null ? this.storeFile : "");
            this.setServiceError(DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR);
        } else if (throwable instanceof UnknownHostException) {
            this.downloadFile.setErrorMessage(this.getResourceMap().getString("UnknownHostError", new Object[0]));
        } else if (throwable instanceof URLNotAvailableAnymoreException || throwable instanceof PluginImplementationException || throwable instanceof CaptchaEntryInputMismatchException) {
            this.setServiceError(DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR);
        } else if (throwable instanceof YouHaveToWaitException) {
            object = (YouHaveToWaitException)throwable;
            this.youHaveToSleepSecondsTime = ((YouHaveToWaitException)object).getHowManySecondsToWait();
            this.setServiceError(DownloadTaskError.YOU_HAVE_TO_WAIT_ERROR);
        }
        if (AppPrefs.getProperty("disableConnectionOnException", false) && (throwable instanceof NoRouteToHostException || throwable instanceof ConnectException || throwable instanceof UnknownHostException)) {
            this.setServiceError(DownloadTaskError.NO_ROUTE_TO_HOST);
        }
        if (this.getServiceError() == DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR) {
            this.downloadFile.setErrorAttemptsCount(0);
            this.downloadFile.setTimeToQueued(-1);
            this.downloadFile.setTimeToQueuedMax(-1);
        }
        if (this.isAllComplete((Application)(object = this.getApplication()))) {
            this.checkShutDown((Application)object);
        }
    }

    private void error(Throwable throwable) {
        String string = throwable.getMessage();
        if (string != null && this.getResourceMap().containsKey(string)) {
            this.downloadFile.setErrorMessage(this.getResourceMap().getString(string, new Object[0]));
        } else {
            this.downloadFile.setErrorMessage(string);
        }
        this.setServiceError(DownloadTaskError.GENERAL_ERROR);
        if (!(throwable instanceof YouHaveToWaitException)) {
            if (AppPrefs.getProperty("playSoundsFailed", true)) {
                Sound.playSound(this.getContext().getResourceMap().getString("errorWav", new Object[0]));
            }
            this.downloadFile.setState(DownloadState.ERROR);
        } else {
            this.downloadFile.setState(DownloadState.SLEEPING);
        }
    }

    @Override
    protected void interrupted(InterruptedException interruptedException) {
        this.cancelled();
    }

    @Override
    protected void succeeded(Void void_) {
        super.succeeded(void_);
        boolean bl = false;
        boolean bl2 = false;
        if (this.storeFile != null && this.storeFile.exists()) {
            if (this.storeFile.equals(this.outputFile)) {
                this.setCompleted();
                return;
            }
            if (this.outputFile.exists()) {
                int n = 0;
                try {
                    n = this.fileAlreadyExistsProperty();
                }
                catch (InvocationTargetException invocationTargetException) {
                    LogUtils.processException(logger, invocationTargetException);
                }
                catch (InterruptedException interruptedException) {
                    LogUtils.processException(logger, interruptedException);
                }
                switch (n) {
                    case 1: {
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 0: {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.runMoveFileTask(bl2);
        } else {
            this.setCompleted();
            if (this.storeFile != null && this.storeFile.exists()) {
                this.storeFile.delete();
            }
        }
    }

    private int checkExists() throws InvocationTargetException, InterruptedException {
        if (!this.outputFile.exists()) {
            return -2;
        }
        return this.fileAlreadyExistsProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int fileAlreadyExistsProperty() throws InvocationTargetException, InterruptedException {
        if (this.fileAlreadyExists != -2) {
            return this.fileAlreadyExists;
        }
        final int[] nArray = new int[]{AppPrefs.getProperty("whatToDoIfFileAlreadyExists", 3)};
        if (nArray[0] != 3) return nArray[0];
        Class<DownloadTask> clazz = DownloadTask.class;
        synchronized (DownloadTask.class) {
            if (EventQueue.isDispatchThread()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.showFileAlreadyExistsDialog();
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nArray[0] = DownloadTask.this.showFileAlreadyExistsDialog();
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return nArray[0];
        }
    }

    private int showFileAlreadyExistsDialog() {
        return Swinger.showOptionDialog(this.getResourceMap(), 3, "fileAlreadyExists", new String[]{"renameFile", "overWriteFile", "skipFile"}, this.outputFile);
    }

    private void setCompleted() {
        this.downloadFile.setCompleteTaskDuration(this.getExecutionDuration(TimeUnit.SECONDS));
        this.downloadFile.setState(DownloadState.COMPLETED);
    }

    private void runMoveFileTask(boolean bl) {
        MoveFileTask moveFileTask = new MoveFileTask(this.getApplication(), this.storeFile, this.downloadFile.getOutputFile(), true, bl, this.downloadFile);
        moveFileTask.addTaskListener(new TaskListener.Adapter<Void, Void>(){
            public boolean succeeded = false;

            @Override
            public void finished(TaskEvent<Void> taskEvent) {
                super.succeeded(taskEvent);
                if (this.succeeded) {
                    DownloadTask.this.doAllSucceededActions();
                }
            }

            @Override
            public void succeeded(TaskEvent<Void> taskEvent) {
                this.succeeded = true;
                DownloadTask.this.setCompleted();
            }

            @Override
            public void failed(TaskEvent<Throwable> taskEvent) {
                DownloadTask.this.downloadFile.setState(DownloadState.ERROR);
                DownloadTask.this.downloadFile.setErrorMessage(DownloadTask.this.getResourceMap().getString("transferFailed", taskEvent.getValue().getMessage()));
                Sound.playSound(DownloadTask.this.getContext().getResourceMap().getString("errorWav", new Object[0]));
            }

            @Override
            public void cancelled(TaskEvent<Void> taskEvent) {
                DownloadTask.this.downloadFile.setState(DownloadState.CANCELLED);
            }

            @Override
            public void interrupted(TaskEvent<InterruptedException> taskEvent) {
                DownloadTask.this.downloadFile.setState(DownloadState.CANCELLED);
            }
        });
        MainApp mainApp = (MainApp)this.getApplication();
        TaskServiceManager taskServiceManager = mainApp.getManagerDirector().getTaskServiceManager();
        taskServiceManager.getTaskService("moveFile").execute(moveFileTask);
    }

    private void doAllSucceededActions() {
        Application application = this.getApplication();
        boolean bl = this.isAllComplete(application);
        if (bl) {
            boolean bl2 = AppPrefs.getProperty("playSoundOK", true);
            if (bl2) {
                Sound.playSound(this.getContext().getResourceMap().getString("doneWav", new Object[0]));
            }
            this.checkShutDown(application);
        }
    }

    private void checkShutDown(Application application) {
        if (AppPrefs.getProperty("autoshutdown", 0) != 0) {
            application.getContext().getTaskService().execute(new CloseInTimeTask(application));
        }
    }

    private boolean isAllComplete(Application application) {
        return ((MainApp)application).getManagerDirector().getDataManager().checkComplete();
    }

    @Override
    public void sleep(int n) throws InterruptedException {
        this.setSleep(0);
        this.downloadFile.setState(DownloadState.WAITING);
        this.downloadFile.setTimeToQueuedMax(n);
        logger.info("Going to sleep on " + n + " seconds");
        for (int i = n; i > 0 && !this.isTerminated(); --i) {
            this.setSleep(i);
            Thread.sleep(1000L);
        }
    }

    @Override
    public HttpFile getDownloadFile() {
        return this.downloadFile;
    }

    @Override
    public HttpDownloadClient getClient() {
        return this.client;
    }

    public DownloadTaskError getServiceError() {
        return this.serviceError;
    }

    private void setServiceError(DownloadTaskError downloadTaskError) {
        this.serviceError = downloadTaskError;
    }

    public int getYouHaveToSleepSecondsTime() {
        return this.youHaveToSleepSecondsTime;
    }

    @Override
    public BufferedImage getCaptchaImage(String string) throws FailedToLoadCaptchaPictureException {
        GetMethod getMethod = this.client.getGetMethod(string);
        try {
            InputStream inputStream = this.client.makeRequestForFile((HttpMethod)getMethod);
            if (inputStream == null) {
                throw new FailedToLoadCaptchaPictureException();
            }
            return this.loadCaptcha(inputStream);
        }
        catch (FailedToLoadCaptchaPictureException failedToLoadCaptchaPictureException) {
            throw failedToLoadCaptchaPictureException;
        }
        catch (Exception exception) {
            throw new FailedToLoadCaptchaPictureException(exception);
        }
    }

    private BufferedImage loadCaptcha(InputStream inputStream) throws FailedToLoadCaptchaPictureException {
        if (inputStream == null) {
            throw new NullPointerException("InputStreamForCaptchaIsNull");
        }
        try {
            return ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            throw new FailedToLoadCaptchaPictureException("ReadingCaptchaPictureFailed", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String askForCaptcha(final BufferedImage bufferedImage) throws Exception {
        Object object = captchaLock;
        synchronized (object) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (AppPrefs.getProperty("activateOnCaptcha", true)) {
                        Swinger.bringToFront(DownloadTask.this.getMainFrame(), true);
                    }
                    DownloadTask.this.captchaResult = "";
                    while (DownloadTask.this.captchaResult.isEmpty()) {
                        DownloadTask.this.captchaResult = (String)JOptionPane.showInputDialog(null, DownloadTask.this.getResourceMap().getString("InsertWhatYouSee", new Object[0]), DownloadTask.this.getResourceMap().getString("InsertCaptcha", new Object[0]), -1, new ImageIcon(bufferedImage), null, null);
                        if (DownloadTask.this.captchaResult != null) continue;
                        break;
                    }
                }
            });
        }
        bufferedImage.flush();
        return this.captchaResult;
    }

    @Override
    public String getCaptcha(String string) throws FailedToLoadCaptchaPictureException {
        try {
            return this.askForCaptcha(this.getCaptchaImage(string));
        }
        catch (FailedToLoadCaptchaPictureException failedToLoadCaptchaPictureException) {
            throw failedToLoadCaptchaPictureException;
        }
        catch (Exception exception) {
            throw new FailedToLoadCaptchaPictureException(exception);
        }
    }
}

