/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public abstract class URLTransferHandler
extends TransferHandler {
    private static final Pattern REGEXP_URL = Pattern.compile("((http|https)://)?([a-zA-Z0-9\\.\\-]+(:[a-zA-Z0-9\\.:&%\\$\\-]+)*@)?((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9])|([a-zA-Z0-9\\-]+\\.)*[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,4})(:[0-9]+)?(/[^/][a-zA-Z0-9\\.:,\\?'\\\\/\\+&%\\$#=~_\\-@]*)*", 8);
    private static final String URL_LIST_MIME_TYPE = "application/x-java-url; class=java.net.URL";
    private static final Logger logger = Logger.getLogger(URLTransferHandler.class.getName());
    private List<URL> urls;
    private PluginsManager pluginsManager;

    protected abstract void doDropAction(List<URL> var1);

    public URLTransferHandler(ManagerDirector managerDirector) {
        this.pluginsManager = managerDirector.getPluginsManager();
    }

    private List<URL> textURIListToFileList(String string) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        Matcher matcher = REGEXP_URL.matcher(string);
        int n = 0;
        while (matcher.find(n)) {
            try {
                URL uRL;
                String string2 = matcher.group();
                if (!string2.startsWith("http://")) {
                    string2 = "http://" + string2;
                }
                if (this.pluginsManager.isSupported(uRL = new URL(string2))) {
                    linkedList.add(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            n = matcher.end();
        }
        return linkedList;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        return super.importData(jComponent, transferable);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return super.canImport(jComponent, dataFlavorArray);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return super.canImport(transferSupport);
        }
        for (DataFlavor dataFlavor : transferSupport.getDataFlavors()) {
            if (dataFlavor.isFlavorTextType()) {
                return true;
            }
            if (!dataFlavor.isMimeTypeEqual(URL_LIST_MIME_TYPE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Transferable transferable = transferSupport.getTransferable();
        logger.info("Trying to import:" + transferable);
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor(URL_LIST_MIME_TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogUtils.processException(logger, classNotFoundException);
        }
        try {
            this.urls = new LinkedList<URL>();
            if (dataFlavor != null && transferable.isDataFlavorSupported(dataFlavor)) {
                try {
                    URL uRL;
                    Object object = transferable.getTransferData(dataFlavor);
                    if (object instanceof URL && this.pluginsManager.isSupported(uRL = (URL)object)) {
                        this.urls.add(uRL);
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {}
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.urls = this.textURIListToFileList(string);
            }
            if (this.urls.isEmpty()) {
                logger.info("Importing drag and drop failed or unsupported.");
                this.doDropAction(new LinkedList<URL>());
                return false;
            }
            logger.info("Imported files " + Arrays.toString(this.urls.toArray()));
            this.doDropAction(this.urls);
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LogUtils.processException(logger, unsupportedFlavorException);
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
        }
        return false;
    }

    public List<URL> getUrls() {
        return this.urls;
    }
}

