/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.SpinnerAdapterFactory;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.l2fprod.common.swing.JButtonBar;
import com.l2fprod.common.swing.plaf.ButtonBarUI;
import com.l2fprod.common.swing.plaf.blue.BlueishButtonBarUI;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.Lng;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.SupportedLanguage;
import cz.vity.freerapid.core.UserProp;
import cz.vity.freerapid.gui.MyPreferencesAdapter;
import cz.vity.freerapid.gui.MyPresentationModel;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.ConnectDialog;
import cz.vity.freerapid.gui.dialogs.LanguageAdapter;
import cz.vity.freerapid.gui.dialogs.LookAndFeelAdapter;
import cz.vity.freerapid.gui.dialogs.filechooser.OpenSaveDialogFactory;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.swing.LaF;
import cz.vity.freerapid.swing.LookAndFeels;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class UserPreferencesDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(UserPreferencesDialog.class.getName());
    private MyPresentationModel model;
    private static final String CARD_PROPERTY = "card";
    private static final String LAF_PROPERTY = "lafFakeProperty";
    private static final String LNG_PROPERTY = "lngFakeProperty";
    private ResourceMap bundle;
    private final ApplicationContext context;
    private ClientManager clientManager;
    private boolean updateDefaultConnection;
    private JButton btnOK;
    private JButton btnCancel;
    private JButton btnCreateDesktopShortcut;
    private JButton btnCreateStartMenuShortcut;
    private JButton btnCreateQuickLaunchShortcut;
    private JButton btnCreateStartupShortcut;
    private JPanel panelCard;
    private JCheckBox checkForNewVersion;
    private JCheckBox checkAllowOnlyOneInstance;
    private JCheckBox checkContinueInterrupted;
    private JCheckBox checkAutoShutDownDisabledWhenExecuted;
    private JComboBox comboFileExists;
    private JComboBox comboRemoveCompleted;
    private JCheckBox checkPlaySoundInCaseOfError;
    private JCheckBox checkPlaySoundWhenComplete;
    private JComboBox comboLaF;
    private JComboBox comboLng;
    private JCheckBox checkDecoratedFrames;
    private JCheckBox checkAnimateIcon;
    private JCheckBox checkShowIconInSystemTray;
    private JCheckBox checkHideWhenMinimized;
    private JCheckBox checkGenerateTXTDescription;
    private JCheckBox checkGenerateDescIon;
    private JCheckBox checkGenerateHidden;
    private JCheckBox checkUseHistory;
    private JCheckBox checkConfirmExiting;
    private JCheckBox checkConfirmFileDeletion;
    private JCheckBox checkConfirmFileRemove;
    private JCheckBox checkConfirmDownloadingRemoveOnly;
    private JCheckBox checkShowHorizontalLinesInTable;
    private JCheckBox checkShowVerticalLinesInTable;
    private JCheckBox checkPrepareFile;
    private JCheckBox checkCloseToTray;
    private JCheckBox checkUseDefaultConnection;
    private JSpinner spinnerMaxConcurrentDownloads;
    private JCheckBox checkUseProxyList;
    private JCheckBox checkShowTitle;
    private JCheckBox checkProcessFromTop;
    private JTextField fieldProxyListPath;
    private JButton btnProxyListPathSelect;
    private JButton btnSelectConnectionProxy;
    private JSpinner spinnerErrorAttemptsCount;
    private JSpinner spinnerAutoReconnectTime;
    private JButtonBar toolbar;

    public UserPreferencesDialog(Frame frame, ApplicationContext applicationContext) throws Exception {
        super(frame, true);
        this.context = applicationContext;
        this.updateDefaultConnection = false;
        this.clientManager = ((MainApp)applicationContext.getApplication()).getManagerDirector().getClientManager();
        this.setName("UserPreferencesDialog");
        this.bundle = this.getResourceMap();
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            this.doClose();
            throw exception;
        }
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOK;
    }

    private void build() throws CloneNotSupportedException {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.btnOK, "okBtnAction");
        this.setAction(this.btnCancel, "cancelBtnAction");
        this.setAction(this.btnSelectConnectionProxy, "btnSelectConnectionProxy");
        this.setAction(this.btnCreateDesktopShortcut, "createDesktopShortcut");
        this.setAction(this.btnCreateQuickLaunchShortcut, "createQuickLaunchShortcut");
        this.setAction(this.btnCreateStartMenuShortcut, "createStartMenuShortcut");
        this.setAction(this.btnCreateStartupShortcut, "createStartupShortcut");
        this.setDefaultValues();
        this.showCard(Card.valueOf(AppPrefs.getProperty("userSettingsSelectedCard", Card.CARD1.toString())));
        this.pack();
        this.setResizable(true);
        UserPreferencesDialog.locateOnOpticalScreenCenter(this);
    }

    @Action
    public void btnSelectProxyListAction() {
        File[] fileArray = OpenSaveDialogFactory.getInstance(this.context).getChooseProxyList();
        if (fileArray.length > 0) {
            this.fieldProxyListPath.setText(fileArray[0].getAbsolutePath());
            Swinger.inputFocus(this.fieldProxyListPath);
        }
    }

    private void buildGUI() {
        this.toolbar.setUI((ButtonBarUI)new BlueishButtonBarUI());
        ActionMap actionMap = this.getActionMap();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.addButton(actionMap.get("generalBtnAction"), Card.CARD1, buttonGroup);
        this.addButton(actionMap.get("connectionsBtnAction"), Card.CARD2, buttonGroup);
        this.addButton(actionMap.get("soundBtnAction"), Card.CARD3, buttonGroup);
        this.addButton(actionMap.get("viewsBtnAction"), Card.CARD4, buttonGroup);
        this.addButton(actionMap.get("miscBtnAction"), Card.CARD5, buttonGroup);
        this.setAction(this.btnProxyListPathSelect, "btnSelectProxyListAction");
    }

    @Action
    public void btnSelectConnectionProxy() {
        ConnectDialog connectDialog = new ConnectDialog(this);
        this.getApp().prepareDialog(connectDialog, true);
        if (connectDialog.getModalResult() == 0) {
            this.model.setBuffering(true);
            this.updateDefaultConnection = true;
        }
    }

    private void addButton(javax.swing.Action action, Card card, ButtonGroup buttonGroup) {
        JToggleButton jToggleButton = new JToggleButton(action);
        Dimension dimension = jToggleButton.getPreferredSize();
        Dimension dimension2 = new Dimension(66, dimension.height);
        jToggleButton.setFont(jToggleButton.getFont().deriveFont(10.0f));
        jToggleButton.setForeground(Color.BLACK);
        jToggleButton.setMinimumSize(dimension2);
        jToggleButton.setPreferredSize(dimension2);
        jToggleButton.setHorizontalTextPosition(0);
        jToggleButton.setVerticalTextPosition(3);
        jToggleButton.setOpaque(false);
        this.toolbar.add((Component)jToggleButton);
        jToggleButton.putClientProperty(CARD_PROPERTY, (Object)card);
        buttonGroup.add(jToggleButton);
    }

    private void showCard(Card card) {
        String string;
        assert (card != null);
        CardLayout cardLayout = (CardLayout)this.panelCard.getLayout();
        cardLayout.show(this.panelCard, card.toString());
        AppPrefs.storeProperty("userSettingsSelectedCard", card.toString());
        switch (card) {
            case CARD1: {
                string = "generalBtnAction";
                break;
            }
            case CARD2: {
                string = "connectionsBtnAction";
                break;
            }
            case CARD3: {
                string = "soundBtnAction";
                break;
            }
            case CARD4: {
                string = "viewsBtnAction";
                break;
            }
            case CARD5: {
                string = "miscBtnAction";
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        javax.swing.Action action = this.getActionMap().get(string);
        assert (action != null);
        action.putValue("SwingSelectedKey", Boolean.TRUE);
    }

    private void buildModels() throws CloneNotSupportedException {
        this.model = new MyPresentationModel(null, (ValueModel)new Trigger());
        this.bindBasicComponents();
        ActionMap actionMap = this.getActionMap();
        javax.swing.Action action = actionMap.get("okBtnAction");
        PropertyConnector propertyConnector = PropertyConnector.connect((Object)((Object)this.model), (String)"buffering", (Object)action, (String)"enabled");
        propertyConnector.updateProperty2();
    }

    private void bindBasicComponents() {
        this.bind(this.checkAllowOnlyOneInstance, "oneinstance", (Object)true);
        this.bind(this.checkForNewVersion, "checkForNewVersionAuto", (Object)true);
        this.bind(this.checkContinueInterrupted, "downloadOnStart", (Object)true);
        this.bind(this.checkUseHistory, "useHistory", (Object)true);
        this.bind(this.checkAutoShutDownDisabledWhenExecuted, "autoshutdownDisabledWhenExecuted", (Object)true);
        this.bind(this.spinnerMaxConcurrentDownloads, "maxDownloadsAtATime", UserProp.MAX_DOWNLOADS_AT_A_TIME_DEFAULT, 1, 9, 1);
        this.bind(this.spinnerErrorAttemptsCount, "errorAttemptsCount", UserProp.MAX_DOWNLOADS_AT_A_TIME_DEFAULT, -1, 999, 1);
        this.bind(this.spinnerAutoReconnectTime, "autoReconnectTime", 120, 1, 10000, 10);
        this.bind(this.checkProcessFromTop, "startDownloadFromTheTop", (Object)true);
        ValueModel valueModel = this.bind(this.checkUseProxyList, "useProxyList", (Object)false);
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.fieldProxyListPath, (String)"enabled");
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.btnProxyListPathSelect, (String)"enabled");
        this.bind(this.fieldProxyListPath, "proxyListPath", (Object)"");
        this.bind(this.checkPlaySoundWhenComplete, "playSoundOK", (Object)true);
        this.bind(this.checkPlaySoundInCaseOfError, "playSoundsFailed", (Object)true);
        this.bind(this.checkDecoratedFrames, "decoratedFrames", (Object)false);
        this.bind(this.checkHideWhenMinimized, "minimizeToTray", (Object)false);
        this.bind(this.checkAnimateIcon, "animateIcon", (Object)true);
        this.bind(this.checkShowTitle, "showInfoInFrameTitle", (Object)false);
        this.bind(this.checkConfirmExiting, "confirmExit", (Object)true);
        this.bind(this.checkConfirmFileDeletion, "confirmFileDelete", (Object)true);
        ValueModel valueModel2 = this.bind(this.checkConfirmFileRemove, "confirmRemove", (Object)true);
        this.bind(this.checkConfirmDownloadingRemoveOnly, "confirmDownloadingRemove", (Object)false);
        PropertyConnector.connectAndUpdate((ValueModel)valueModel2, (Object)this.checkConfirmDownloadingRemoveOnly, (String)"enabled");
        this.bind(this.checkShowHorizontalLinesInTable, "showHorizontalGridLines", (Object)false);
        this.bind(this.checkShowVerticalLinesInTable, "showVerticalGridLines", (Object)false);
        this.bind(this.checkGenerateTXTDescription, "generateDescriptionByFileName", (Object)false);
        this.bind(this.checkGenerateDescIon, "generateDescript-ionFile", (Object)false);
        this.bind(this.checkGenerateHidden, "descriptionFilesHidden", (Object)false);
        this.bind(this.checkPrepareFile, "preCreateFile", (Object)false);
        this.bind(this.checkCloseToTray, "minimizeOnClose", (Object)false);
        ValueModel valueModel3 = this.bind(this.checkUseDefaultConnection, "useDefaultConnection", (Object)true);
        PropertyConnector.connectAndUpdate((ValueModel)valueModel3, (Object)this.btnSelectConnectionProxy, (String)"enabled");
        valueModel = this.bind(this.checkShowIconInSystemTray, "showTray", (Object)true);
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.checkAnimateIcon, (String)"enabled");
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.checkCloseToTray, (String)"enabled");
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.checkHideWhenMinimized, (String)"enabled");
        this.bind(this.comboFileExists, "whatToDoIfFileAlreadyExists", (Object)3, "fileAlreadyExistsOptions");
        this.bind(this.comboRemoveCompleted, "removeCompletedDownloads", (Object)0, "removeCompletedOptions");
        this.bindLaFCombobox();
        this.bindLngCombobox();
    }

    private void bindLaFCombobox() {
        LookAndFeels lookAndFeels = LookAndFeels.getInstance();
        ArrayListModel arrayListModel = new ArrayListModel(lookAndFeels.getAvailableLookAndFeels());
        LookAndFeelAdapter lookAndFeelAdapter = new LookAndFeelAdapter(LAF_PROPERTY, lookAndFeels.getSelectedLaF());
        SelectionInList selectionInList = new SelectionInList((ListModel)arrayListModel, (ValueModel)this.model.getBufferedModel(lookAndFeelAdapter));
        Bindings.bind((JComboBox)this.comboLaF, (SelectionInList)selectionInList);
    }

    private void bindLngCombobox() {
        ArrayListModel arrayListModel = new ArrayListModel(Lng.getSupportedLanguages());
        LanguageAdapter languageAdapter = new LanguageAdapter(LNG_PROPERTY, Lng.getSelectedLanguage());
        SelectionInList selectionInList = new SelectionInList((ListModel)arrayListModel, (ValueModel)this.model.getBufferedModel(languageAdapter));
        Bindings.bind((JComboBox)this.comboLng, (SelectionInList)selectionInList);
        this.comboLng.setRenderer(new LanguageComboCellRenderer(this.context));
    }

    private void bind(JSpinner jSpinner, String string, int n, int n2, int n3, int n4) {
        jSpinner.setModel(SpinnerAdapterFactory.createNumberAdapter((ValueModel)this.model.getBufferedPreferences(string, n), (int)n, (int)n2, (int)n3, (int)n4));
    }

    private ValueModel bind(JCheckBox jCheckBox, String string, Object object) {
        ValueModel valueModel = this.model.getBufferedPreferences(string, object);
        Bindings.bind((JCheckBox)jCheckBox, (ValueModel)valueModel);
        return valueModel;
    }

    private void bind(JTextField jTextField, String string, Object object) {
        Bindings.bind((JTextField)jTextField, (ValueModel)this.model.getBufferedPreferences(string, object), (boolean)false);
    }

    private void bind(JComboBox jComboBox, String string, Object object, String string2) {
        String[] stringArray = this.getList(string2);
        if (stringArray == null) {
            throw new IllegalArgumentException("Property '" + string2 + "' does not provide any string list from resource map.");
        }
        this.bind(jComboBox, string, object, stringArray);
    }

    private void bind(JComboBox jComboBox, String string, Object object, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("List of combobox values cannot be null!!");
        }
        MyPreferencesAdapter myPreferencesAdapter = new MyPreferencesAdapter(string, object);
        SelectionInList selectionInList = new SelectionInList((Object[])stringArray, (ValueModel)new ValueHolder((Object)stringArray[(Integer)myPreferencesAdapter.getValue()]), (ValueModel)this.model.getBufferedModel(myPreferencesAdapter));
        Bindings.bind((JComboBox)jComboBox, (SelectionInList)selectionInList);
    }

    private void setDefaultValues() {
    }

    @Action
    public void okBtnAction() {
        SupportedLanguage supportedLanguage;
        boolean bl = this.isBuffering("proxyListPath") || this.isBuffering("useProxyList");
        this.updateDefaultConnection = this.updateDefaultConnection || this.isBuffering("useDefaultConnection");
        this.model.triggerCommit();
        LaF laF = LookAndFeels.getInstance().getSelectedLaF();
        LaF laF2 = (LaF)this.comboLaF.getSelectedItem();
        if (laF2 != null && !laF.equals((Object)laF2)) {
            this.updateLookAndFeel();
        }
        if (!(supportedLanguage = Lng.getSelectedLanguage()).equals(this.comboLng.getSelectedItem())) {
            this.updateLng();
        }
        if (this.updateDefaultConnection && bl) {
            this.clientManager.updateConnectionSettings();
        } else {
            if (this.updateDefaultConnection) {
                this.clientManager.updateDefaultConnection();
            }
            if (bl) {
                this.clientManager.updateProxyConnectionList();
            }
        }
        this.doClose();
    }

    private boolean isBuffering(String string) {
        return this.model.getBufferedModel(string).isBuffering();
    }

    private void updateLng() {
        AppPrefs.storeProperty("selLanguage", ((SupportedLanguage)this.comboLng.getSelectedItem()).getLanguageCode());
        AppPrefs.storeProperty("country", ((SupportedLanguage)this.comboLng.getSelectedItem()).getCountry());
        Swinger.showInformationDialog(this.getResourceMap().getString("changeLanguageAfterRestart", new Object[0]));
    }

    @Action
    public void cancelBtnAction() {
        this.doClose();
    }

    @Action(selectedProperty="generalBtnActionSelected")
    public void generalBtnAction(ActionEvent actionEvent) {
        this.showCard(actionEvent);
    }

    @Action
    public void connectionsBtnAction(ActionEvent actionEvent) {
        this.showCard(actionEvent);
    }

    @Action
    public void soundBtnAction(ActionEvent actionEvent) {
        this.showCard(actionEvent);
    }

    private void showCard(ActionEvent actionEvent) {
        this.showCard((Card)((Object)((JComponent)actionEvent.getSource()).getClientProperty(CARD_PROPERTY)));
    }

    public boolean isGeneralBtnActionSelected() {
        return true;
    }

    @Action
    public void viewsBtnAction(ActionEvent actionEvent) {
        this.showCard(actionEvent);
    }

    @Action
    public void miscBtnAction(ActionEvent actionEvent) {
        this.showCard(actionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose() {
        AppPrefs.removeProperty(LAF_PROPERTY);
        logger.log(Level.FINE, "Closing UserPreferenceDialog.");
        try {
            if (this.model != null) {
                this.model.release();
            }
        }
        finally {
            super.doClose();
        }
    }

    @Action
    public void createDesktopShortcut() {
        this.createShortcut(OSCommand.CREATE_DESKTOP_SHORTCUT);
    }

    @Action
    public void createStartMenuShortcut() {
        this.createShortcut(OSCommand.CREATE_STARTMENU_SHORTCUT);
    }

    @Action
    public void createStartupShortcut() {
        this.createShortcut(OSCommand.CREATE_STARTUP_SHORTCUT);
    }

    @Action
    public void createQuickLaunchShortcut() {
        this.createShortcut(OSCommand.CREATE_QUICKLAUNCH_SHORTCUT);
    }

    private void createShortcut(OSCommand oSCommand) {
        SystemCommander systemCommander = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.context);
        if (systemCommander.isSupported(oSCommand)) {
            boolean bl = systemCommander.createShortCut(oSCommand);
            if (!bl) {
                Swinger.showErrorMessage(this.getResourceMap(), "createShortCutFailed", new Object[0]);
            }
        } else {
            Swinger.showErrorMessage(this.context.getResourceMap(), "systemCommandNotSupported", oSCommand.toString().toLowerCase());
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JXButtonPanel jXButtonPanel = new JXButtonPanel();
        this.btnSelectConnectionProxy = new JButton();
        this.btnSelectConnectionProxy.setName("btnSelectConnectionProxy");
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.btnCreateDesktopShortcut = new JButton();
        this.btnCreateStartMenuShortcut = new JButton();
        this.btnCreateQuickLaunchShortcut = new JButton();
        this.btnCreateStartupShortcut = new JButton();
        this.panelCard = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this.checkForNewVersion = new JCheckBox();
        this.checkAllowOnlyOneInstance = new JCheckBox();
        JPanel jPanel6 = new JPanel();
        this.checkContinueInterrupted = new JCheckBox();
        this.checkConfirmExiting = new JCheckBox();
        this.checkConfirmFileDeletion = new JCheckBox();
        this.checkConfirmFileRemove = new JCheckBox();
        this.checkConfirmDownloadingRemoveOnly = new JCheckBox();
        this.checkConfirmExiting.setName("checkConfirmExiting");
        this.checkConfirmFileDeletion.setName("checkConfirmFileDeletion");
        this.checkConfirmFileRemove.setName("checkConfirmFileRemove");
        this.checkConfirmDownloadingRemoveOnly.setName("checkConfirmDownloadingRemoveOnly");
        this.checkAutoShutDownDisabledWhenExecuted = new JCheckBox();
        this.checkProcessFromTop = new JCheckBox();
        this.checkGenerateTXTDescription = new JCheckBox();
        this.checkGenerateDescIon = new JCheckBox();
        this.checkGenerateHidden = new JCheckBox();
        this.checkCloseToTray = new JCheckBox();
        this.checkUseHistory = new JCheckBox();
        this.checkUseDefaultConnection = new JCheckBox();
        this.checkGenerateTXTDescription.setName("checkGenerateTXTDescription");
        this.checkGenerateDescIon.setName("checkGenerateDescIon");
        this.checkGenerateHidden.setName("checkGenerateHidden");
        this.checkCloseToTray.setName("checkCloseToTray");
        this.checkUseDefaultConnection.setName("checkUseDefaultConnection");
        this.checkShowHorizontalLinesInTable = new JCheckBox();
        this.checkShowVerticalLinesInTable = new JCheckBox();
        this.checkShowHorizontalLinesInTable.setName("checkShowHorizontalLinesInTable");
        this.checkShowVerticalLinesInTable.setName("checkShowVerticalLinesInTable");
        this.checkUseHistory.setName("checkUseHistory");
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel2.setName("language");
        jLabel2.setLabelFor(this.comboLng);
        this.comboLng = new JComboBox();
        this.comboRemoveCompleted = new JComboBox();
        this.comboRemoveCompleted.setName("comboRemoveCompleted");
        this.comboLng.setName("comboLng");
        this.comboFileExists = new JComboBox();
        JLabel jLabel3 = new JLabel();
        jLabel3.setLabelFor(this.comboRemoveCompleted);
        jLabel3.setName("labelRemoveCompleted");
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        this.checkPlaySoundInCaseOfError = new JCheckBox();
        this.checkPlaySoundWhenComplete = new JCheckBox();
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel();
        JPanel jPanel14 = new JPanel();
        JPanel jPanel15 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.comboLaF = new JComboBox();
        JLabel jLabel5 = new JLabel();
        this.checkDecoratedFrames = new JCheckBox();
        this.checkShowIconInSystemTray = new JCheckBox();
        this.checkHideWhenMinimized = new JCheckBox();
        JPanel jPanel16 = new JPanel();
        JPanel jPanel17 = new JPanel();
        JLabel jLabel6 = new JLabel();
        this.spinnerMaxConcurrentDownloads = new JSpinner();
        JPanel jPanel18 = new JPanel();
        this.checkUseProxyList = new JCheckBox();
        this.fieldProxyListPath = new JTextField();
        this.btnProxyListPathSelect = new JButton();
        JLabel jLabel7 = new JLabel();
        JPanel jPanel19 = new JPanel();
        JLabel jLabel8 = new JLabel();
        this.spinnerErrorAttemptsCount = new JSpinner();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.spinnerAutoReconnectTime = new JSpinner();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        this.toolbar = new JButtonBar();
        CellConstraints cellConstraints = new CellConstraints();
        this.checkAnimateIcon = new JCheckBox();
        this.checkShowTitle = new JCheckBox();
        this.checkPrepareFile = new JCheckBox();
        this.checkPrepareFile.setName("checkPrepareFile");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jXButtonPanel.setBorder(Borders.createEmptyBorder((String)"5dlu, 4dlu, 4dlu, 4dlu"));
        jXButtonPanel.setCyclic(true);
        this.btnOK.setName("btnOK");
        this.btnCancel.setName("btnCancel");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.GLUE_COLSPEC, new ColumnSpec("max(pref;42dlu)"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.PREF_COLSPEC}, RowSpec.decodeSpecs((String)"pref")), (JPanel)jXButtonPanel);
        ((FormLayout)jXButtonPanel.getLayout()).setColumnGroups((int[][])new int[][]{{2, 4}});
        panelBuilder.add((Component)this.btnOK, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.btnCancel, cellConstraints.xy(4, 1));
        jPanel2.add((Component)jXButtonPanel, "South");
        this.panelCard.setLayout(new CardLayout());
        jPanel3.setBorder(Borders.TABBED_DIALOG_BORDER);
        jPanel4.setBorder(new TitledBorder(null, this.bundle.getString("panelApplicationSettings.border", new Object[0]), 4, 2));
        this.checkForNewVersion.setName("checkForNewVersion");
        this.checkAllowOnlyOneInstance.setName("checkAllowOnlyOneInstance");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(default;70dlu)"), new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel4);
        panelBuilder.add((Component)this.checkForNewVersion, cellConstraints.xyw(3, 1, 4));
        panelBuilder.add((Component)this.checkAllowOnlyOneInstance, cellConstraints.xyw(3, 3, 4));
        panelBuilder.add((Component)this.checkUseHistory, cellConstraints.xyw(3, 5, 4));
        panelBuilder.add((Component)jLabel2, cellConstraints.xyw(3, 7, 1));
        panelBuilder.add((Component)this.comboLng, cellConstraints.xyw(5, 7, 1));
        jPanel5.setBorder(new TitledBorder(null, this.bundle.getString("panelShortcutsSettings.border", new Object[0]), 4, 2));
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(pref;30dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC}), jPanel5);
        panelBuilder.add((Component)this.btnCreateDesktopShortcut, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.btnCreateStartMenuShortcut, cellConstraints.xy(2, 3));
        panelBuilder.add((Component)this.btnCreateQuickLaunchShortcut, cellConstraints.xy(2, 5));
        panelBuilder.add((Component)this.btnCreateStartupShortcut, cellConstraints.xy(2, 7));
        jPanel6.setBorder(new TitledBorder(null, this.bundle.getString("panelDownloadsSettings.border", new Object[0]), 4, 2));
        this.checkContinueInterrupted.setName("checkContinueInterrupted");
        this.checkAutoShutDownDisabledWhenExecuted.setName("checkAutoShutDownDisabledWhenExecuted");
        this.checkProcessFromTop.setName("checkProcessFromTop");
        jLabel.setName("labelIfFilenameExists");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC}), jPanel6);
        panelBuilder.add((Component)this.checkContinueInterrupted, cellConstraints.xywh(3, 1, 7, 1));
        panelBuilder.add((Component)this.checkProcessFromTop, cellConstraints.xywh(3, 2, 7, 1));
        panelBuilder.add((Component)this.checkAutoShutDownDisabledWhenExecuted, cellConstraints.xywh(3, 3, 7, 1));
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(3, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        panelBuilder.add((Component)this.comboFileExists, cellConstraints.xy(5, 5));
        panelBuilder.add((Component)jLabel3, cellConstraints.xywh(7, 5, 1, 1, CellConstraints.RIGHT, CellConstraints.DEFAULT));
        panelBuilder.add((Component)this.comboRemoveCompleted, cellConstraints.xy(9, 5));
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}), jPanel3);
        panelBuilder.add((Component)jPanel4, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jPanel5, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)jPanel6, cellConstraints.xyw(1, 3, 3));
        this.panelCard.add((Component)jPanel3, "CARD1");
        jPanel7.setBorder(Borders.TABBED_DIALOG_BORDER);
        jPanel11.setBorder(new CompoundBorder(new TitledBorder(null, this.bundle.getString("panelSound.border", new Object[0]), 4, 2), Borders.DLU2_BORDER));
        this.checkPlaySoundInCaseOfError.setName("checkPlaySoundInCaseOfError");
        this.checkPlaySoundWhenComplete.setName("checkPlaySoundWhenComplete");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default, default")), jPanel11);
        panelBuilder.add((Component)this.checkPlaySoundInCaseOfError, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.checkPlaySoundWhenComplete, cellConstraints.xy(3, 2));
        panelBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel7);
        jPanel15.setBorder(new CompoundBorder(new TitledBorder(null, this.bundle.getString("panelConfirmation.border", new Object[0]), 4, 2), Borders.DLU2_BORDER));
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)9)), FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel15);
        panelBuilder2.add((Component)this.checkConfirmExiting, cellConstraints.xyw(3, 1, 3));
        panelBuilder2.add((Component)this.checkConfirmFileDeletion, cellConstraints.xy(7, 1));
        panelBuilder2.add((Component)this.checkConfirmFileRemove, cellConstraints.xyw(3, 2, 3));
        panelBuilder2.add((Component)this.checkConfirmDownloadingRemoveOnly, cellConstraints.xy(5, 3));
        panelBuilder.add((Component)jPanel11, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jPanel15, cellConstraints.xy(1, 3));
        this.panelCard.add((Component)jPanel7, "CARD3");
        jPanel8.setBorder(Borders.TABBED_DIALOG_BORDER);
        jPanel9.setBorder(new TitledBorder(null, this.bundle.getString("panelDesc.border", new Object[0]), 4, 2));
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default, default, default")), jPanel9);
        panelBuilder.add((Component)this.checkGenerateDescIon, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.checkGenerateTXTDescription, cellConstraints.xy(3, 2));
        panelBuilder.add((Component)this.checkGenerateHidden, cellConstraints.xy(3, 3));
        jPanel10.setBorder(new TitledBorder(null, this.bundle.getString("panelAdvanced.border", new Object[0]), 4, 2));
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default")), jPanel10);
        panelBuilder.add((Component)this.checkPrepareFile, cellConstraints.xy(3, 1));
        panelBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel8);
        panelBuilder.add((Component)jPanel9, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jPanel10, cellConstraints.xy(1, 3));
        this.panelCard.add((Component)jPanel8, "CARD5");
        jPanel12.setBorder(Borders.TABBED_DIALOG_BORDER);
        jPanel13.setBorder(new CompoundBorder(new TitledBorder(null, this.bundle.getString("panelAppearance.border", new Object[0]), 4, 2), Borders.DLU2_BORDER));
        jLabel4.setName("labelLaF");
        jLabel4.setLabelFor(this.comboLaF);
        jLabel5.setName("labelRequiresRestart2");
        this.checkDecoratedFrames.setName("checkDecoratedFrames");
        this.checkShowTitle.setName("checkShowTitle");
        this.checkProcessFromTop.setName("checkProcessFromTop");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel13);
        panelBuilder.add((Component)jLabel4, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.comboLaF, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)jLabel5, cellConstraints.xy(7, 1));
        panelBuilder.add((Component)this.checkDecoratedFrames, cellConstraints.xywh(3, 2, 5, 1));
        panelBuilder.add((Component)this.checkShowHorizontalLinesInTable, cellConstraints.xywh(3, 5, 5, 1));
        panelBuilder.add((Component)this.checkShowVerticalLinesInTable, cellConstraints.xywh(3, 6, 5, 1));
        panelBuilder.add((Component)this.checkShowTitle, cellConstraints.xywh(3, 7, 5, 1));
        jPanel14.setBorder(new CompoundBorder(new TitledBorder(null, this.bundle.getString("panelSystemTray.border", new Object[0]), 4, 2), Borders.DLU2_BORDER));
        this.checkShowIconInSystemTray.setName("checkShowIconInSystemTray");
        this.checkHideWhenMinimized.setName("checkHideWhenMinimized");
        this.checkAnimateIcon.setName("checkAnimateIcon");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel14);
        panelBuilder.add((Component)this.checkShowIconInSystemTray, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.checkAnimateIcon, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.checkCloseToTray, cellConstraints.xy(3, 2));
        panelBuilder.add((Component)this.checkHideWhenMinimized, cellConstraints.xy(5, 2));
        panelBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0)}), jPanel12);
        panelBuilder.add((Component)jPanel13, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jPanel14, cellConstraints.xy(1, 3));
        this.panelCard.add((Component)jPanel12, "CARD4");
        jPanel16.setBorder(Borders.TABBED_DIALOG_BORDER);
        jPanel17.setBorder(new TitledBorder(null, this.bundle.getString("panelConnections1.border", new Object[0]), 4, 2));
        jLabel6.setName("labelMaxConcurrentDownloads");
        this.spinnerMaxConcurrentDownloads.setModel(new SpinnerNumberModel(0, 0, 5, 1));
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(pref;30dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC}), jPanel17);
        panelBuilder.add((Component)jLabel6, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.spinnerMaxConcurrentDownloads, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.checkUseDefaultConnection, cellConstraints.xyw(3, 2, 5));
        panelBuilder.add((Component)this.btnSelectConnectionProxy, cellConstraints.xy(9, 2));
        jPanel18.setBorder(new TitledBorder(null, this.bundle.getString("panelProxySettings.border", new Object[0]), 4, 2));
        this.checkUseProxyList.setName("checkUseProxyList");
        this.btnProxyListPathSelect.setName("btnProxyListPathSelect");
        jLabel7.setName("labelTextFileFormat");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.dluX((int)200), 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC}), jPanel18);
        panelBuilder.add((Component)this.checkUseProxyList, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.fieldProxyListPath, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.btnProxyListPathSelect, cellConstraints.xy(7, 1));
        panelBuilder.add((Component)jLabel7, cellConstraints.xy(5, 2));
        jPanel19.setBorder(new TitledBorder(null, this.bundle.getString("panelErrorHandling.border", new Object[0]), 4, 2));
        jLabel8.setName("labelErrorAttemptsCount");
        this.spinnerErrorAttemptsCount.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        jLabel9.setName("labelNoAutoreconnect");
        jLabel10.setName("labelAutoReconnectTime");
        this.spinnerAutoReconnectTime.setModel(new SpinnerNumberModel(0, 0, 1000, 5));
        jLabel11.setName("labelSeconds");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.dluX((int)0), 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(pref;30dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC}), jPanel19);
        panelBuilder.add((Component)jLabel8, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.spinnerErrorAttemptsCount, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)jLabel9, cellConstraints.xy(7, 1));
        panelBuilder.add((Component)jLabel10, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.spinnerAutoReconnectTime, cellConstraints.xy(5, 3));
        panelBuilder.add((Component)jLabel11, cellConstraints.xy(7, 3));
        jLabel12.setName("labelRequiresRestart");
        panelBuilder = new PanelBuilder(new FormLayout(ColumnSpec.decodeSpecs((String)"default:grow"), new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.RELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel16);
        panelBuilder.add((Component)jPanel17, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jPanel18, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)jPanel19, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)jLabel12, cellConstraints.xy(1, 7));
        jLabel12.setVisible(false);
        this.panelCard.add((Component)jPanel16, "CARD2");
        jPanel2.add((Component)this.panelCard, "Center");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.toolbar, "North");
        container.add((Component)jPanel, "Center");
    }

    private void updateLookAndFeel() {
        boolean bl;
        ResourceMap resourceMap = this.getResourceMap();
        LaF laF = (LaF)this.comboLaF.getSelectedItem();
        LookAndFeels lookAndFeels = LookAndFeels.getInstance();
        try {
            bl = lookAndFeels.loadLookAndFeel(laF, true);
            lookAndFeels.storeSelectedLaF(laF);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            Swinger.showErrorDialog(resourceMap, "changeLookAndFeelActionFailed", (Throwable)exception);
            bl = false;
        }
        if (bl) {
            Swinger.showInformationDialog(resourceMap.getString("message_changeLookAndFeelActionSet", new Object[0]));
        }
    }

    private static final class LanguageComboCellRenderer
    extends DefaultListCellRenderer {
        private String path;
        private ResourceMap map;

        private LanguageComboCellRenderer(ApplicationContext applicationContext) {
            this.map = applicationContext.getResourceMap();
            this.path = (this.map.getResourcesDir() + this.map.getString("flagsPath", new Object[0])).trim();
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            SupportedLanguage supportedLanguage = (SupportedLanguage)object;
            assert (supportedLanguage != null);
            String string = supportedLanguage.getIcon();
            if (string == null) {
                string = this.map.getString("blank.gif", new Object[0]);
            }
            URL uRL = this.map.getClassLoader().getResource(this.path + string);
            Component component = super.getListCellRendererComponent((JList<?>)jList, supportedLanguage.getName(), n, bl, bl2);
            if (uRL != null) {
                this.setIcon(new ImageIcon(uRL));
            }
            return component;
        }
    }

    private static enum Card {
        CARD1,
        CARD2,
        CARD3,
        CARD4,
        CARD5;

    }
}

