/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.plugins.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.plugins.webclient.ShareDownloadService;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.standard.StandardPluginLocation;
import org.jdesktop.application.ApplicationContext;

public class PluginsManager {
    private static final Logger logger = Logger.getLogger(PluginsManager.class.getName());
    private Map<String, ShareDownloadService> loadedPlugins = new Hashtable<String, ShareDownloadService>();
    private final ApplicationContext context;

    public PluginsManager(ApplicationContext applicationContext) {
        this.context = applicationContext;
        this.loadPlugins();
    }

    private void loadPlugins() {
        logger.info("Init Plugins Manager");
        PluginManager pluginManager = ObjectFactory.newInstance().createManager();
        File file = new File(Utils.getAppPath(), "plugins");
        logger.info("Plugins dir: " + file.getAbsolutePath());
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".frp");
            }
        });
        try {
            Object object;
            if (fileArray == null) {
                throw new IllegalStateException("Plugins directory does not exists");
            }
            PluginManager.PluginLocation[] pluginLocationArray = new PluginManager.PluginLocation[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    String string = PluginsManager.fileToUrl(fileArray[i]).toExternalForm();
                    logger.info("Plugins path:" + (String)string);
                    Object object2 = new URL("jar:" + (String)string + "!/");
                    object = new URL("jar:" + (String)string + "!/plugin.xml");
                    pluginLocationArray[i] = new StandardPluginLocation((URL)object2, (URL)object);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    LogUtils.processException(logger, malformedURLException);
                }
            }
            pluginManager.publishPlugins(pluginLocationArray);
            Collection collection = pluginManager.getRegistry().getPluginDescriptors();
            for (Object object2 : collection) {
                object = object2.getId();
                ShareDownloadService shareDownloadService = (ShareDownloadService)pluginManager.getPlugin((String)object);
                this.loadedPlugins.put(shareDownloadService.getName(), shareDownloadService);
                logger.info("Loaded support for service  " + (String)object);
            }
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            this.context.getApplication().exit();
        }
    }

    private static URL fileToUrl(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public ShareDownloadService getPlugin(String string) throws NotSupportedDownloadServiceException {
        if (!this.loadedPlugins.containsKey(string)) {
            throw new NotSupportedDownloadServiceException(string);
        }
        return this.loadedPlugins.get(string);
    }

    public boolean isSupported(URL uRL) {
        for (ShareDownloadService shareDownloadService : this.loadedPlugins.values()) {
            if (!shareDownloadService.supportsURL(uRL.toExternalForm())) continue;
            return true;
        }
        return false;
    }

    public String getServiceIDForURL(URL uRL) throws NotSupportedDownloadServiceException {
        for (ShareDownloadService shareDownloadService : this.loadedPlugins.values()) {
            if (!shareDownloadService.supportsURL(uRL.toExternalForm())) continue;
            return shareDownloadService.getName();
        }
        throw new NotSupportedDownloadServiceException();
    }
}

