/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.list.ArrayListModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.UserProp;
import cz.vity.freerapid.core.application.GlobalEDTExceptionHandler;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.core.tasks.DownloadTaskError;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.DownloadService;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.ShareDownloadService;
import cz.vity.freerapid.swing.EDTPropertyChangeSupport;
import cz.vity.freerapid.utilities.LogUtils;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.application.TaskService;

public class ProcessManager
extends Thread {
    private static final Logger logger = Logger.getLogger(ProcessManager.class.getName());
    private final ApplicationContext context;
    private DataManager dataManager;
    private final EDTPropertyChangeSupport pcs;
    private volatile Map<String, DownloadService> services = new Hashtable<String, DownloadService>();
    private volatile Map<DownloadFile, ConnectionSettings> forceDownloadFiles = new Hashtable<DownloadFile, ConnectionSettings>();
    private boolean threadSuspended;
    private final Object manipulation = new Object();
    private final Timer errorTimer = new Timer();
    private PluginsManager pluginsManager;
    private volatile int downloading;
    private TaskService taskService;
    private ClientManager clientManager;

    public ProcessManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.dataManager = managerDirector.getDataManager();
        this.pluginsManager = managerDirector.getPluginsManager();
        this.pcs = new EDTPropertyChangeSupport(this);
        this.context = applicationContext;
        this.taskService = managerDirector.getTaskServiceManager().getTaskService("downloadService");
        this.clientManager = managerDirector.getClientManager();
        this.setDownloading(0);
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("maxDownloadsAtATime".equals(preferenceChangeEvent.getKey())) {
                    ProcessManager.this.queueUpdated();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("ProcessManagerThread");
        this.setUncaughtExceptionHandler(new GlobalEDTExceptionHandler());
        while (!this.isInterrupted()) {
            Object object = this.manipulation;
            synchronized (object) {
                if (this.canCreateAnotherConnection(true) && !this.forceDownloadFiles.isEmpty()) {
                    this.execute(this.getFilesForForceDownload(), true);
                }
                if (this.canCreateAnotherConnection(false)) {
                    this.execute(this.getQueued(), false);
                }
            }
            try {
                object = this;
                synchronized (object) {
                    this.threadSuspended = true;
                    logger.info("Test for sleeping");
                    while (this.threadSuspended) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        logger.info("Process Manager thread was interrupted succesfuly");
    }

    private boolean canCreateAnotherConnection(boolean bl) {
        int n = this.getDownloading();
        if (n == 9) {
            return false;
        }
        if (bl) {
            return true;
        }
        int n2 = AppPrefs.getProperty("maxDownloadsAtATime", UserProp.MAX_DOWNLOADS_AT_A_TIME_DEFAULT);
        return n2 > n;
    }

    private LinkedList<DownloadFile> getFilesForForceDownload() {
        return new LinkedList<DownloadFile>(this.forceDownloadFiles.keySet());
    }

    private boolean execute(Collection<DownloadFile> collection, boolean bl) {
        for (DownloadFile downloadFile : collection) {
            Object object;
            ShareDownloadService shareDownloadService;
            logger.info("Getting downloadFile " + downloadFile);
            String string = downloadFile.getShareDownloadServiceID();
            try {
                shareDownloadService = this.pluginsManager.getPlugin(string);
            }
            catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                downloadFile.setState(DownloadState.ERROR);
                downloadFile.setErrorMessage("Not supported service - " + string);
                continue;
            }
            DownloadService downloadService = this.services.get(string);
            if (downloadService == null) {
                downloadService = new DownloadService(shareDownloadService);
                this.services.put(string, downloadService);
            }
            if (!bl) {
                object = this.clientManager.getRotatedEnabledConnections();
                Iterator<ConnectionSettings> iterator = object.iterator();
                while (iterator.hasNext()) {
                    ConnectionSettings connectionSettings = iterator.next();
                    if (!downloadService.canDownloadWith(connectionSettings)) continue;
                    this.queueDownload(downloadFile, connectionSettings, downloadService, shareDownloadService);
                    break;
                }
            } else {
                if (!this.forceDownloadFiles.containsKey(downloadFile)) {
                    throw new IllegalStateException("Cannot find forceDownloaded File");
                }
                object = this.forceDownloadFiles.remove(downloadFile);
                logger.info("Force downloading with settings " + object);
                this.queueDownload(downloadFile, (ConnectionSettings)object, downloadService, shareDownloadService);
            }
            if (this.canCreateAnotherConnection(bl)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDownload(ConnectionSettings connectionSettings, List<DownloadFile> list) {
        Object object = this.manipulation;
        synchronized (object) {
            for (DownloadFile downloadFile : list) {
                if (DownloadState.isProcessState(downloadFile.getState())) continue;
                logger.info("Force downloading file " + downloadFile + " with settings " + connectionSettings);
                this.forceDownloadFiles.put(downloadFile, connectionSettings);
                downloadFile.setState(DownloadState.QUEUED);
            }
        }
        this.queueUpdated();
    }

    private void queueDownload(final DownloadFile downloadFile, ConnectionSettings connectionSettings, DownloadService downloadService, final ShareDownloadService shareDownloadService) {
        if (downloadFile.getState() != DownloadState.QUEUED) {
            logger.info("QUEUED not found - found " + (Object)((Object)downloadFile.getState()));
            return;
        }
        final HttpDownloadClient httpDownloadClient = this.clientManager.popWorkingClient();
        this.setDownloading(this.downloading + 1);
        httpDownloadClient.initClient(connectionSettings);
        downloadService.addDownloadingClient(httpDownloadClient);
        downloadFile.setState(DownloadState.GETTING);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (downloadFile.getState() != DownloadState.GETTING) {
                    ProcessManager.this.finishedDownloading(downloadFile, httpDownloadClient, null);
                } else {
                    ProcessManager.this.startDownload(downloadFile, httpDownloadClient, shareDownloadService);
                }
            }
        });
    }

    private List<DownloadFile> getQueued() {
        ArrayListModel<DownloadFile> arrayListModel = this.dataManager.getDownloadFiles();
        LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
        DownloadFile[] downloadFileArray = (DownloadFile[])arrayListModel.toArray((Object[])new DownloadFile[arrayListModel.size()]);
        boolean bl = AppPrefs.getProperty("startDownloadFromTheTop", true);
        if (bl) {
            for (DownloadFile downloadFile : downloadFileArray) {
                if (downloadFile.getState() != DownloadState.QUEUED) continue;
                linkedList.add(downloadFile);
            }
        } else {
            for (int i = downloadFileArray.length - 1; i >= 0; --i) {
                DownloadFile downloadFile = downloadFileArray[i];
                if (downloadFile.getState() != DownloadState.QUEUED) continue;
                linkedList.add(downloadFile);
            }
        }
        return linkedList;
    }

    private void startDownload(final DownloadFile downloadFile, final HttpDownloadClient httpDownloadClient, ShareDownloadService shareDownloadService) {
        DownloadState downloadState = downloadFile.getState();
        logger.info("starting download in state s = " + (Object)((Object)downloadState));
        try {
            final DownloadTask downloadTask = new DownloadTask(this.context.getApplication(), httpDownloadClient, downloadFile, shareDownloadService);
            downloadFile.setTask(downloadTask);
            downloadTask.addTaskListener(new TaskListener.Adapter<Void, Long>(){

                @Override
                public void finished(TaskEvent<Void> taskEvent) {
                    ProcessManager.this.finishedDownloading(downloadFile, httpDownloadClient, downloadTask);
                    downloadFile.setTask(null);
                }
            });
            this.taskService.execute(downloadTask);
        }
        catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
            LogUtils.processException(logger, notSupportedDownloadServiceException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedDownloading(DownloadFile downloadFile, HttpDownloadClient httpDownloadClient, DownloadTask downloadTask) {
        Object object = this.manipulation;
        synchronized (object) {
            String string = downloadFile.getShareDownloadServiceID();
            DownloadService downloadService = this.services.get(string);
            if (downloadService == null) {
                throw new IllegalStateException("Download service not found:" + string);
            }
            downloadService.finishedDownloading(httpDownloadClient);
            this.clientManager.pushWorkingClient(httpDownloadClient);
            this.setDownloading(this.downloading - 1);
            if (downloadTask != null) {
                DownloadTaskError downloadTaskError = downloadTask.getServiceError();
                ConnectionSettings connectionSettings = httpDownloadClient.getSettings();
                if (downloadTaskError == DownloadTaskError.NO_ROUTE_TO_HOST) {
                    this.clientManager.setConnectionEnabled(connectionSettings, false);
                    if (this.clientManager.getEnabledConnections().size() > 0) {
                        downloadFile.setState(DownloadState.QUEUED);
                    } else {
                        downloadTaskError = DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR;
                    }
                }
                DownloadState downloadState = downloadFile.getState();
                int n = downloadFile.getErrorAttemptsCount();
                if (downloadState == DownloadState.ERROR && n != 0 || downloadState == DownloadState.SLEEPING) {
                    if (downloadTaskError == DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR && n != -1) {
                        downloadFile.setErrorAttemptsCount(0);
                    } else {
                        if (n != -1) {
                            downloadFile.setErrorAttemptsCount(n - 1);
                        }
                        downloadService.addProblematicConnection(connectionSettings);
                        int n2 = this.errorTimer.purge();
                        if (n2 > 0) {
                            logger.info("Purging timer threads count:" + n2);
                        }
                        if (downloadTaskError == DownloadTaskError.YOU_HAVE_TO_WAIT_ERROR) {
                            int n3 = downloadTask.getYouHaveToSleepSecondsTime();
                            this.errorTimer.schedule((TimerTask)new ErrorTimerTask(downloadService, connectionSettings, downloadFile, n3), 0L, 1000L);
                        } else {
                            this.errorTimer.schedule((TimerTask)new ErrorTimerTask(downloadService, connectionSettings, downloadFile), 0L, 1000L);
                        }
                    }
                }
            }
        }
        this.wakeUp();
    }

    public void queueUpdated() {
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        ProcessManager processManager = this;
        synchronized (processManager) {
            this.threadSuspended = false;
            this.notify();
        }
    }

    public int getDownloading() {
        return this.downloading;
    }

    public void setDownloading(int n) {
        int n2 = this.downloading;
        this.downloading = n;
        this.pcs.firePropertyChange("downloading", n2, this.downloading);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private class ErrorTimerTask
    extends TimerTask {
        private int counter;
        private final DownloadService service;
        private final ConnectionSettings settings;
        private final DownloadFile file;
        private long lastTime;

        public ErrorTimerTask(DownloadService downloadService, ConnectionSettings connectionSettings, DownloadFile downloadFile) {
            this(downloadService, connectionSettings, downloadFile, AppPrefs.getProperty("autoReconnectTime", 120));
        }

        public ErrorTimerTask(DownloadService downloadService, ConnectionSettings connectionSettings, DownloadFile downloadFile, int n) {
            this.service = downloadService;
            this.settings = connectionSettings;
            this.file = downloadFile;
            this.counter = n;
            downloadFile.setTimeToQueuedMax(n);
            this.lastTime = System.currentTimeMillis();
        }

        @Override
        public void run() {
            DownloadState downloadState = this.file.getState();
            if (downloadState != DownloadState.ERROR && downloadState != DownloadState.SLEEPING) {
                this.cancel();
                if (downloadState != DownloadState.WAITING) {
                    this.file.setTimeToQueued(-1);
                    this.file.setTimeToQueuedMax(-1);
                }
                this.renewProblematicConnection();
                this.file.resetErrorAttempts();
                ProcessManager.this.queueUpdated();
                return;
            }
            this.file.setTimeToQueued(--this.counter);
            long l = System.currentTimeMillis();
            if (this.counter <= 0 || l - this.lastTime > 60000L) {
                this.file.setTimeToQueued(-1);
                this.file.setTimeToQueuedMax(-1);
                this.renewProblematicConnection();
                this.file.setState(DownloadState.QUEUED);
                this.cancel();
                ProcessManager.this.queueUpdated();
            }
            this.lastTime = l;
        }

        private void renewProblematicConnection() {
            this.service.removeProblematicConnection(this.settings);
        }
    }
}

