/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.model;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.HttpFile;
import cz.vity.freerapid.utilities.LogUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import org.jdesktop.application.AbstractBean;

public class DownloadFile
extends AbstractBean
implements PropertyChangeListener,
HttpFile {
    private static final Logger logger = Logger.getLogger(DownloadFile.class.getName());
    private volatile long fileSize;
    private DownloadTask task = null;
    private volatile DownloadState state = DownloadState.PAUSED;
    private String fileName;
    private long downloaded = 0L;
    private int sleep;
    private float averageSpeed;
    private long speed;
    private volatile String errorMessage;
    private volatile URL fileUrl = null;
    private volatile File saveToDirectory;
    private volatile String description;
    private volatile String fileType;
    private volatile int timeToQueued = -1;
    private volatile int timeToQueuedMax = -1;
    private long completeTaskDuration = -1L;
    private volatile int errorAttemptsCount;
    private volatile String shareDownloadServiceID;
    private volatile String serviceName = null;
    private volatile ConnectionSettings connectionSettings;

    public DownloadFile() {
    }

    public DownloadFile(URL uRL, File file, String string) {
        this.fileUrl = uRL;
        this.saveToDirectory = file;
        this.description = string;
        this.fileSize = -1L;
        String string2 = uRL.toExternalForm();
        this.fileName = FileTypeIconProvider.identifyFileName(string2);
        this.resetErrorAttempts();
        this.sleep = -1;
        this.averageSpeed = 0.0f;
        this.speed = 0L;
        this.timeToQueued = -1;
        this.setFileType(FileTypeIconProvider.identifyFileType(this.fileName));
    }

    public File getSaveToDirectory() {
        return this.saveToDirectory;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(long l) {
        long l2 = this.fileSize;
        this.fileSize = l;
        this.firePropertyChange("fileSize", l2, this.fileSize);
    }

    public DownloadTask getTask() {
        return this.task;
    }

    public void setTask(DownloadTask downloadTask) {
        if (downloadTask == null) {
            if (this.task != null) {
                this.task.removePropertyChangeListener(this);
            }
        } else {
            downloadTask.addPropertyChangeListener(this);
        }
        this.task = downloadTask;
    }

    @Override
    public DownloadState getState() {
        return this.state;
    }

    @Override
    public void setState(DownloadState downloadState) {
        if (this.state == DownloadState.DELETED) {
            return;
        }
        DownloadState downloadState2 = this.state;
        this.state = downloadState;
        logger.info("Setting state to " + downloadState.toString());
        this.firePropertyChange("state", (Object)downloadState2, (Object)this.state);
    }

    @Override
    public URL getFileUrl() {
        return this.fileUrl;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String string) {
        String string2 = this.fileName;
        this.fileName = string;
        this.setFileType(FileTypeIconProvider.identifyFileType(this.fileName));
        this.firePropertyChange("fileName", string2, this.fileName);
    }

    public String toString() {
        return this.fileUrl.toString();
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(long l) {
        long l2 = this.downloaded;
        this.downloaded = l;
        logger.fine("setting downloaded to " + l);
        this.firePropertyChange("downloaded", l2, this.downloaded);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("downloaded".equals(propertyChangeEvent.getPropertyName())) {
            this.setDownloaded((Long)propertyChangeEvent.getNewValue());
        } else if ("sleep".equals(propertyChangeEvent.getPropertyName())) {
            this.setSleep((Integer)propertyChangeEvent.getNewValue());
        } else if ("speed".equals(propertyChangeEvent.getPropertyName())) {
            this.setSpeed((Long)propertyChangeEvent.getNewValue());
        } else if ("averageSpeed".equals(propertyChangeEvent.getPropertyName())) {
            this.setAverageSpeed(((Float)propertyChangeEvent.getNewValue()).floatValue());
        }
    }

    public void setSpeed(long l) {
        long l2 = this.speed;
        this.speed = l;
        this.firePropertyChange("speed", l2, this.speed);
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSleep(int n) {
        int n2 = this.sleep;
        this.sleep = n;
        this.firePropertyChange("sleep", n2, this.sleep);
    }

    public void setAverageSpeed(float f) {
        float f2 = this.averageSpeed;
        this.averageSpeed = f;
        this.firePropertyChange("averageSpeed", Float.valueOf(f2), Float.valueOf(this.averageSpeed));
    }

    @Override
    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public int getSleep() {
        return this.sleep;
    }

    public float getAverageSpeed() {
        return this.averageSpeed;
    }

    public String getServiceName() {
        if (this.serviceName == null) {
            return "";
        }
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public File getOutputFile() {
        return new File(this.getSaveToDirectory(), this.fileName);
    }

    @Override
    public void setFileUrl(URL uRL) {
        this.fileUrl = uRL;
    }

    public void setSaveToDirectory(File file) {
        this.saveToDirectory = file;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.firePropertyChange("description", string2, this.description);
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    public String getShareDownloadServiceID() {
        return this.shareDownloadServiceID;
    }

    public void setTimeToQueued(int n) {
        int n2 = this.timeToQueued;
        this.timeToQueued = n;
        this.firePropertyChange("timeToQueued", n2, this.timeToQueued);
    }

    public int getTimeToQueued() {
        return this.timeToQueued;
    }

    public void setErrorAttemptsCount(int n) {
        this.errorAttemptsCount = n;
    }

    public int getErrorAttemptsCount() {
        return this.errorAttemptsCount;
    }

    public void resetErrorAttempts() {
        this.errorAttemptsCount = AppPrefs.getProperty("errorAttemptsCount", 5);
    }

    public void setShareDownloadServiceID(String string) {
        this.shareDownloadServiceID = string;
        this.serviceName = string.toLowerCase();
    }

    public int getTimeToQueuedMax() {
        return this.timeToQueuedMax;
    }

    public void setTimeToQueuedMax(int n) {
        this.timeToQueuedMax = n;
    }

    public void resetSpeed() {
        this.setSpeed(0L);
        this.setAverageSpeed(0.0f);
    }

    public long getCompleteTaskDuration() {
        return this.completeTaskDuration;
    }

    public void setCompleteTaskDuration(long l) {
        this.completeTaskDuration = l;
    }

    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public void setConnectionSettings(ConnectionSettings connectionSettings) {
        ConnectionSettings connectionSettings2 = this.connectionSettings;
        this.connectionSettings = connectionSettings;
        this.firePropertyChange("connectionSettings", connectionSettings2, connectionSettings);
    }

    static {
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(DownloadFile.class);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                String string = propertyDescriptor.getName();
                if (!"task".equals(string) && !"speed".equals(string) && !"connectionSettings".equals(string)) continue;
                propertyDescriptor.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException introspectionException) {
            LogUtils.processException(logger, introspectionException);
        }
    }
}

