/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class TrayIconSupport
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(TrayIconSupport.class.getName());
    private TrayIcon trayIcon;
    private boolean enabled;
    private WindowAdapter windowAdapter;
    private static final String TITLE_PROPERTY = "title";
    private String toolTip;

    public TrayIconSupport() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("showTray".equals(preferenceChangeEvent.getKey())) {
                    TrayIconSupport.this.setVisibleByDefault();
                }
            }
        });
    }

    public synchronized void setVisible(boolean bl) {
        if (bl && !this.isEnabled()) {
            this.enable();
        } else if (this.isEnabled()) {
            this.disable();
        }
    }

    public synchronized void setVisibleByDefault() {
        this.setVisible(AppPrefs.getProperty("showTray", true));
    }

    private synchronized void enable() {
        if (!SystemTray.isSupported()) {
            logger.log(Level.WARNING, "Cannot enable tray icon - Tray icon is not supported on this system");
            return;
        }
        MainApp mainApp = MainApp.getInstance(MainApp.class);
        ApplicationContext applicationContext = mainApp.getContext();
        ResourceMap resourceMap = applicationContext.getResourceMap();
        final JFrame jFrame = mainApp.getMainFrame();
        this.windowAdapter = new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                if (AppPrefs.getProperty("showTray", true) && AppPrefs.getProperty("minimizeToTray", false)) {
                    jFrame.setVisible(false);
                }
            }
        };
        jFrame.addWindowListener(this.windowAdapter);
        Image image = Utils.isWindows() ? Swinger.getResourceMap().getImageIcon("trayIconImageWin").getImage() : jFrame.getIconImage();
        jFrame.addPropertyChangeListener(TITLE_PROPERTY, this);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.getClickCount() == 2) {
                        TrayIconSupport.this.windowPlay(jFrame, true);
                    } else if (mouseEvent.getClickCount() == 1) {
                        TrayIconSupport.this.windowPlay(jFrame, false);
                    }
                    mouseEvent.consume();
                }
            }
        };
        PopupMenu popupMenu = this.buildPopmenu(mainApp, resourceMap);
        Font font = jFrame.getFont().deriveFont(11.0f);
        popupMenu.setFont(font);
        this.trayIcon = new TrayIcon(image, jFrame.getTitle(), popupMenu);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addMouseListener(mouseAdapter);
        try {
            SystemTray systemTray = SystemTray.getSystemTray();
            systemTray.add(this.trayIcon);
        }
        catch (AWTException aWTException) {
            logger.log(Level.WARNING, "Cannot enable Tray icon - Tray icon is not supported on this system");
        }
        this.setEnabled(true);
    }

    private void windowPlay(JFrame jFrame, boolean bl) {
        int n = jFrame.getExtendedState();
        if ((n & 1) == 1) {
            jFrame.setExtendedState(n &= 0xFFFFFFFE);
            jFrame.setVisible(true);
            jFrame.toFront();
        } else if (!bl) {
            jFrame.setExtendedState(n |= 1);
        }
    }

    private void windowRestore(JFrame jFrame) {
        int n = jFrame.getExtendedState();
        jFrame.setExtendedState(n &= 0xFFFFFFFE);
        jFrame.setVisible(true);
        jFrame.toFront();
    }

    private PopupMenu buildPopmenu(final MainApp mainApp, ResourceMap resourceMap) {
        PopupMenu popupMenu = new PopupMenu();
        MenuItem menuItem = new MenuItem(resourceMap.getString("trayQuit", new Object[0]));
        MenuItem menuItem2 = new MenuItem(resourceMap.getString("trayRestore", new Object[0]));
        final CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(resourceMap.getString("monitorClipboardActionTray", new Object[0]));
        checkboxMenuItem.setState(AppPrefs.getProperty("clipboardMonitoring", false));
        checkboxMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = checkboxMenuItem.getState();
                Action action = mainApp.getContext().getActionMap().get("monitorClipboardAction");
                action.putValue("SwingSelectedKey", bl);
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        });
        final CheckboxMenuItem checkboxMenuItem2 = new CheckboxMenuItem(resourceMap.getString("trayHideWhenMinimized", new Object[0]));
        checkboxMenuItem2.setState(AppPrefs.getProperty("minimizeToTray", false));
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("minimizeToTray".equals(preferenceChangeEvent.getKey())) {
                    checkboxMenuItem2.setState(AppPrefs.getProperty("minimizeToTray", false));
                } else if ("clipboardMonitoring".equals(preferenceChangeEvent.getKey())) {
                    checkboxMenuItem.setState(AppPrefs.getProperty("clipboardMonitoring", false));
                }
            }
        });
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mainApp.exit(actionEvent);
            }
        });
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TrayIconSupport.this.windowRestore(mainApp.getMainFrame());
                    }
                });
            }
        });
        checkboxMenuItem2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = checkboxMenuItem2.getState();
                AppPrefs.storeProperty("minimizeToTray", bl);
            }
        });
        popupMenu.add(menuItem2);
        popupMenu.addSeparator();
        popupMenu.add(checkboxMenuItem);
        popupMenu.addSeparator();
        popupMenu.add(checkboxMenuItem2);
        popupMenu.addSeparator();
        popupMenu.add(menuItem);
        return popupMenu;
    }

    public synchronized void disable() {
        if (!SystemTray.isSupported()) {
            logger.log(Level.WARNING, "Cannot disable Tray icon - Tray icon is not supported on this system");
            return;
        }
        SystemTray systemTray = SystemTray.getSystemTray();
        systemTray.remove(this.trayIcon);
        MainApp mainApp = MainApp.getInstance(MainApp.class);
        JFrame jFrame = mainApp.getMainFrame();
        this.windowRestore(jFrame);
        jFrame.removeWindowFocusListener(this.windowAdapter);
        jFrame.removePropertyChangeListener(TITLE_PROPERTY, this);
        this.trayIcon = null;
        this.setEnabled(false);
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.toolTip != null && this.isEnabled() && TITLE_PROPERTY.equals(propertyChangeEvent.getPropertyName()) && this.trayIcon != null) {
            JFrame jFrame = (JFrame)propertyChangeEvent.getSource();
            this.trayIcon.setToolTip(jFrame.getTitle());
        }
    }

    public void setToolTip(String string) {
        this.toolTip = string;
        if (this.isEnabled()) {
            this.trayIcon.setToolTip(string);
        }
    }

    public void setImage(Image image) {
        if (this.isEnabled()) {
            this.trayIcon.setImage(image);
        }
    }
}

