/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.swing.Swinger;
import java.awt.Desktop;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Browser {
    private static final Logger logger = Logger.getLogger(Browser.class.getName());

    private Browser() {
    }

    public static void openBrowser(String string) {
        assert (string != null);
        if (string.length() <= 0 || !Desktop.isDesktopSupported()) {
            return;
        }
        try {
            URI uRI = new URI(string);
            if (!string.startsWith("mailto")) {
                Desktop.getDesktop().browse(uRI);
            } else {
                Desktop.getDesktop().mail(uRI);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Opening browser failed", exception);
            Swinger.showErrorDialog("errorOpeningBrowser", exception);
        }
    }

    public static void showHomepage() {
        Browser.openBrowser(AppPrefs.getProperty("weburl", "http://wordrider.net/freerapid"));
    }
}

