/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.MainApp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.PropertyOption;
import org.apache.commons.cli2.util.HelpFormatter;

final class CmdLine {
    private final MainApp app;
    private Map<String, String> properties = new HashMap<String, String>(2);
    private boolean resetOptions;
    private boolean minimize;

    CmdLine(MainApp mainApp) {
        this.app = mainApp;
        this.resetOptions = false;
        this.minimize = false;
    }

    private void showVersion() {
        System.out.println("FreeRapid 0.71");
        System.out.println("Authors (c) 2008 Vity");
        this.app.exit();
    }

    public List<String> processCommandLine(String[] stringArray) {
        if (stringArray.length == 0) {
            return new LinkedList<String>();
        }
        DefaultOptionBuilder defaultOptionBuilder = new DefaultOptionBuilder();
        GroupBuilder groupBuilder = new GroupBuilder();
        DefaultOption defaultOption = defaultOptionBuilder.withShortName("h").withShortName("?").withLongName("help").withDescription("print this message").create();
        DefaultOption defaultOption2 = defaultOptionBuilder.withShortName("v").withLongName("version").withDescription("print the version information and exit").create();
        DefaultOption defaultOption3 = defaultOptionBuilder.withShortName("d").withLongName("debug").withDescription("print debugging information").create();
        DefaultOption defaultOption4 = defaultOptionBuilder.withShortName("r").withLongName("reset").withDescription("reset user properties to default values").create();
        DefaultOption defaultOption5 = defaultOptionBuilder.withShortName("m").withLongName("minim").withDescription("minimize main window on start").create();
        PropertyOption propertyOption = new PropertyOption();
        Group group = groupBuilder.withName("options").withOption((Option)defaultOption).withOption((Option)defaultOption2).withOption((Option)defaultOption3).withOption((Option)defaultOption4).withOption((Option)propertyOption).withOption((Option)defaultOption5).create();
        Parser parser = new Parser();
        parser.setGroup(group);
        try {
            CommandLine commandLine = parser.parse(stringArray);
            if (commandLine.hasOption((Option)defaultOption)) {
                this.printHelp(group);
            } else if (commandLine.hasOption((Option)defaultOption2)) {
                this.showVersion();
            } else if (commandLine.hasOption((Option)defaultOption3)) {
                MainApp.debug = true;
            }
            if (commandLine.hasOption((Option)defaultOption4)) {
                this.resetOptions = true;
            }
            if (commandLine.hasOption((Option)defaultOption5)) {
                this.minimize = true;
            }
            Set set = commandLine.getProperties((Option)propertyOption);
            for (String string : set) {
                this.properties.put(string, commandLine.getProperty((Option)propertyOption, string, ""));
            }
        }
        catch (OptionException optionException) {
            optionException.printStackTrace();
            this.printHelp(group);
            System.exit(-1);
        }
        return new LinkedList<String>();
    }

    private void printHelp(Group group) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.getDisplaySettings().add(DisplaySetting.DISPLAY_PROPERTY_OPTION);
        helpFormatter.setGroup(group);
        helpFormatter.setShellCommand("frd");
        helpFormatter.getLineUsageSettings().add(DisplaySetting.DISPLAY_PROPERTY_OPTION);
        helpFormatter.setFooter("\nmin. Java version required : 1.6");
        helpFormatter.print();
        this.app.exit();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isResetOptions() {
        return this.resetOptions;
    }

    public boolean isMinimize() {
        return this.minimize;
    }
}

