/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.SupportedLanguage;
import cz.vity.freerapid.utilities.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class Lng {
    private static final Logger logger = Logger.getLogger(Lng.class.getName());
    private static List<SupportedLanguage> supportedLanguages = null;
    private static final String LANG_LIST_FILE = "languages.properties";
    private static final String LANG_NONAME_ICON = "blank.gif";
    public static final String localeLanguageCode = Locale.getDefault().getLanguage();
    private static String selLanguageCode;
    private static String selCountryCode;
    private static final String localeCountry;

    private Lng() {
    }

    public static synchronized List<SupportedLanguage> getSupportedLanguages() {
        if (supportedLanguages == null) {
            String string;
            String string2;
            supportedLanguages = new LinkedList<SupportedLanguage>();
            Properties properties = Utils.loadProperties(LANG_LIST_FILE, true);
            int n = -1;
            while ((string2 = properties.getProperty(string = "language" + ++n)) != null) {
                Integer n2 = properties.getProperty(string + ".mnemonic", "\u0000").charAt(0);
                String string3 = properties.getProperty(string + ".country", "");
                SupportedLanguage supportedLanguage = new SupportedLanguage(string2, properties.getProperty(string + ".name", "?"), properties.getProperty(string + ".icon", LANG_NONAME_ICON), n2, string3);
                supportedLanguages.add(supportedLanguage);
            }
        }
        return supportedLanguages;
    }

    private static SupportedLanguage findSupportedLanguage(SupportedLanguage supportedLanguage) {
        if ("".equals(supportedLanguage.getCountry())) {
            for (SupportedLanguage supportedLanguage2 : Lng.getSupportedLanguages()) {
                if (!supportedLanguage2.getLanguageCode().equalsIgnoreCase(supportedLanguage.getLanguageCode())) continue;
                return supportedLanguage2;
            }
        } else {
            for (SupportedLanguage supportedLanguage3 : Lng.getSupportedLanguages()) {
                if (!supportedLanguage3.equals(supportedLanguage)) continue;
                return supportedLanguage3;
            }
        }
        return null;
    }

    public static void loadLangProperties() {
        SupportedLanguage supportedLanguage;
        selLanguageCode = AppPrefs.getProperty("selLanguage", null);
        if (selLanguageCode == null) {
            supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(localeLanguageCode, localeCountry));
            if (supportedLanguage == null && (supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(localeLanguageCode, ""))) == null) {
                supportedLanguage = new SupportedLanguage("EN", "");
            }
        } else {
            selCountryCode = AppPrefs.getProperty("country", "");
            supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, selCountryCode));
            if (supportedLanguage == null && (supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, ""))) == null) {
                supportedLanguage = new SupportedLanguage("EN", "");
            }
        }
        selLanguageCode = supportedLanguage.getLanguageCode();
        selCountryCode = supportedLanguage.getCountry();
        Locale locale = new Locale(selLanguageCode.toLowerCase(), ("".equals(selCountryCode) ? localeCountry : selCountryCode).toUpperCase());
        logger.config("Setting locale " + locale);
        Locale.setDefault(locale);
    }

    public static SupportedLanguage getSelectedLanguage() {
        SupportedLanguage supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, selCountryCode));
        if (supportedLanguage == null && (supportedLanguage = Lng.findSupportedLanguage(new SupportedLanguage(selLanguageCode, ""))) == null) {
            supportedLanguage = new SupportedLanguage("EN", "");
        }
        return supportedLanguage;
    }

    static {
        localeCountry = Locale.getDefault().getCountry();
    }
}

