/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.application;

import cz.vity.freerapid.swing.Swinger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class GlobalEDTExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = Logger.getLogger(GlobalEDTExceptionHandler.class.getName());

    @Override
    public void uncaughtException(Thread thread, final Throwable throwable) {
        if (throwable instanceof IllegalStateException && throwable.getMessage().contains("cannot open system")) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            logger.log(Level.SEVERE, "Uncaught exception on EDT. ", throwable);
        } else {
            logger.log(Level.SEVERE, "Uncaught exception on thread " + thread.getName(), throwable);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Swinger.showErrorDialog("errorMessageBasic", throwable, true);
            }
        });
    }
}

