/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.application.ProxyHelper;
import cz.vity.freerapid.core.tasks.ConnectResult;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.jdesktop.application.Application;

public class CheckForNewVersionTask
extends CoreTask<ConnectResult, Void> {
    private static final Logger logger = Logger.getLogger(CheckForNewVersionTask.class.getName());
    private static final String PARAM_VERSION = "version";
    private final boolean showInfoMessages;

    public CheckForNewVersionTask(boolean bl) {
        super(Application.getInstance());
        logger.info("Starting to check for a new version");
        this.showInfoMessages = bl;
        this.setUserCanCancel(false);
        ProxyHelper.initProxy();
    }

    protected ConnectResult doInBackground() throws Exception {
        HttpURLConnection httpURLConnection = null;
        this.message("message.connecting", new Object[0]);
        try {
            String string = AppPrefs.getProperty("checkForNewVersionURL", "http://wordrider.net/checkfrd.php");
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            logger.info("Connected to the web, Writing params");
            dataOutputStream.write(Utils.addParam("", PARAM_VERSION, "FreeRapid 0.71").getBytes());
            this.message("message.connect.status.checking", new Object[0]);
            dataOutputStream.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            logger.info("disconnecting");
            this.message("message.connect.status.disconnect", new Object[0]);
            httpURLConnection.disconnect();
            if (string2 != null && string2.toLowerCase().contains("yes")) {
                return ConnectResult.CONNECT_NEW_VERSION;
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw unknownHostException;
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw iOException;
        }
        return ConnectResult.SAME_VERSION;
    }

    @Override
    protected void succeeded(ConnectResult connectResult) {
        super.succeeded(connectResult);
        switch (connectResult) {
            case SAME_VERSION: {
                if (!this.showInfoMessages) break;
                Swinger.showInformationDialog(this.getResourceMap().getString("message.connect.sameVersion", new Object[0]));
                break;
            }
            case CONNECT_NEW_VERSION: {
                int n = Swinger.getChoiceYesNo(this.getResourceMap().getString("message.connect.newVersion", new Object[0]));
                if (n != 0) break;
                Browser.showHomepage();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    protected void failed(Throwable throwable) {
        if (this.handleRuntimeException(throwable)) {
            return;
        }
        if (!this.showInfoMessages) {
            return;
        }
        if (throwable instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_submit_failed", throwable.getMessage());
        }
    }
}

