/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.plugins.webclient.HttpDownloadClient;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientManager {
    private static final Logger logger = Logger.getLogger(ClientManager.class.getName());
    private final List<ConnectionSettings> availableConnections = new ArrayList<ConnectionSettings>(2);
    private Stack<HttpDownloadClient> workingClientsPool = new Stack();
    private static final String PROXY_LIST_DEFAULT_PATH = new File(Utils.getAppPath(), "proxy.list").getAbsolutePath();
    public static final int MAX_DOWNLOADING = 9;
    private ConnectionSettings defaultConnectionSettings = new ConnectionSettings();
    private int popCount;
    private final Object connectionSettingsLock = new Object();
    private final ManagerDirector managerDirector;
    private int rotate = 0;

    public ClientManager(ManagerDirector managerDirector) {
        this.managerDirector = managerDirector;
        this.popCount = 0;
        this.updateConnectionSettings();
    }

    private void updateProxies() {
        String string;
        File file;
        if (AppPrefs.getProperty("useProxyList", true) && (file = new File(string = AppPrefs.getProperty("proxyListPath", PROXY_LIST_DEFAULT_PATH))).exists() && file.isFile() && file.canRead()) {
            this.readProxyList(file);
        }
    }

    private void updateDefault() {
        if (AppPrefs.getProperty("useDefaultConnection", true)) {
            boolean bl = this.defaultConnectionSettings.isEnabled();
            this.defaultConnectionSettings = new ConnectionSettings();
            this.initDefaultProxySettings(this.defaultConnectionSettings);
            this.defaultConnectionSettings.setEnabled(bl);
            this.availableConnections.add(this.defaultConnectionSettings);
        }
    }

    private void initDefaultProxySettings(ConnectionSettings connectionSettings) {
        String string = System.getProperty("proxySet", "false");
        logger.info("Proxy set system default connection: " + string);
        if (AppPrefs.getProperty("proxy", Boolean.valueOf(string))) {
            String string2 = AppPrefs.getProperty("proxy.url", System.getProperty("proxyHost", "localhost"));
            int n = Integer.valueOf(AppPrefs.getProperty("proxy.port", System.getProperty("proxyPort", "8080")));
            if (AppPrefs.getProperty("proxy.login", false)) {
                String string3 = AppPrefs.getProperty("proxy.username", "");
                String string4 = Utils.generateXorString(AppPrefs.getProperty("proxy.password", ""));
                connectionSettings.setProxy(string2, n, string3, string4);
            } else {
                connectionSettings.setProxy(string2, n);
            }
            logger.info("Setting proxy configuration ON with configuration: " + connectionSettings.toString());
        } else {
            logger.info("Setting proxy configuration OFF for default connection");
        }
    }

    private void readProxyList(File file) {
        String[] stringArray;
        Pattern pattern = Pattern.compile("((\\w*)(:(.*?))?@)?(.*?):(\\d{2,5})");
        for (String string : stringArray = Utils.loadFile(file).split("(\\s)")) {
            if (string.isEmpty()) continue;
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                String[] stringArray2;
                String string2;
                String[] stringArray3;
                int n = string.lastIndexOf(64);
                ConnectionSettings connectionSettings = new ConnectionSettings();
                if (n >= 0) {
                    stringArray3 = string.substring(0, n);
                    string2 = string.substring(n + 1);
                    n = stringArray3.indexOf(58);
                    stringArray2 = string2.split(":");
                    Integer n2 = Integer.valueOf(stringArray2[1]);
                    if (n2 > 65535) continue;
                    if (n > 0) {
                        connectionSettings.setProxy(stringArray2[0], n2, stringArray3.substring(0, n), stringArray3.substring(n + 1));
                    } else {
                        connectionSettings.setProxy(stringArray2[0], n2, (String)stringArray3, null);
                    }
                } else {
                    string2 = string;
                    stringArray3 = string2.split(":");
                    stringArray2 = Integer.valueOf(stringArray3[1]);
                    if (stringArray2.intValue() > 65535) continue;
                    connectionSettings.setProxy(stringArray3[0], stringArray2.intValue());
                }
                this.availableConnections.add(connectionSettings);
                logger.info("Reading proxy definition " + connectionSettings.toString());
                continue;
            }
            logger.warning("String " + string + " does not match to proxy definition pattern - [username[:password@]]host:port");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getAvailableConnections() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.availableConnections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getEnabledConnections() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.getEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getRotatedEnabledConnections() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            List<ConnectionSettings> list = this.getEnabled();
            if (list.size() > 1) {
                Collections.rotate(list, this.rotate++);
            }
            return Collections.unmodifiableList(list);
        }
    }

    private List<ConnectionSettings> getEnabled() {
        LinkedList<ConnectionSettings> linkedList = new LinkedList<ConnectionSettings>();
        for (ConnectionSettings connectionSettings : this.availableConnections) {
            if (!connectionSettings.isEnabled()) continue;
            linkedList.add(connectionSettings);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionEnabled(ConnectionSettings connectionSettings, boolean bl) {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            connectionSettings.setEnabled(bl);
        }
    }

    public synchronized HttpDownloadClient popWorkingClient() {
        if (this.popCount < 9) {
            ++this.popCount;
            if (this.workingClientsPool.isEmpty()) {
                return new DownloadClient();
            }
            return this.workingClientsPool.pop();
        }
        throw new IllegalStateException("Cannot pop more connections");
    }

    public synchronized void pushWorkingClient(HttpDownloadClient httpDownloadClient) {
        --this.popCount;
        this.workingClientsPool.add(httpDownloadClient);
    }

    public void updateDefaultConnection() {
        this.updateConnectionSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionSettings() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            this.availableConnections.clear();
            this.updateDefault();
            this.updateProxies();
        }
        object = this.managerDirector.getMenuManager();
        if (object != null) {
            ((MenuManager)object).updateConnectionSettings(this.getAvailableConnections());
        }
    }

    public void updateProxyConnectionList() {
        this.updateConnectionSettings();
    }
}

