/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.list.ArrayListModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.FileTypeIconProvider;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.actions.URLTransferHandler;
import cz.vity.freerapid.gui.dialogs.InformationDialog;
import cz.vity.freerapid.gui.dialogs.MultipleSettingsDialog;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.HttpDownloadClient;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.OSDesktop;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.PatternFilter;

public class ContentPanel
extends JPanel
implements ListSelectionListener,
ListDataListener,
PropertyChangeListener,
ClipboardOwner {
    private static final Logger logger = Logger.getLogger(ContentPanel.class.getName());
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_PROGRESSBAR = 1;
    private static final int COLUMN_PROGRESS = 2;
    private static final int COLUMN_STATE = 3;
    private static final int COLUMN_SIZE = 4;
    private static final int COLUMN_SPEED = 5;
    private static final int COLUMN_AVERAGE_SPEED = 6;
    private static final int COLUMN_SERVICE = 7;
    private static final int COLUMN_PROXY = 8;
    private final ApplicationContext context;
    private final ManagerDirector director;
    private final DataManager manager;
    private boolean cancelActionEnabled = false;
    private static final String CANCEL_ACTION_ENABLED_PROPERTY = "cancelActionEnabled";
    private boolean resumeActionEnabled = false;
    private static final String RESUME_ACTION_ENABLED_PROPERTY = "resumeActionEnabled";
    private boolean removeCompletedActionEnabled = false;
    private static final String REMOVECOMPLETED_ACTION_ENABLED_PROPERTY = "removeCompletedActionEnabled";
    private boolean pauseActionEnabled = false;
    private static final String PAUSE_ACTION_ENABLED_PROPERTY = "pauseActionEnabled";
    private boolean completeWithFilesEnabled = false;
    private static final String COMPLETED_OK_ACTION_ENABLED_PROPERTY = "completeWithFilesEnabled";
    private boolean selectedEnabled = false;
    private static final String SELECTED_ACTION_ENABLED_PROPERTY = "selectedEnabled";
    private boolean nonEmptyEnabled = false;
    private static final String NONEMPTY_ACTION_ENABLED_PROPERTY = "nonEmptyEnabled";
    private JXTable table;
    private static String[] states;

    public ContentPanel(ApplicationContext applicationContext, ManagerDirector managerDirector) {
        this.context = applicationContext;
        this.director = managerDirector;
        this.manager = managerDirector.getDataManager();
        this.setName("contentPanel");
        this.readStates();
        Swinger.initActions(this, applicationContext);
        this.initComponents();
        this.setActions();
        MainApp mainApp = (MainApp)applicationContext.getApplication();
        mainApp.getMainFrame().addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                Swinger.inputFocus((JComponent)ContentPanel.this.table);
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
        this.manager.getDownloadFiles().addListDataListener((ListDataListener)this);
        this.manager.addPropertyChangeListener(this);
    }

    private void readStates() {
        DownloadState[] downloadStateArray = DownloadState.values();
        states = new String[downloadStateArray.length];
        int n = 0;
        for (DownloadState downloadState : downloadStateArray) {
            ContentPanel.states[n++] = this.context.getResourceMap().getString(downloadState.name(), new Object[0]);
        }
    }

    @Action(enabledProperty="completeWithFilesEnabled")
    public void openFileAction() {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        for (DownloadFile downloadFile : list) {
            OSDesktop.openFile(downloadFile.getOutputFile());
        }
    }

    private int[] getSelectedRows() {
        return Swinger.getSelectedRows((JTable)this.table);
    }

    @Action(enabledProperty="selectedEnabled")
    public void deleteFileAction() {
        int n;
        boolean bl;
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        String string = this.getFileList(list);
        boolean bl2 = AppPrefs.getProperty("confirmFileDelete", true);
        if (string.isEmpty() || !bl2) {
            bl = false;
            n = 0;
        } else {
            n = Swinger.getChoiceOKCancel("message.areyousuredelete", string);
            bl = true;
        }
        if (n == 0) {
            for (DownloadFile downloadFile : list) {
                File file = downloadFile.getOutputFile();
                if (file == null) continue;
                file.delete();
            }
            this.removeSelected(list, nArray, bl);
            this.selectFirstIfNoSelection();
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void downloadInformationAction() throws Exception {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        if (list.isEmpty()) {
            return;
        }
        MainApp mainApp = (MainApp)this.context.getApplication();
        JFrame jFrame = mainApp.getMainFrame();
        if (list.size() == 1) {
            InformationDialog informationDialog = new InformationDialog(jFrame, this.director, list.get(0));
            mainApp.show(informationDialog);
        } else {
            MultipleSettingsDialog multipleSettingsDialog = new MultipleSettingsDialog(jFrame, list);
            mainApp.show(multipleSettingsDialog);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void openDirectoryAction() {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        for (DownloadFile downloadFile : list) {
            OSDesktop.openFile(downloadFile.getOutputFile().getParentFile());
        }
    }

    @Action(enabledProperty="resumeActionEnabled")
    public void resumeAction() {
        if (this.isResumeActionEnabled()) {
            this.manager.resumeSelected(this.getSelectedRows());
        }
    }

    @Action(enabledProperty="pauseActionEnabled")
    public void pauseAction() {
        this.manager.pauseSelected(this.getSelectedRows());
    }

    @Action(enabledProperty="cancelActionEnabled")
    public void cancelAction() {
        boolean bl;
        int n;
        if (!this.isCancelActionEnabled()) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        String string = this.getFileList(list);
        boolean bl2 = AppPrefs.getProperty("confirmFileDelete", true);
        if (bl2 && !string.isEmpty()) {
            n = Swinger.getChoiceYesNoCancel("message.areyousuredelete", string);
            bl = n == 0;
        } else {
            n = 0;
            bl = true;
        }
        if (n == 0 || n == 1) {
            this.manager.cancelSelected(this.getSelectedRows(), bl);
        }
    }

    private String getFileList(List<DownloadFile> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DownloadFile downloadFile : list) {
            if (downloadFile.getOutputFile() == null || !downloadFile.getOutputFile().exists()) continue;
            stringBuilder.append('\n').append(Utils.shortenFileName(downloadFile.getOutputFile(), 60));
        }
        return stringBuilder.toString();
    }

    @Action(enabledProperty="removeCompletedActionEnabled")
    public void removeCompletedAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        this.manager.removeCompleted();
        this.selectFirstIfNoSelection();
        listSelectionModel.setValueIsAdjusting(false);
    }

    private void selectFirstIfNoSelection() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ContentPanel.this.getVisibleRowCount() > 0) {
                        ContentPanel.this.table.getSelectionModel().setSelectionInterval(0, 0);
                    }
                }
            });
        }
    }

    @Action(enabledProperty="nonEmptyEnabled")
    public void selectAllAction() {
        this.table.selectAll();
    }

    @Action(enabledProperty="nonEmptyEnabled")
    public void invertSelectionAction() {
        int[] nArray = this.getSelectedRows();
        int n = this.table.getModel().getRowCount();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        listSelectionModel.clearSelection();
        if (nArray.length > 1) {
            Arrays.sort(nArray);
        }
        for (int i = 0; i < n; ++i) {
            if (Arrays.binarySearch(nArray, i) >= 0) continue;
            int n2 = this.table.convertRowIndexToView(i);
            listSelectionModel.addSelectionInterval(n2, n2);
        }
        listSelectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(true);
    }

    @Action(enabledProperty="selectedEnabled")
    public void removeSelectedAction() {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        this.removeSelected(list, nArray, false);
    }

    private void removeSelected(List<DownloadFile> list, int[] nArray, boolean bl) {
        int n;
        final ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        if (!bl && (n = AppPrefs.getProperty("confirmRemove", true)) != 0) {
            int n2;
            boolean bl2 = AppPrefs.getProperty("confirmDownloadingRemove", false);
            boolean bl3 = false;
            if (bl2) {
                for (DownloadFile downloadFile : list) {
                    if (DownloadState.DOWNLOADING != downloadFile.getState()) continue;
                    bl3 = true;
                    break;
                }
            } else {
                bl3 = true;
            }
            if (bl3 && (n2 = Swinger.getChoiceOKCancel("areYouSureYouWantToRemove", new Object[0])) != 0) {
                return;
            }
        }
        this.manager.removeSelected(list);
        listSelectionModel.setValueIsAdjusting(false);
        n = this.getArrayMin(nArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n3 = ContentPanel.this.getVisibleRowCount();
                if (n3 > 0) {
                    int n2 = n3 - 1;
                    if (n2 > n && (n2 = ContentPanel.this.table.convertRowIndexToView(n)) == -1) {
                        n2 = n3 - 1;
                    }
                    listSelectionModel.addSelectionInterval(n2, n2);
                    ContentPanel.this.scrollToVisible(true);
                }
            }
        });
    }

    private int getVisibleRowCount() {
        return this.table.getFilters().getOutputSize();
    }

    private int getArrayMin(int[] nArray) {
        int n = Integer.MAX_VALUE;
        for (int n2 : nArray) {
            if (n <= n2) continue;
            n = n2;
        }
        return n;
    }

    @Action(enabledProperty="selectedEnabled")
    public void sortbyNameAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 1) {
            this.table.selectAll();
            nArray = this.getSelectedRows();
        }
        int n = this.manager.sortByName(nArray);
        listSelectionModel.setValueIsAdjusting(false);
        if (n != -1) {
            int n2 = this.table.convertRowIndexToView(n);
            listSelectionModel.setSelectionInterval(n2, n2 + nArray.length - 1);
            this.scrollToVisible(true);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void topAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.manager.moveTop(nArray);
        listSelectionModel.setValueIsAdjusting(false);
        listSelectionModel.setSelectionInterval(0, nArray.length - 1);
        this.scrollToVisible(true);
    }

    @Action(enabledProperty="selectedEnabled")
    public void upAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.manager.moveUp(nArray);
        listSelectionModel.clearSelection();
        for (int n : nArray) {
            n = this.table.convertRowIndexToView(n);
            listSelectionModel.addSelectionInterval(n, n);
        }
        listSelectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(true);
    }

    private void scrollToVisible(boolean bl) {
        int[] nArray = this.table.getSelectedRows();
        int n = nArray.length;
        if (n > 0) {
            this.table.scrollRowToVisible(bl ? nArray[0] : nArray[n - 1]);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void downAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.manager.moveDown(nArray);
        listSelectionModel.clearSelection();
        for (int n : nArray) {
            n = this.table.convertRowIndexToView(n);
            listSelectionModel.addSelectionInterval(n, n);
        }
        listSelectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(false);
    }

    @Action(enabledProperty="selectedEnabled")
    public void bottomAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.manager.moveBottom(nArray);
        listSelectionModel.setValueIsAdjusting(false);
        int n = this.table.getRowCount();
        listSelectionModel.setSelectionInterval(n - nArray.length, n - 1);
        this.scrollToVisible(false);
    }

    @Action(enabledProperty="selectedEnabled")
    public void openInBrowser() {
        List<DownloadFile> list = this.manager.getSelectionToList(this.getSelectedRows());
        for (DownloadFile downloadFile : list) {
            Browser.openBrowser(downloadFile.getFileUrl().toExternalForm());
        }
    }

    private void setActions() {
        this.initTable();
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if ("showHorizontalGridLines".equals(preferenceChangeEvent.getKey()) || "showVerticalGridLines".equals(preferenceChangeEvent.getKey())) {
                    ContentPanel.this.updateGridLines();
                }
            }
        });
        this.updateGridLines();
    }

    private void updateGridLines() {
        boolean bl = AppPrefs.getProperty("showHorizontalGridLines", false);
        boolean bl2 = AppPrefs.getProperty("showVerticalGridLines", false);
        this.table.setShowGrid(bl, bl2);
    }

    public void updateFilters() {
        if (!AppPrefs.getProperty("removeCompleted", true)) {
            this.table.setFilters(new FilterPipeline(new Filter[]{new StateFilter()}));
        } else {
            this.table.setFilters(null);
        }
    }

    public boolean isPauseActionEnabled() {
        return this.pauseActionEnabled;
    }

    public void setPauseActionEnabled(boolean bl) {
        boolean bl2 = this.pauseActionEnabled;
        this.pauseActionEnabled = bl;
        this.firePropertyChange(PAUSE_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isCancelActionEnabled() {
        return this.cancelActionEnabled;
    }

    public void setCancelActionEnabled(boolean bl) {
        boolean bl2 = this.cancelActionEnabled;
        this.cancelActionEnabled = bl;
        this.firePropertyChange(CANCEL_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isResumeActionEnabled() {
        return this.resumeActionEnabled;
    }

    public void setResumeActionEnabled(boolean bl) {
        boolean bl2 = this.resumeActionEnabled;
        this.resumeActionEnabled = bl;
        this.firePropertyChange(RESUME_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isRemoveCompletedActionEnabled() {
        return this.removeCompletedActionEnabled;
    }

    public void setRemoveCompletedActionEnabled(boolean bl) {
        boolean bl2 = this.removeCompletedActionEnabled;
        this.removeCompletedActionEnabled = bl;
        this.firePropertyChange(REMOVECOMPLETED_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isCompleteWithFilesEnabled() {
        return this.completeWithFilesEnabled;
    }

    public void setCompletedWithFilesEnabled(boolean bl) {
        boolean bl2 = this.completeWithFilesEnabled;
        this.completeWithFilesEnabled = bl;
        this.firePropertyChange(COMPLETED_OK_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isSelectedEnabled() {
        return this.selectedEnabled;
    }

    public void setSelectedEnabled(boolean bl) {
        boolean bl2 = this.selectedEnabled;
        this.selectedEnabled = bl;
        this.firePropertyChange(SELECTED_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isNonEmptyEnabled() {
        return this.nonEmptyEnabled;
    }

    public void setNonEmptyEnabled(boolean bl) {
        boolean bl2 = this.nonEmptyEnabled;
        this.nonEmptyEnabled = bl;
        this.firePropertyChange(NONEMPTY_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    private void updateActions() {
        int[] nArray = this.getSelectedRows();
        boolean bl = this.manager.hasDownloadFilesStates(nArray, DownloadState.cancelEnabledStates);
        this.setCancelActionEnabled(bl);
        this.setSelectedEnabled(nArray.length > 0);
        boolean bl2 = this.manager.hasDownloadFilesStates(nArray, DownloadState.completedStates);
        if (bl2) {
            boolean bl3 = true;
            List<DownloadFile> list = this.manager.getSelectionToList(nArray);
            for (DownloadFile downloadFile : list) {
                if (downloadFile.getOutputFile().exists()) continue;
                bl3 = false;
                break;
            }
            this.setCompletedWithFilesEnabled(bl3);
            this.setResumeActionEnabled(false);
            this.setPauseActionEnabled(false);
        } else {
            boolean bl4 = this.manager.hasAnyDownloadFilesStates(nArray, DownloadState.resumeEnabledStates);
            this.setResumeActionEnabled(bl4);
            boolean bl5 = this.manager.hasAnyDownloadFilesStates(nArray, DownloadState.pauseEnabledStates);
            this.setPauseActionEnabled(bl5);
            this.setCompletedWithFilesEnabled(false);
        }
        this.setNonEmptyEnabled(this.table.getModel().getRowCount() > 0);
    }

    private void initTable() {
        this.table.setName("mainTable");
        String[] stringArray = (String[])this.context.getResourceMap().getObject("mainTableColumns", String[].class);
        this.table.setModel((TableModel)new CustomTableModel(this.manager.getDownloadFiles(), stringArray));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setEditable(false);
        this.table.setColumnControlVisible(true);
        this.table.setSortable(false);
        this.table.setColumnMargin(10);
        this.table.setTransferHandler((TransferHandler)new URLTransferHandler(this.director){

            @Override
            protected void doDropAction(final List<URL> list) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Swinger.getAction("addNewLinksAction").actionPerformed(new ActionEvent(list, 0, null));
                    }
                });
            }
        });
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.table.createDefaultColumnsFromModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new NameURLCellRenderer(this.director.getFileTypeIconProvider()));
        tableColumn.setWidth(150);
        tableColumn.setMinWidth(50);
        tableColumnModel.getColumn(1).setCellRenderer(new ProgressBarCellRenderer(this.context));
        tableColumnModel.getColumn(2).setCellRenderer(new ProgressCellRenderer());
        tableColumnModel.getColumn(3).setCellRenderer(new EstTimeCellRenderer(this.context));
        tableColumnModel.getColumn(4).setCellRenderer(new SizeCellRenderer(this.context));
        tableColumnModel.getColumn(5).setCellRenderer(new SpeedCellRenderer());
        tableColumnModel.getColumn(6).setCellRenderer(new AverageSpeedCellRenderer());
        tableColumnModel.getColumn(7).setCellRenderer(new ServiceCellRenderer());
        tableColumnModel.getColumn(8).setCellRenderer(new ConnectionCellRenderer(this.context));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    ContentPanel.this.showPopMenu(mouseEvent);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() >= 2) {
                    ContentPanel.this.smartEnterAction();
                }
            }
        });
        InputMap inputMap = this.table.getInputMap();
        ActionMap actionMap = this.table.getActionMap();
        inputMap.put(SwingUtils.getCtrlKeyStroke(67), "copy");
        inputMap.put(SwingUtils.getCtrlAltKeyStroke(67), "copy");
        actionMap.put("copy", Swinger.getAction("copyContent"));
        inputMap.put(SwingUtils.getKeyStroke(27), "deleteItem");
        actionMap.put("deleteItem", Swinger.getAction("cancelAction"));
        inputMap.put(SwingUtils.getShiftKeyStroke(127), "deleteFileAction");
        actionMap.put("deleteFileAction", Swinger.getAction("deleteFileAction"));
        inputMap.put(SwingUtils.getKeyStroke(32), "resumeAction");
        actionMap.put("resumeAction", Swinger.getAction("resumeAction"));
        inputMap.put(SwingUtils.getKeyStroke(10), "smartEnterAction");
        actionMap.put("smartEnterAction", Swinger.getAction("smartEnterAction"));
        inputMap.put(SwingUtils.getKeyStroke(36), "selectFirstRow");
        inputMap.put(SwingUtils.getKeyStroke(35), "selectLastRow");
        inputMap.put(SwingUtils.getCtrlKeyStroke(36), "selectFirstColumn");
        inputMap.put(SwingUtils.getCtrlKeyStroke(35), "selectLastColumn");
        inputMap.put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        inputMap.put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
        actionMap.remove("find");
        this.updateFilters();
    }

    @Action
    public void smartEnterAction() {
        if (this.isCompleteWithFilesEnabled()) {
            this.openFileAction();
        } else if (this.isSelectedEnabled()) {
            try {
                this.downloadInformationAction();
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        }
    }

    public void paste() {
        javax.swing.Action action = this.table.getActionMap().get("paste");
        action.actionPerformed(new ActionEvent(this.table, 0, "paste"));
    }

    @Action(enabledProperty="selectedEnabled")
    public void copyContent() {
        List<DownloadFile> list = this.manager.getSelectionToList(this.getSelectedRows());
        StringBuilder stringBuilder = new StringBuilder();
        for (DownloadFile object2 : list) {
            stringBuilder.append(object2.toString()).append('\n');
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString().trim());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private void showPopMenu(MouseEvent mouseEvent) {
        int[] nArray = this.getSelectedRows();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            if (nArray.length <= 0) {
                if (this.getVisibleRowCount() > 0) {
                    listSelectionModel.setSelectionInterval(n, n);
                }
            } else {
                Arrays.sort(nArray);
                if (Arrays.binarySearch(nArray, this.table.convertRowIndexToModel(n)) < 0) {
                    listSelectionModel.setValueIsAdjusting(true);
                    this.table.clearSelection();
                    listSelectionModel.setSelectionInterval(n, n);
                    listSelectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            this.table.clearSelection();
        }
        nArray = this.getSelectedRows();
        JPopupMenu jPopupMenu = new JPopupMenu();
        ApplicationActionMap applicationActionMap = this.context.getActionMap();
        jPopupMenu.add(applicationActionMap.get("downloadInformationAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("openFileAction"));
        jPopupMenu.add(applicationActionMap.get("deleteFileAction"));
        jPopupMenu.add(applicationActionMap.get("openDirectoryAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("resumeAction"));
        jPopupMenu.add(applicationActionMap.get("pauseAction"));
        jPopupMenu.add(applicationActionMap.get("cancelAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("removeCompletedAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("selectAllAction"));
        jPopupMenu.add(applicationActionMap.get("invertSelectionAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("removeSelectedAction"));
        JMenu jMenu = new JMenu();
        jMenu.setName("forceDownloadMenu");
        this.context.getResourceMap().injectComponent(jMenu);
        boolean bl = this.isSelectedEnabled() && this.manager.hasDownloadFilesStates(nArray, DownloadState.forceEnabledStates);
        jMenu.setEnabled(bl);
        List<ConnectionSettings> list = this.director.getClientManager().getAvailableConnections();
        for (ConnectionSettings connectionSettings : list) {
            ForceDownloadAction forceDownloadAction = new ForceDownloadAction(connectionSettings);
            jMenu.add(forceDownloadAction);
            forceDownloadAction.setEnabled(bl);
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("copyContent"));
        jPopupMenu.add(applicationActionMap.get("openInBrowser"));
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent((Component)this.table, mouseEvent, this);
        jPopupMenu.show(this, mouseEvent2.getX(), mouseEvent2.getY());
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this.table = new JXTable();
        this.setLayout(new BorderLayout());
        jScrollPane.setViewportView((Component)this.table);
        this.add((Component)jScrollPane, "Center");
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentPanel.this.updateActions();
            }
        });
    }

    @Override
    public void intervalAdded(final ListDataEvent listDataEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ContentPanel.this.isInInterval(ContentPanel.this.getSelectedRows(), listDataEvent.getIndex0(), listDataEvent.getIndex1())) {
                    ContentPanel.this.updateActions();
                }
            }
        });
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.intervalAdded(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.intervalAdded(listDataEvent);
    }

    private boolean isInInterval(int[] nArray, int n, int n2) {
        for (int n3 : nArray) {
            if (n < n3 || n3 > n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("completed".equals(propertyChangeEvent.getPropertyName())) {
            this.setRemoveCompletedActionEnabled((Integer)propertyChangeEvent.getNewValue() > 0);
        }
    }

    public void selectAdded(List<DownloadFile> list) {
        assert (!list.isEmpty());
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n = this.manager.getDownloadFiles().indexOf((Object)list.get(0));
        int n2 = this.table.convertRowIndexToView(n);
        listSelectionModel.setSelectionInterval(n2, n2 + list.size() - 1);
        this.scrollToVisible(true);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public static int getProgress(DownloadFile downloadFile) {
        long l = downloadFile.getDownloaded();
        long l2 = downloadFile.getFileSize();
        if (l == 0L || l2 == 0L) {
            return 0;
        }
        return (int)((float)l / (float)l2 * 100.0f);
    }

    private static int getProgress(int n, int n2) {
        return (int)((float)n2 / (float)n * 100.0f);
    }

    public static String secondsToHMin(long l) {
        long l2 = l / 60L;
        long l3 = l2 / 60L;
        l = l - (l2 -= l3 * 60L) * 60L - l3 * 3600L;
        if (l3 > 0L) {
            return String.format("%02dh:%02dm", l3, l2);
        }
        if (l2 > 0L) {
            return String.format("%02dm:%02ds", l2, l);
        }
        return String.format("%ds", l);
    }

    public static String bytesToAnother(long l) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(1);
        if (l > 0x100000L) {
            return String.format("%s MB", numberFormat.format((float)l / 1048576.0f));
        }
        if (l > 1024L) {
            return String.format("%s kB", numberFormat.format((float)l / 1024.0f));
        }
        return String.format("%s B", NumberFormat.getIntegerInstance().format(l));
    }

    private static String stateToString(DownloadState downloadState) {
        return states[downloadState.ordinal()];
    }

    private class AverageSpeedCellRenderer
    extends DefaultTableCellRenderer {
        private AverageSpeedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            DownloadState downloadState = downloadFile.getState();
            object = downloadState == DownloadState.DOWNLOADING ? (downloadFile.getSpeed() >= 0L ? ContentPanel.bytesToAnother((long)downloadFile.getAverageSpeed()) + "/s" : "0 B/s") : "";
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static class ServiceCellRenderer
    extends DefaultTableCellRenderer {
        private ServiceCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            object = downloadFile.getServiceName();
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class ForceDownloadAction
    extends AbstractAction {
        private final ConnectionSettings settings;

        public ForceDownloadAction(ConnectionSettings connectionSettings) {
            this.settings = connectionSettings;
            this.putValue("Name", connectionSettings.toString());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ContentPanel.this.manager.forceDownload(this.settings, ContentPanel.this.getSelectedRows());
        }
    }

    private static class ConnectionCellRenderer
    extends DefaultTableCellRenderer {
        private final String defaultConnection;

        private ConnectionCellRenderer(ApplicationContext applicationContext) {
            ResourceMap resourceMap = applicationContext.getResourceMap();
            this.defaultConnection = resourceMap.getString("defaultConnection", new Object[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            DownloadTask downloadTask = downloadFile.getTask();
            ConnectionSettings connectionSettings = null;
            if (downloadFile.getState() == DownloadState.SLEEPING || downloadFile.getState() == DownloadState.ERROR) {
                connectionSettings = downloadFile.getConnectionSettings();
            }
            if (connectionSettings == null && downloadTask != null) {
                HttpDownloadClient httpDownloadClient = downloadTask.getClient();
                connectionSettings = httpDownloadClient.getSettings();
            }
            if (connectionSettings != null) {
                if (connectionSettings.isProxySet()) {
                    object = String.format("%s:%s", connectionSettings.getProxyURL(), connectionSettings.getProxyPort());
                    if (connectionSettings.getUserName() != null) {
                        object = connectionSettings.getUserName() + "@" + object;
                    }
                } else {
                    object = this.defaultConnection;
                }
            } else {
                object = "";
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static class ProgressBarCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        private static final Color BG_RED = new Color(0xFFD0D0);
        private static final Color BG_ORANGE = new Color(16772560);
        private static final Color BG_GREEN = new Color(13697001);
        private static final Color BG_BLUE = new Color(11987455);
        private String autoReconnectIn;
        private String attemptForDownloading;

        public ProgressBarCellRenderer(ApplicationContext applicationContext) {
            super(0, 100);
            ResourceMap resourceMap = applicationContext.getResourceMap();
            this.autoReconnectIn = resourceMap.getString("autoreconnectIn", new Object[0]);
            this.attemptForDownloading = resourceMap.getString("attemptForDownloading", new Object[0]);
            int n = this.getPreferredSize().height;
            this.setPreferredSize(new Dimension(70, n));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            DownloadState downloadState = downloadFile.getState();
            if (downloadState == DownloadState.DOWNLOADING || downloadState == DownloadState.GETTING || downloadState == DownloadState.WAITING) {
                this.setBackground(BG_GREEN);
            } else if (downloadState == DownloadState.CANCELLED || downloadState == DownloadState.ERROR || downloadState == DownloadState.DELETED) {
                this.setBackground(BG_RED);
            } else if (downloadState == DownloadState.PAUSED) {
                this.setBackground(Color.BLACK);
            } else if (downloadState == DownloadState.QUEUED) {
                this.setBackground(BG_ORANGE);
            } else if (downloadState == DownloadState.SLEEPING) {
                this.setBackground(BG_BLUE);
            } else if (downloadState == DownloadState.COMPLETED) {
                this.setBackground(null);
            } else {
                this.setBackground(Color.BLACK);
            }
            int n3 = downloadFile.getTimeToQueued();
            if ((downloadState == DownloadState.ERROR || downloadState == DownloadState.SLEEPING) && n3 >= 0) {
                int n4 = downloadFile.getTimeToQueuedMax();
                this.setStringPainted(true);
                this.setString(ContentPanel.secondsToHMin(n3));
                this.setValue(ContentPanel.getProgress(n4, n3));
                this.setToolTipText(String.format(this.autoReconnectIn, n3));
            } else {
                int n5 = downloadFile.getSleep();
                if (downloadState == DownloadState.WAITING && n5 >= 0) {
                    int n6 = downloadFile.getTimeToQueuedMax();
                    this.setStringPainted(true);
                    this.setString(ContentPanel.secondsToHMin(n5));
                    this.setValue(ContentPanel.getProgress(n6, n5));
                    this.setToolTipText(String.format(this.attemptForDownloading, n5));
                } else {
                    this.setToolTipText(null);
                    int n7 = ContentPanel.getProgress(downloadFile);
                    if (AppPrefs.getProperty("showPercentProgress", false)) {
                        this.setStringPainted(true);
                        this.setString(n7 + "%");
                    } else {
                        this.setStringPainted(false);
                    }
                    this.setValue(n7);
                }
            }
            return this;
        }
    }

    private static class EstTimeCellRenderer
    extends DefaultTableCellRenderer {
        private final String tooltip;
        private final String elapsedTime;

        private EstTimeCellRenderer(ApplicationContext applicationContext) {
            ResourceMap resourceMap = applicationContext.getResourceMap();
            this.tooltip = resourceMap.getString("tooltip", new Object[0]);
            this.elapsedTime = resourceMap.getString("elapsedTime", new Object[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadTask downloadTask;
            DownloadFile downloadFile = (DownloadFile)object;
            DownloadState downloadState = downloadFile.getState();
            object = ContentPanel.stateToString(downloadState);
            this.setHorizontalAlignment(0);
            this.setToolTipText(null);
            if (downloadState == DownloadState.DOWNLOADING) {
                long l = downloadFile.getFileSize() - downloadFile.getDownloaded();
                double d = downloadFile.getAverageSpeed();
                if (l >= 0L && d > 0.0) {
                    object = ContentPanel.secondsToHMin(Math.round((double)l / d));
                }
            } else if (downloadState == DownloadState.WAITING) {
                // empty if block
            }
            if (downloadState == DownloadState.ERROR || downloadState == DownloadState.SLEEPING) {
                String string = downloadFile.getErrorMessage();
                if (string != null) {
                    if (downloadState == DownloadState.ERROR) {
                        object = object + " - " + string.replaceAll("<.*?>", "");
                    }
                    this.setToolTipText(String.format(this.tooltip, string));
                }
            } else if (DownloadState.isProcessState(downloadState) && (downloadTask = downloadFile.getTask()) != null) {
                this.setToolTipText(String.format(this.elapsedTime, ContentPanel.secondsToHMin(downloadTask.getExecutionDuration(TimeUnit.SECONDS))));
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static class ProgressCellRenderer
    extends DefaultTableCellRenderer {
        private ProgressCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            this.setHorizontalAlignment(0);
            int n3 = ContentPanel.getProgress(downloadFile);
            object = n3 + "%";
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static class SpeedCellRenderer
    extends DefaultTableCellRenderer {
        private SpeedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            object = downloadFile.getState() == DownloadState.DOWNLOADING ? (downloadFile.getSpeed() >= 0L ? ContentPanel.bytesToAnother(downloadFile.getSpeed()) + "/s" : "0 B/s") : "";
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static class SizeCellRenderer
    extends DefaultTableCellRenderer {
        private final String sizeRendererProgress;
        private final String sizeRendererUnknown;
        private final String sizeRendererInBytes;

        private SizeCellRenderer(ApplicationContext applicationContext) {
            ResourceMap resourceMap = applicationContext.getResourceMap();
            this.sizeRendererProgress = resourceMap.getString("sizeRendererProgress", new Object[0]);
            this.sizeRendererUnknown = resourceMap.getString("sizeRendererUnknown", new Object[0]);
            this.sizeRendererInBytes = resourceMap.getString("sizeRendererInBytes", new Object[0]);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            long l = downloadFile.getFileSize();
            if (l >= 0L) {
                object = downloadFile.getDownloaded() != l ? String.format(this.sizeRendererProgress, ContentPanel.bytesToAnother(downloadFile.getDownloaded()), ContentPanel.bytesToAnother(l)) : ContentPanel.bytesToAnother(l);
                this.setToolTipText(String.format(this.sizeRendererInBytes, NumberFormat.getIntegerInstance().format(l)));
            } else {
                object = this.sizeRendererUnknown;
                this.setToolTipText(null);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private static class NameURLCellRenderer
    extends DefaultTableCellRenderer {
        private final FileTypeIconProvider iconProvider;

        private NameURLCellRenderer(FileTypeIconProvider fileTypeIconProvider) {
            this.iconProvider = fileTypeIconProvider;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            String string = downloadFile.getFileName();
            String string2 = downloadFile.getFileUrl().toString();
            object = string != null && !string.isEmpty() ? string : string2;
            super.getTableCellRendererComponent(jTable, " " + object, bl, bl2, n, n2);
            if (object != null) {
                this.setToolTipText(string2);
                this.setIcon(this.iconProvider.getIconImageByFileType(downloadFile.getFileType(), false));
            }
            return this;
        }
    }

    private static class CustomTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private final ArrayListModel<DownloadFile> model;
        private final String[] columns;

        public CustomTableModel(ArrayListModel<DownloadFile> arrayListModel, String[] stringArray) {
            this.model = arrayListModel;
            this.columns = stringArray;
            arrayListModel.addListDataListener((ListDataListener)this);
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.model.get(n);
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableRowsInserted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableRowsDeleted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableRowsUpdated(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }

    private static class StateFilter
    extends PatternFilter {
        public StateFilter() {
            super("", 0, 0);
        }

        public boolean test(int n) {
            DownloadFile downloadFile = (DownloadFile)this.getInputValue(n, 3);
            return downloadFile != null && downloadFile.getState() != DownloadState.COMPLETED;
        }
    }
}

