/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.ShareDownloadService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

class DownloadService {
    private List<ConnectionSettings> downloading = new Vector<ConnectionSettings>();
    private Set<ConnectionSettings> problems = Collections.synchronizedSet(new HashSet());
    private String serviceName;
    private int maxDownloadsFromOneIP;

    public DownloadService(ShareDownloadService shareDownloadService) {
        this.serviceName = shareDownloadService.getName();
        this.maxDownloadsFromOneIP = shareDownloadService.getMaxDownloadsFromOneIP();
    }

    public boolean canDownloadWith(ConnectionSettings connectionSettings) {
        if (this.problems.contains(connectionSettings)) {
            return false;
        }
        int n = 0;
        int n2 = this.getMaxDownloadsFromOneIP();
        for (ConnectionSettings connectionSettings2 : this.downloading) {
            if (!connectionSettings2.equals(connectionSettings) || ++n < n2) continue;
            return false;
        }
        return true;
    }

    public void addDownloadingClient(HttpDownloadClient httpDownloadClient) {
        this.downloading.add(httpDownloadClient.getSettings());
    }

    public void addProblematicConnection(ConnectionSettings connectionSettings) {
        this.problems.add(connectionSettings);
    }

    public void removeProblematicConnection(ConnectionSettings connectionSettings) {
        this.problems.remove(connectionSettings);
    }

    public void finishedDownloading(HttpDownloadClient httpDownloadClient) {
        this.downloading.remove(httpDownloadClient.getSettings());
    }

    public int getProblematicConnectionsCount() {
        return this.problems.size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DownloadService downloadService = (DownloadService)object;
        return this.serviceName.equals(downloadService.serviceName);
    }

    public int hashCode() {
        return this.serviceName.hashCode();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String toString() {
        return this.getServiceName();
    }

    public int getMaxDownloadsFromOneIP() {
        return this.maxDownloadsFromOneIP;
    }
}

