/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.MoveFileTask;
import cz.vity.freerapid.gui.managers.ContentPanel;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.TrayIconSupport;
import cz.vity.freerapid.swing.components.MemoryIndicator;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXStatusBar;

public class StatusBarManager
implements PropertyChangeListener,
ListDataListener {
    private JXStatusBar statusbar;
    private JLabel infoLabel;
    private final ManagerDirector director;
    private final ApplicationContext context;
    private JProgressBar progress;
    private MainApp app;
    private ResourceMap resourceMap;
    private DataManager dataManager;
    private Image defaultIconImage;
    private Image downloadingIconImage;
    private TrayIconSupport trayIconSupport;
    private JLabel clipboardMonitoring;
    private MemoryIndicator indicator;

    public StatusBarManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.director = managerDirector;
        this.context = applicationContext;
        this.resourceMap = applicationContext.getResourceMap();
        this.dataManager = managerDirector.getDataManager();
        this.app = (MainApp)applicationContext.getApplication();
    }

    public JXStatusBar getStatusBar() {
        if (this.statusbar == null) {
            this.statusbar = new JXStatusBar();
            this.trayIconSupport = this.app.getTrayIconSupport();
            this.defaultIconImage = Utils.isWindows() ? this.resourceMap.getImageIcon("trayIconImageWin").getImage() : this.resourceMap.getImageIcon("trayIconImage").getImage();
            this.downloadingIconImage = this.resourceMap.getImageIcon("downloadingIconImage").getImage();
            Action action = this.context.getActionMap().get("showStatusBar");
            action.putValue("SwingSelectedKey", true);
            action.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("SwingSelectedKey".equals(propertyChangeEvent.getPropertyName())) {
                        StatusBarManager.this.setStatusBarVisible((Boolean)propertyChangeEvent.getNewValue());
                    }
                }
            });
            this.clipboardMonitoring = new JLabel();
            this.clipboardMonitoring.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    boolean bl = AppPrefs.getProperty("clipboardMonitoring", false);
                    Action action = StatusBarManager.this.app.getContext().getActionMap().get("monitorClipboardAction");
                    action.putValue("SwingSelectedKey", !bl);
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                }
            });
            this.clipboardMonitoring.setName("labelClipboardMonitoring");
            this.resourceMap.injectComponent(this.clipboardMonitoring);
            this.statusbar.setName("statusbarPanel");
            this.infoLabel = new JLabel();
            this.progress = new JProgressBar();
            this.indicator = new MemoryIndicator();
            this.indicator.setPreferredSize(new Dimension(100, 15));
            this.infoLabel.setPreferredSize(new Dimension(345, 15));
            this.clipboardMonitoring.setPreferredSize(new Dimension(17, 15));
            this.progress.setPreferredSize(new Dimension(this.progress.getPreferredSize().width * 2 / 3, 15));
            this.progress.setVisible(false);
            this.director.getMenuManager().getMenuBar().addPropertyChangeListener("selectedText", this);
            this.statusbar.add((Component)this.infoLabel, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add((Component)this.progress, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add((Component)this.clipboardMonitoring, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add(Box.createGlue(), (Object)JXStatusBar.Constraint.ResizeBehavior.FILL);
            this.context.getTaskMonitor().addPropertyChangeListener(this);
            this.dataManager.getDownloadFiles().addListDataListener((ListDataListener)this);
            this.dataManager.getProcessManager().addPropertyChangeListener("downloading", this);
            this.dataManager.addPropertyChangeListener("speed", this);
            this.dataManager.addPropertyChangeListener("completed", this);
            this.dataManager.addPropertyChangeListener("state", this);
            AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                    String string = preferenceChangeEvent.getKey();
                    if ("showInfoInFrameTitle".equals(string)) {
                        StatusBarManager.this.updateInfoStatus();
                    } else if ("animateIcon".equals(string)) {
                        if (!AppPrefs.getProperty("animateIcon", true)) {
                            StatusBarManager.this.trayIconSupport.setImage(StatusBarManager.this.defaultIconImage);
                        } else {
                            StatusBarManager.this.updateIconAnimation();
                        }
                    } else if ("clipboardMonitoring".equals(string)) {
                        StatusBarManager.this.updateClipboardMonitoring();
                    } else if ("showMemoryIndicator".equals(string)) {
                        StatusBarManager.this.updateMemoryIndicator();
                    }
                }
            });
            this.updateInfoStatus();
            this.updateClipboardMonitoring();
            this.updateMemoryIndicator();
        }
        return this.statusbar;
    }

    private void updateMemoryIndicator() {
        boolean bl = AppPrefs.getProperty("showMemoryIndicator", false);
        this.indicator.setVisible(bl);
        if (bl) {
            this.statusbar.add((Component)this.indicator, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
        } else {
            this.statusbar.remove((Component)this.indicator);
        }
    }

    private void updateClipboardMonitoring() {
        this.clipboardMonitoring.setEnabled(AppPrefs.getProperty("clipboardMonitoring", false));
    }

    private void setStatusBarVisible(boolean bl) {
        this.getStatusBar().setVisible(bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("speed".equals(string) || "completed".equals(string)) {
            this.updateInfoStatus();
        } else if ("started".equals(string) || "done".equals(string) || "message".equals(string)) {
            if (propertyChangeEvent.getSource() instanceof MoveFileTask) {
                this.updateProgress(propertyChangeEvent);
            }
        } else if ("selectedText".equals(string)) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if ("cancel".equals(string2)) {
                this.updateInfoStatus();
            } else {
                this.infoLabel.setText(string2);
            }
        } else if ("downloading".equals(string) && AppPrefs.getProperty("animateIcon", true)) {
            this.updateIconAnimation();
        }
    }

    private void updateIconAnimation() {
        int n = this.dataManager.getDownloading();
        if (n == 0) {
            this.trayIconSupport.setImage(this.defaultIconImage);
        } else {
            this.trayIconSupport.setImage(this.downloadingIconImage);
        }
    }

    private void updateProgress(PropertyChangeEvent propertyChangeEvent) {
        Task task = (Task)((Object)propertyChangeEvent.getSource());
        String string = propertyChangeEvent.getPropertyName();
        if ("done".equals(string)) {
            this.progress.setVisible(false);
        } else if ("started".equals(string)) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                        StatusBarManager.this.progress.setVisible(true);
                        StatusBarManager.this.progress.setIndeterminate(false);
                        StatusBarManager.this.progress.setValue((Integer)propertyChangeEvent.getNewValue());
                    } else if ("message".equals(propertyChangeEvent.getPropertyName())) {
                        StatusBarManager.this.progress.setString((String)propertyChangeEvent.getNewValue());
                    }
                }
            };
            task.addPropertyChangeListener(propertyChangeListener);
        }
    }

    private void updateInfoStatus() {
        int n = this.dataManager.getCompleted();
        int n2 = this.dataManager.getDownloadFiles().size();
        int n3 = this.dataManager.getCurrentSpeed();
        TrayIconSupport trayIconSupport = this.app.getTrayIconSupport();
        boolean bl = AppPrefs.getProperty("showInfoInFrameTitle", false);
        String string = ContentPanel.bytesToAnother(n3);
        int n4 = this.dataManager.getDownloading();
        if (bl) {
            String string2 = n4 == 0 ? this.resourceMap.getString("frameTitleInfoNoDownloads", n, n2) : (n3 == 0 ? this.resourceMap.getString("frameTitleInfo0Speed", n, n2, string) : this.resourceMap.getString("frameTitleInfo", n, n2, string));
            this.app.getMainFrame().setTitle(string2);
        } else {
            this.app.getMainFrame().setTitle(this.resourceMap.getString("Application.title", new Object[0]));
        }
        if (n2 >= 0) {
            trayIconSupport.setToolTip(this.resourceMap.getString("tooltipTrayInfo", n, n2, string));
            this.infoLabel.setText(this.resourceMap.getString("statusBarInfo", n, n2, string));
        } else {
            trayIconSupport.setToolTip(this.resourceMap.getString("Application.title", new Object[0]));
            this.infoLabel.setText(this.resourceMap.getString("statusBarInfoIdle", new Object[0]));
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateInfoStatus();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateInfoStatus();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }
}

