/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.swing.EDTPropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.jdesktop.application.Application;

public class ConnectionSettings {
    private String userName;
    private String password;
    private String proxyURL;
    private int proxyPort;
    private boolean proxySet;
    private boolean enabled = true;
    private String defaultConnectionLabel = Application.getInstance().getContext().getResourceMap().getString("defaultConnection", new Object[0]);
    private final EDTPropertyChangeSupport pcs = new EDTPropertyChangeSupport(this);

    public void setProxy(String string, int n, String string2, String string3) {
        this.proxyURL = string;
        this.proxyPort = n;
        this.userName = string2;
        this.password = string3;
        this.proxySet = true;
    }

    public void setProxy(String string, int n) {
        this.proxyURL = string;
        this.proxyPort = n;
        this.proxySet = true;
    }

    public boolean isProxySet() {
        return this.proxySet;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean hasUserName() {
        return this.userName != null;
    }

    public String toString() {
        if (this.isProxySet()) {
            String string = this.getProxyURL() + ":" + this.getProxyPort();
            if (this.hasUserName()) {
                return this.getUserName() + "@" + string;
            }
            return string;
        }
        return this.defaultConnectionLabel;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionSettings connectionSettings = (ConnectionSettings)object;
        if (this.proxyPort != connectionSettings.proxyPort) {
            return false;
        }
        if (this.proxySet != connectionSettings.proxySet) {
            return false;
        }
        if (!this.proxyURL.equalsIgnoreCase(connectionSettings.proxyURL)) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(connectionSettings.userName) : connectionSettings.userName != null);
    }

    public int hashCode() {
        int n = this.userName != null ? this.userName.hashCode() : 0;
        n = 31 * n + (this.proxyURL != null ? this.proxyURL.toLowerCase().hashCode() : 0);
        n = 31 * n + this.proxyPort;
        n = 31 * n + (this.proxySet ? 1 : 0);
        return n;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        this.pcs.firePropertyChange("enabled", bl2, bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }
}

