/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.webclient.GOCR;
import cz.vity.freerapid.plugins.webclient.utils.Entities;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlugUtils {
    private static final Logger logger = Logger.getLogger(PlugUtils.class.getName());

    public static long getFileSizeFromString(String string) {
        if (string == null) {
            throw new NullPointerException("Input value cannot be null");
        }
        string = string.toUpperCase();
        int n = 1;
        int n2 = string.lastIndexOf("KB");
        if (n2 >= 0) {
            n = 1024;
        } else {
            n2 = string.lastIndexOf("MB");
            if (n2 >= 0) {
                n = 0x100000;
            } else {
                n2 = string.lastIndexOf("GB");
                if (n2 >= 0) {
                    n = 0x40000000;
                } else {
                    n2 = string.lastIndexOf("BYTES");
                }
            }
        }
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        if ((string = string.trim().replaceAll(" ", "").replaceAll(",", ".")).indexOf(46) > 0) {
            return new BigDecimal(string).multiply(BigDecimal.valueOf(n)).setScale(0, RoundingMode.UP).longValue();
        }
        return Long.parseLong(string) * (long)n;
    }

    public static Matcher matcher(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Input value cannot be null");
        }
        return Pattern.compile(string, 8).matcher(string2);
    }

    public static boolean find(String string, String string2) {
        return PlugUtils.matcher(string, string2).find();
    }

    public static String unescapeHtml(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter((int)((double)string.length() * 1.5));
            Entities.HTML40.unescape(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Cannot unescape HTML", iOException);
            return null;
        }
    }

    public static String recognize(BufferedImage bufferedImage, String string) {
        GOCR gOCR = new GOCR(bufferedImage, string);
        try {
            return gOCR.recognize();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

