/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.appframework.swingx;

import com.jgoodies.binding.list.ArrayListModel;
import java.awt.Component;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.table.TableColumnExt;

public class XProperties {
    public void registerPersistenceDelegates() {
        XMLEncoder xMLEncoder = new XMLEncoder(System.out);
        xMLEncoder.setPersistenceDelegate(SortKeyState.class, new DefaultPersistenceDelegate(new String[]{"ascending", "modelIndex", "comparator"}));
        xMLEncoder.setPersistenceDelegate(ColumnState.class, new DefaultPersistenceDelegate(new String[]{"width", "preferredWidth", "modelIndex", "visible", "viewIndex"}));
        xMLEncoder.setPersistenceDelegate(XTableState.class, new DefaultPersistenceDelegate(new String[]{"columnStates", "sortKeyState", "horizontalScrollEnabled"}));
        xMLEncoder.setPersistenceDelegate(ArrayListModel.class, xMLEncoder.getPersistenceDelegate(List.class));
        PersistenceDelegate persistenceDelegate = new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object object, Encoder encoder) {
                return new Expression(object, object.getClass(), "new", new Object[]{object.toString()});
            }
        };
        xMLEncoder.setPersistenceDelegate(URL.class, persistenceDelegate);
        xMLEncoder.setPersistenceDelegate(File.class, persistenceDelegate);
    }

    public static class VisibleColumnIndexComparator
    implements Comparator<ColumnState> {
        @Override
        public int compare(ColumnState columnState, ColumnState columnState2) {
            return columnState.getViewIndex() - columnState2.getViewIndex();
        }
    }

    public static class ColumnState {
        private int width;
        private int preferredWidth;
        private int modelIndex;
        private boolean visible;
        private int viewIndex;

        public ColumnState(int n, int n2, int n3, boolean bl, int n4) {
            this.width = n;
            this.preferredWidth = n2;
            this.modelIndex = n3;
            this.visible = bl;
            this.viewIndex = n4;
        }

        public ColumnState(TableColumnExt tableColumnExt, int n) {
            this(tableColumnExt.getWidth(), tableColumnExt.getPreferredWidth(), tableColumnExt.getModelIndex(), tableColumnExt.isVisible(), n);
        }

        public void configureColumn(TableColumnExt tableColumnExt) {
            if (this.modelIndex != tableColumnExt.getModelIndex()) {
                return;
            }
            tableColumnExt.setPreferredWidth(this.preferredWidth);
            tableColumnExt.setWidth(this.width);
            tableColumnExt.setVisible(this.visible);
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public int getViewIndex() {
            return this.viewIndex;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public int getWidth() {
            return this.width;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }
    }

    public static class SortKeyState {
        int modelIndex;
        Comparator comparator;
        boolean ascending;

        public SortKeyState(boolean bl, int n, Comparator comparator) {
            this.ascending = bl;
            this.modelIndex = n;
            this.comparator = comparator;
        }

        public SortKeyState(SortKey sortKey) {
            this(sortKey.getSortOrder().isAscending(), sortKey.getColumn(), sortKey.getComparator());
        }

        protected SortKey getSortKey() {
            SortOrder sortOrder = this.getAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING;
            return new SortKey(sortOrder, this.getModelIndex(), this.getComparator());
        }

        public boolean getAscending() {
            return this.ascending;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public Comparator getComparator() {
            return this.comparator;
        }
    }

    public static class XTableState {
        ColumnState[] columnStates = new ColumnState[0];
        boolean horizontalScrollEnabled;
        SortKeyState sortKeyState;

        public XTableState() {
        }

        public XTableState(ColumnState[] columnStateArray, SortKeyState sortKeyState, boolean bl) {
            this.columnStates = this.copyColumnStates(columnStateArray);
            this.sortKeyState = sortKeyState;
            this.setHorizontalScrollEnabled(bl);
        }

        public void setSortKey(SortKey sortKey) {
            this.sortKeyState = new SortKeyState(sortKey);
        }

        private SortKey getSortKey() {
            if (this.sortKeyState != null) {
                return this.sortKeyState.getSortKey();
            }
            return null;
        }

        public XTableState(ColumnState[] columnStateArray) {
            this.columnStates = this.copyColumnStates(columnStateArray);
        }

        public ColumnState[] getColumnStates() {
            return this.copyColumnStates(this.columnStates);
        }

        public boolean getHorizontalScrollEnabled() {
            return this.horizontalScrollEnabled;
        }

        public void setHorizontalScrollEnabled(boolean bl) {
            this.horizontalScrollEnabled = bl;
        }

        private ColumnState[] copyColumnStates(ColumnState[] columnStateArray) {
            if (columnStateArray == null) {
                throw new IllegalArgumentException("invalid columnWidths");
            }
            ColumnState[] columnStateArray2 = new ColumnState[columnStateArray.length];
            System.arraycopy(columnStateArray, 0, columnStateArray2, 0, columnStateArray.length);
            return columnStateArray2;
        }

        public SortKeyState getSortKeyState() {
            return this.sortKeyState;
        }
    }

    public static class XTableProperty
    implements SessionStorage.Property {
        @Override
        public Object getSessionState(Component component) {
            TableColumn tableColumn2;
            this.checkComponent(component);
            JXTable jXTable = (JXTable)component;
            ArrayList<ColumnState> arrayList = new ArrayList<ColumnState>();
            List list = jXTable.getColumns(true);
            List list2 = jXTable.getColumns();
            for (TableColumn tableColumn2 : list) {
                arrayList.add(new ColumnState((TableColumnExt)tableColumn2, list2.indexOf(tableColumn2)));
            }
            XTableState xTableState = new XTableState(arrayList.toArray(new ColumnState[arrayList.size()]));
            xTableState.setHorizontalScrollEnabled(jXTable.isHorizontalScrollEnabled());
            tableColumn2 = SortKey.getFirstSortingKey((List)jXTable.getFilters().getSortController().getSortKeys());
            if (tableColumn2 != null) {
                xTableState.setSortKey((SortKey)tableColumn2);
            }
            return xTableState;
        }

        @Override
        public void setSessionState(Component component, Object object) {
            this.checkComponent(component);
            JXTable jXTable = (JXTable)component;
            XTableState xTableState = (XTableState)object;
            ColumnState[] columnStateArray = xTableState.getColumnStates();
            List list = jXTable.getColumns(true);
            if (this.canRestore(columnStateArray, list)) {
                for (int i = 0; i < columnStateArray.length; ++i) {
                    columnStateArray[i].configureColumn((TableColumnExt)list.get(i));
                }
                this.restoreVisibleSequence(columnStateArray, jXTable.getColumnModel());
            }
            jXTable.setHorizontalScrollEnabled(xTableState.getHorizontalScrollEnabled());
            if (xTableState.getSortKey() != null) {
                jXTable.getFilters().getSortController().setSortKeys(Collections.singletonList(xTableState.getSortKey()));
            }
        }

        private void restoreVisibleSequence(ColumnState[] columnStateArray, TableColumnModel tableColumnModel) {
            List<ColumnState> list = this.getSortedVisibleColumnStates(columnStateArray);
            for (int i = 0; i < list.size(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                int n = list.get(i).getModelIndex();
                if (n == tableColumn.getModelIndex()) continue;
                int n2 = -1;
                for (int j = i + 1; j < tableColumnModel.getColumnCount(); ++j) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                    if (tableColumn2.getModelIndex() != n) continue;
                    n2 = j;
                    break;
                }
                tableColumnModel.moveColumn(n2, i);
            }
        }

        private List<ColumnState> getSortedVisibleColumnStates(ColumnState[] columnStateArray) {
            ArrayList<ColumnState> arrayList = new ArrayList<ColumnState>();
            for (ColumnState columnState : columnStateArray) {
                if (!columnState.getVisible()) continue;
                arrayList.add(columnState);
            }
            Collections.sort(arrayList, new VisibleColumnIndexComparator());
            return arrayList;
        }

        private boolean canRestore(ColumnState[] columnStateArray, List<TableColumn> list) {
            if (columnStateArray == null || columnStateArray.length != list.size()) {
                return false;
            }
            for (int i = 0; i < columnStateArray.length; ++i) {
                if (columnStateArray[i].getModelIndex() == list.get(i).getModelIndex()) continue;
                return false;
            }
            return true;
        }

        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JXTable)) {
                throw new IllegalArgumentException("invalid component - expected JXTable");
            }
        }
    }

    static class FilePersistenceDelegate
    extends PersistenceDelegate {
        FilePersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object object, Encoder encoder) {
            File file = (File)object;
            return new Expression(object, file.getClass(), "new", new Object[]{file.toString()});
        }
    }
}

