/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import java.awt.Cursor;
import java.awt.ItemSelectable;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonListener;

public class BaseButtonListener
extends BasicButtonListener {
    public BaseButtonListener(AbstractButton abstractButton) {
        super(abstractButton);
    }

    private boolean defaultButtonFollowsFocus() {
        Boolean bl = (Boolean)UIManager.get("Button.defaultButtonFollowsFocus");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void focusGained(FocusEvent focusEvent) {
        JRootPane jRootPane;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultCapable() && (jRootPane = abstractButton.getRootPane()) != null && abstractButton.getUI() != null && this.defaultButtonFollowsFocus()) {
            jRootPane.putClientProperty("temporaryDefaultButton", abstractButton);
            jRootPane.setDefaultButton((JButton)abstractButton);
            jRootPane.putClientProperty("temporaryDefaultButton", null);
        }
        abstractButton.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        ItemSelectable itemSelectable;
        AbstractButton abstractButton = (AbstractButton)focusEvent.getSource();
        JRootPane jRootPane = abstractButton.getRootPane();
        if (jRootPane != null && abstractButton != (itemSelectable = (JButton)jRootPane.getClientProperty("initialDefaultButton")) && abstractButton.getUI() != null && this.defaultButtonFollowsFocus()) {
            jRootPane.setDefaultButton((JButton)itemSelectable);
        }
        itemSelectable = abstractButton.getModel();
        itemSelectable.setArmed(false);
        itemSelectable.setPressed(false);
        abstractButton.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        abstractButton.getModel().setRollover(true);
        abstractButton.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        abstractButton.getModel().setRollover(false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
    }
}

