/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.fast;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class FastTitlePane
extends BaseTitlePane {
    public FastTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public void paintBackground(Graphics graphics) {
        if (this.isActive()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            if (this.backgroundImage != null) {
                graphics.drawImage(this.backgroundImage, 0, 0, null);
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.alphaValue);
                graphics2D.setComposite(alphaComposite);
            }
            graphics.setColor(AbstractLookAndFeel.getWindowTitleBackgroundColor());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setComposite(composite);
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleBackgroundColor());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paintBorder(Graphics graphics) {
        ColorUIResource colorUIResource = FastLookAndFeel.getWindowInactiveBorderColor();
        if (this.isActive()) {
            colorUIResource = FastLookAndFeel.getWindowBorderColor();
        }
        JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(colorUIResource, 30.0), ColorHelper.darker(colorUIResource, 5.0), 0, 0, this.getWidth(), this.getHeight());
    }
}

