/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class HiFiBorders
extends BaseBorders {
    private static Border buttonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;
    private static Border scrollPaneBorder = null;
    private static Border toolBarBorder = null;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return HiFiBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder();
        }
        return scrollPaneBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getToolBarBorder() {
        if (toolBarBorder == null) {
            toolBarBorder = new ToolBarBorder();
        }
        return toolBarBorder;
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (!JTattooUtilities.isLeftToRight(component)) {
                        n += n3 - 15;
                    }
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n + 3, n2 + 4, n + 3, n4 - 5);
                    graphics.drawLine(n + 6, n2 + 3, n + 6, n4 - 4);
                    graphics.drawLine(n + 9, n2 + 4, n + 9, n4 - 5);
                    graphics.setColor(Color.black);
                    graphics.drawLine(n + 4, n2 + 4, n + 4, n4 - 5);
                    graphics.drawLine(n + 7, n2 + 3, n + 7, n4 - 4);
                    graphics.drawLine(n + 10, n2 + 4, n + 10, n4 - 5);
                } else {
                    graphics.setColor(Color.gray);
                    graphics.drawLine(n + 3, n2 + 3, n3 - 4, n2 + 3);
                    graphics.drawLine(n + 3, n2 + 6, n3 - 4, n2 + 6);
                    graphics.drawLine(n + 3, n2 + 9, n3 - 4, n2 + 9);
                    graphics.setColor(Color.black);
                    graphics.drawLine(n + 3, n2 + 4, n3 - 4, n2 + 4);
                    graphics.drawLine(n + 3, n2 + 7, n3 - 4, n2 + 7);
                    graphics.drawLine(n + 3, n2 + 10, n3 - 4, n2 + 10);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            Insets insets;
            Insets insets2 = new Insets(2, 2, 2, 2);
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (JTattooUtilities.isLeftToRight(component)) {
                        insets2.left = 15;
                    } else {
                        insets2.right = 15;
                    }
                } else {
                    insets2.top = 15;
                }
            }
            if ((insets = ((JToolBar)component).getMargin()) != null) {
                insets2.left += insets.left;
                insets2.top += insets.top;
                insets2.right += insets.right;
                insets2.bottom += insets.bottom;
            }
            return insets2;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public InternalFrameBorder() {
            this.insets.top = 3;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = this.isActive(component);
            int n5 = this.getTitleHeight(component);
            ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowInactiveTitleBackgroundColor();
            ColorUIResource colorUIResource2 = AbstractLookAndFeel.getWindowInactiveBorderColor();
            Color color = ColorHelper.darker(AbstractLookAndFeel.getWindowInactiveBorderColor(), 10.0);
            if (bl) {
                colorUIResource = AbstractLookAndFeel.getWindowTitleBackgroundColor();
                colorUIResource2 = AbstractLookAndFeel.getWindowBorderColor();
                color = ColorHelper.darker(AbstractLookAndFeel.getWindowBorderColor(), 10.0);
            }
            graphics.setColor(colorUIResource);
            graphics.fillRect(n, n2 + 1, n3, this.insets.top - 1);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(n + 1, n2 + n4 - 5, n3 - 2, 4);
            if (bl) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, this.insets.top, 5, n5 + 1);
            } else {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 4, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, this.insets.top, 4, n5 + 1);
            }
            graphics.setColor(colorUIResource2);
            graphics.fillRect(1, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.fillRect(n3 - 5, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawLine(n + 5 - 1, n2 + this.insets.top + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + this.insets.top + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
        }
    }

    public static class TabbedPaneBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.draw3DBorder(graphics, colorUIResource, ColorHelper.brighter(colorUIResource, 10.0), n, n2, n3, n4);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ScrollPaneBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getFrameColor();
            JTattooUtilities.draw3DBorder(graphics, colorUIResource, ColorHelper.brighter(colorUIResource, 10.0), n, n2, n3, n4);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Color frameLoColor = new Color(120, 120, 120);
        private static final Color frameLowerColor = new Color(96, 96, 96);
        private static final Color frameLowerLoColor = new Color(64, 64, 64);
        private static final Color frameLowestColor = new Color(32, 32, 32);
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            Color color = null;
            Color color2 = null;
            if (JTattooUtilities.isActive((JComponent)component)) {
                color = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 60.0);
                color2 = AbstractLookAndFeel.getFrameColor();
            } else {
                color = AbstractLookAndFeel.getFrameColor();
                color2 = ColorHelper.darker(AbstractLookAndFeel.getFrameColor(), 20.0);
            }
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
            graphics2D.setComposite(alphaComposite);
            JTattooUtilities.draw3DBorder(graphics, color, color2, 0, 0, n3, n4);
            alphaComposite = AlphaComposite.getInstance(3, 0.2f);
            graphics2D.setComposite(alphaComposite);
            JTattooUtilities.draw3DBorder(graphics, color2, color, 1, 1, n3 - 2, n4 - 2);
            graphics2D.setComposite(composite);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color frameLoColor = new Color(120, 120, 120);
        private static final Color frameLowerColor = new Color(96, 96, 96);
        private static final Color frameLowestColor = new Color(32, 32, 32);
        private static final Insets insets = new Insets(4, 8, 4, 8);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(n, n2);
            graphics.setColor(frameLoColor);
            graphics.drawLine(1, 0, n3 - 3, 0);
            graphics.drawLine(0, 1, 0, n4 - 3);
            graphics.setColor(frameLowerColor);
            graphics.drawLine(n3 - 2, 0, n3 - 2, n4 - 2);
            graphics.drawLine(1, n4 - 2, n3 - 3, n4 - 2);
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(frameLowestColor);
            graphics.drawLine(1, 1, n3 - 3, 1);
            graphics.drawLine(1, 2, 1, n4 - 3);
            graphics.setColor(Color.black);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
            graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
            alphaComposite = AlphaComposite.getInstance(3, 0.2f);
            graphics2D.setComposite(alphaComposite);
            graphics.drawLine(1, n4 - 2, 2, n4 - 1);
            graphics2D.setComposite(composite);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

