/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Point;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

final class WBMPImageEncoder
extends ImageEncoderImpl {
    private static int getNumBits(int n) {
        int n2 = 32;
        for (int i = Integer.MIN_VALUE; i != 0 && (n & i) == 0; i >>>= 1) {
            --n2;
        }
        return n2;
    }

    private static byte[] intToMultiByte(int n) {
        int n2 = WBMPImageEncoder.getNumBits(n);
        byte[] byArray = new byte[(n2 + 6) / 7];
        int n3 = byArray.length - 1;
        for (int i = 0; i <= n3; ++i) {
            byArray[i] = (byte)(n >>> (n3 - i) * 7 & 0x7F);
            if (i == n3) continue;
            int n4 = i;
            byArray[n4] = (byte)(byArray[n4] | 0xFFFFFF80);
        }
        return byArray;
    }

    public WBMPImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        Object object;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 4 || n == 5) {
            throw new IllegalArgumentException(JaiI18N.getString("WBMPImageEncoder0"));
        }
        if (sampleModel.getNumBands() != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("WBMPImageEncoder1"));
        }
        if (sampleModel.getSampleSize(0) != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("WBMPImageEncoder2"));
        }
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        this.output.write(0);
        this.output.write(0);
        this.output.write(WBMPImageEncoder.intToMultiByte(n2));
        this.output.write(WBMPImageEncoder.intToMultiByte(n3));
        Object object2 = null;
        if (sampleModel.getDataType() != 0 || !(sampleModel instanceof MultiPixelPackedSampleModel) || ((MultiPixelPackedSampleModel)sampleModel).getDataBitOffset() != 0) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n2, n3, 1, (n2 + 7) / 8, 0);
            object = Raster.createWritableRaster(multiPixelPackedSampleModel, new Point(renderedImage.getMinX(), renderedImage.getMinY()));
            ((WritableRaster)object).setRect(renderedImage.getData());
            object2 = object;
        } else {
            object2 = renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1 ? renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY()) : renderedImage.getData();
        }
        boolean bl = false;
        if (renderedImage.getColorModel() instanceof IndexColorModel) {
            object = (IndexColorModel)renderedImage.getColorModel();
            bl = ((IndexColorModel)object).getRed(0) + ((IndexColorModel)object).getGreen(0) + ((IndexColorModel)object).getBlue(0) > ((IndexColorModel)object).getRed(1) + ((IndexColorModel)object).getGreen(1) + ((IndexColorModel)object).getBlue(1);
        }
        int n4 = ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride();
        int n5 = (n2 + 7) / 8;
        byte[] byArray = ((DataBufferByte)((Raster)object2).getDataBuffer()).getData();
        if (!bl && n4 == n5) {
            this.output.write(byArray, 0, n3 * n5);
        } else {
            int n6 = 0;
            if (!bl) {
                for (int i = 0; i < n3; ++i) {
                    this.output.write(byArray, n6, n5);
                    n6 += n4;
                }
            } else {
                byte[] byArray2 = new byte[n5];
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        byArray2[j] = ~byArray[j + n6];
                    }
                    this.output.write(byArray2, 0, n5);
                    n6 += n4;
                }
            }
        }
    }
}

