/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsComboBoxButtonUI;
import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.text.JTextComponent;

public class PgsComboBoxUI
extends MetalComboBoxUI {
    private boolean iconPaintPressed = false;
    private PopupHandler popupHandler;
    private FocusHandler focusHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsComboBoxUI();
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        component.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean bl2 = false;
        if (component instanceof JPanel) {
            bl2 = true;
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
    }

    protected void installListeners() {
        super.installListeners();
        if (this.popup instanceof BasicComboPopup) {
            this.popupHandler = new PopupHandler();
            ((BasicComboPopup)this.popup).addPopupMenuListener(this.popupHandler);
            this.focusHandler = new FocusHandler();
            this.comboBox.addFocusListener(this.focusHandler);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.popup instanceof BasicComboPopup) {
            ((BasicComboPopup)this.popup).removePopupMenuListener(this.popupHandler);
            this.comboBox.removeFocusListener(this.focusHandler);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (this.comboBox.isEditable()) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("TextField.background"));
            graphics.fillRect(0, 0, jComponent.getWidth() + 1, jComponent.getHeight() + 1);
            graphics.setColor(color);
        } else {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    protected ComboBoxEditor createEditor() {
        BasicComboBoxEditor.UIResource uIResource = new BasicComboBoxEditor.UIResource();
        Component component = uIResource.getEditorComponent();
        if (component instanceof JTextComponent) {
            component.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    PgsComboBoxUI.this.comboBox.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    PgsComboBoxUI.this.comboBox.repaint();
                }
            });
        }
        return uIResource;
    }

    protected JButton createArrowButton() {
        PgsComboBoxButtonUI pgsComboBoxButtonUI = new PgsComboBoxButtonUI(this.comboBox, new PgsComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        pgsComboBoxButtonUI.setMargin(new Insets(1, 1, 1, 1));
        pgsComboBoxButtonUI.setFocusPainted(this.comboBox.isEditable());
        return pgsComboBoxButtonUI;
    }

    protected ComboPopup createPopup() {
        BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox){

            public void show(Component component, int n, int n2) {
                super.show(component, n, n2 - 1);
            }
        };
        basicComboPopup.setBorder(UIManager.getBorder("ComboBox.popup.border"));
        basicComboPopup.applyComponentOrientation(this.comboBox.getComponentOrientation());
        return basicComboPopup;
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                component.setComponentOrientation(PgsComboBoxUI.this.comboBox.getComponentOrientation());
                return component;
            }
        };
    }

    public void layoutComboBox(Container container, MetalComboBoxUI.MetalComboBoxLayoutManager metalComboBoxLayoutManager) {
        Object object;
        if (this.arrowButton != null) {
            if (this.arrowButton instanceof PgsComboBoxButtonUI) {
                object = ((PgsComboBoxButtonUI)this.arrowButton).getComboIcon();
                Insets insets = this.arrowButton.getInsets();
                Insets insets2 = this.comboBox.getInsets();
                int n = object.getIconWidth() + insets.left + insets.right;
                this.arrowButton.setBounds(PgsUtils.isLeftToRight(this.comboBox) ? this.comboBox.getWidth() - insets2.right - n : insets2.left + 2, insets2.top + 2, n - 2, this.comboBox.getHeight() - insets2.top - insets2.bottom - 4);
            } else {
                object = this.comboBox.getInsets();
                int n = this.comboBox.getWidth();
                int n2 = this.comboBox.getHeight();
                this.arrowButton.setBounds(((Insets)object).left, ((Insets)object).top, n - (((Insets)object).left + ((Insets)object).right), n2 - (((Insets)object).top + ((Insets)object).bottom));
            }
        }
        if (this.editor != null) {
            object = this.rectangleForCurrentValue();
            this.editor.setBounds((Rectangle)object);
        }
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = n2 - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            if (this.arrowButton instanceof PgsComboBoxButtonUI) {
                Icon icon = ((PgsComboBoxButtonUI)this.arrowButton).getComboIcon();
                Insets insets2 = this.arrowButton.getInsets();
                n3 = icon.getIconWidth() + insets2.left + insets2.right;
            } else {
                n3 = this.arrowButton.getWidth();
            }
        }
        if (PgsUtils.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left + 2, insets.top + 1, n - (insets.left + insets.right + n3 + 4), n2 - (insets.top + insets.bottom) - 2);
        }
        return new Rectangle(insets.left + n3 + 2, insets.top + 1, n - (insets.left + insets.right + n3 + 4), n2 - (insets.top + insets.bottom) - 2);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof PgsComboBoxButtonUI) {
            PgsComboBoxButtonUI pgsComboBoxButtonUI = (PgsComboBoxButtonUI)this.arrowButton;
            Insets insets = pgsComboBoxButtonUI.getInsets();
            Insets insets2 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.width += insets2.left + insets2.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets.right + pgsComboBoxButtonUI.getComboIcon().getIconWidth();
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
            dimension.height -= 6;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            Insets insets = this.arrowButton.getMargin();
            dimension.height += insets.top + insets.bottom - 2;
            dimension.width += insets.left + insets.right;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new PgsPropertyChangeListener();
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            PgsComboBoxUI.this.iconPaintPressed = false;
            PgsComboBoxUI.this.comboBox.repaint();
        }
    }

    private class PopupHandler
    implements PopupMenuListener {
        private PopupHandler() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            PgsComboBoxUI.this.iconPaintPressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PgsComboBoxUI.this.comboBox.repaint();
                }
            });
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            PgsComboBoxUI.this.iconPaintPressed = true;
        }
    }

    private class PgsComboBoxIcon
    implements Icon {
        private PgsComboBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JButton jButton = (JButton)component;
            int n3 = this.getIconWidth();
            graphics.translate(n, n2);
            graphics.setColor(jButton.isEnabled() ? PgsLookAndFeel.getControlInfo() : PgsLookAndFeel.getControlShadow());
            if (PgsComboBoxUI.this.iconPaintPressed) {
                graphics.drawLine(1, 3, 1 + n3 - 3, 3);
                graphics.drawLine(2, 2, 2 + n3 - 5, 2);
                graphics.drawLine(3, 1, 3 + n3 - 7, 1);
                graphics.drawLine(4, 0, 4 + n3 - 9, 0);
            } else {
                graphics.drawLine(1, 1, 1 + (n3 - 3), 1);
                graphics.drawLine(2, 2, 2 + (n3 - 5), 2);
                graphics.drawLine(3, 3, 3 + (n3 - 7), 3);
                graphics.drawLine(4, 4, 4 + (n3 - 9), 4);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 4;
        }
    }

    public class PgsPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public PgsPropertyChangeListener() {
            super(PgsComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if ("editable".equals(string)) {
                PgsComboBoxButtonUI pgsComboBoxButtonUI = (PgsComboBoxButtonUI)PgsComboBoxUI.this.arrowButton;
                pgsComboBoxButtonUI.setIconOnly(PgsComboBoxUI.this.comboBox.isEditable());
                PgsComboBoxUI.this.comboBox.repaint();
                pgsComboBoxButtonUI.setFocusPainted(PgsComboBoxUI.this.comboBox.isEditable());
            } else if ("background".equals(string)) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PgsComboBoxUI.this.arrowButton.setBackground(color);
                PgsComboBoxUI.this.listBox.setBackground(color);
            } else if ("foreground".equals(string)) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PgsComboBoxUI.this.arrowButton.setForeground(color);
                PgsComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

