/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JInternalFrame;

public class LunaInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    private static final Color frameColor = new Color(0, 25, 207);

    public LunaInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected int getHorSpacing() {
        return 2;
    }

    protected int getVerSpacing() {
        return 5;
    }

    public void paintPalette(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (JTattooUtilities.isFrameActive(this)) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, n, n2);
            graphics.setColor(frameColor);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, n, n2);
            graphics.setColor(ColorHelper.brighter(frameColor, 20.0));
        }
        graphics.drawLine(0, n2 - 1, n, n2 - 1);
    }

    public void paintBackground(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (JTattooUtilities.isActive(this)) {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, n, n2);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, n, n2);
        }
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            graphics.setColor(LunaLookAndFeel.getTheme().getWindowBorderColor());
            JTattooUtilities.drawString(this.frame, graphics, string, n - 1, n2 - 1);
            graphics.setColor(ColorHelper.darker(LunaLookAndFeel.getTheme().getWindowBorderColor(), 25.0));
            JTattooUtilities.drawString(this.frame, graphics, string, n + 1, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
    }

    public void paintBorder(Graphics graphics) {
        if (!JTattooUtilities.isActive(this)) {
            graphics.setColor(ColorHelper.brighter(frameColor, 20.0));
        } else {
            graphics.setColor(frameColor);
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }
}

