/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseToggleButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class MintToggleButtonUI
extends BaseToggleButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MintToggleButtonUI();
    }

    protected void paintBackground(Graphics graphics, AbstractButton abstractButton) {
        Object object;
        if (!abstractButton.isContentAreaFilled() || abstractButton.getParent() instanceof JMenuBar) {
            return;
        }
        if (!abstractButton.isBorderPainted() || !(abstractButton.getBorder() instanceof UIResource)) {
            super.paintBackground(graphics, abstractButton);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = abstractButton.getWidth() - 2;
        int n2 = abstractButton.getHeight() - 2;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            ColorUIResource colorUIResource = MintLookAndFeel.getTheme().getSelectionBackgroundColor();
            graphics2D.setColor(colorUIResource);
            graphics2D.fillRoundRect(0, 0, n, n2, n2, n2);
            graphics2D.setColor(MintLookAndFeel.getTheme().getFrameColor());
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, n2, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            return;
        }
        if (buttonModel.isSelected()) {
            Color color = abstractButton.getParent().getBackground();
            Color[] colorArray = ColorHelper.createColorArr(MintLookAndFeel.getTheme().getBackgroundColor(), Color.white, 20);
            Shape shape = graphics2D.getClip();
            Area area = new Area(new Area(new RoundRectangle2D.Double(0.0, 0.0, n, n2, n2, n2)));
            graphics2D.setClip(area);
            JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n, n2);
            graphics2D.setClip(shape);
            JTattooUtilities.drawRound3DBorder(graphics, ColorHelper.darker(color, 5.0), ColorHelper.brighter(color, 80.0), 0, 0, n, n2);
            JTattooUtilities.drawRound3DBorder(graphics, ColorHelper.darker(color, 20.0), ColorHelper.brighter(color, 10.0), 1, 1, n - 2, n2 - 2);
            return;
        }
        Color[] colorArray = MintLookAndFeel.getTheme().getButtonColors();
        if (!buttonModel.isEnabled()) {
            colorArray = MintLookAndFeel.getTheme().getDisabledColors();
        } else if (buttonModel.isRollover()) {
            object = MintLookAndFeel.getTheme().getRolloverColors();
            colorArray = new Color[((Color[])object).length];
            System.arraycopy(object, 0, colorArray, 0, colorArray.length);
            colorArray[colorArray.length - 2] = ColorHelper.darker(colorArray[colorArray.length - 2], 15.0);
        }
        object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = abstractButton.getParent().getBackground();
        graphics2D.setColor(ColorHelper.darker(color, 6.0));
        graphics2D.drawRoundRect(2, 2, n - 1, n2 - 1, n2, n2);
        graphics2D.setColor(ColorHelper.darker(color, 18.0));
        graphics2D.drawRoundRect(1, 1, n - 1, n2 - 1, n2, n2);
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        for (int i = colorArray.length - 1; i >= 0; --i) {
            graphics2D.setColor(colorArray[i]);
            graphics2D.fillRoundRect(n3, n4, n5, n6, n6, n6);
            --n6;
            --n5;
            if ((i + 1) % 4 == 0) {
                ++n3;
                ++n4;
            }
            if (n6 == 0) break;
        }
        graphics2D.setColor(Color.white);
        graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, n2 - 2, n2 - 2);
        graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, n2 - 2, n2 - 2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(AbstractLookAndFeel.getFocusColor());
        int n = abstractButton.getHeight() - 6;
        graphics2D.drawRoundRect(2, 2, abstractButton.getWidth() - 7, abstractButton.getHeight() - 7, n, n);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

