/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BaseSliderUI
extends BasicSliderUI {
    protected boolean isRollover = false;

    public BaseSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseSliderUI((JSlider)jComponent);
    }

    public BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new MyTrackListener();
    }

    public Icon getThumbHorIcon() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            return ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory().getThumbHorIcon();
        }
        return null;
    }

    public Icon getThumbHorIconRollover() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            return ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory().getThumbHorIconRollover();
        }
        return null;
    }

    public Icon getThumbVerIcon() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            return ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory().getThumbVerIcon();
        }
        return null;
    }

    public Icon getThumbVerIconRollover() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            return ((AbstractLookAndFeel)UIManager.getLookAndFeel()).getIconFactory().getThumbVerIconRollover();
        }
        return null;
    }

    protected int getTrackWidth() {
        if (this.slider.getOrientation() == 0) {
            return this.thumbRect.height - 9;
        }
        return this.thumbRect.width - 9;
    }

    protected Dimension getThumbSize() {
        Dimension dimension = super.getThumbSize();
        if (this.getThumbHorIcon() != null && this.getThumbVerIcon() != null) {
            if (this.slider.getOrientation() == 0) {
                dimension.width = this.getThumbHorIcon().getIconWidth();
                dimension.height = this.getThumbHorIcon().getIconHeight();
            } else {
                dimension.width = this.getThumbVerIcon().getIconWidth();
                dimension.height = this.getThumbVerIcon().getIconHeight();
            }
        }
        return dimension;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics, jComponent);
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (this.slider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (this.slider.hasFocus() && rectangle.intersects(this.focusRect)) {
            this.paintFocus(graphics);
        }
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
    }

    public void paintBackground(Graphics graphics, JComponent jComponent) {
        if (jComponent.getBackground() instanceof ColorUIResource) {
            graphics.setColor(AbstractLookAndFeel.getBackgroundColor());
        } else {
            graphics.setColor(jComponent.getBackground());
        }
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void paintTrack(Graphics graphics) {
        boolean bl = JTattooUtilities.isLeftToRight(this.slider);
        graphics.translate(this.trackRect.x, this.trackRect.y);
        int n = 4;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.slider.getOrientation() == 0) {
            n5 = this.trackRect.height - 1 - n;
            n3 = n5 - (this.getTrackWidth() - 1);
            n4 = this.trackRect.width - 1;
        } else {
            if (bl) {
                n2 = this.trackRect.width - n - this.getTrackWidth();
                n4 = this.trackRect.width - n - 1;
            } else {
                n2 = n;
                n4 = n + this.getTrackWidth() - 1;
            }
            n5 = this.trackRect.height - 1;
        }
        graphics.setColor(AbstractLookAndFeel.getFrameColor());
        graphics.drawRect(n2, n3, n4 - n2 - 1, n5 - n3 - 1);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (this.slider.getOrientation() == 0) {
            n6 = this.thumbRect.x + this.thumbRect.width / 2;
            n6 -= this.trackRect.x;
            n7 = n3 + 1;
            n9 = n5 - 2;
            if (!this.drawInverted()) {
                n8 = n2 + 1;
                n10 = n6;
            } else {
                n8 = n6;
                n10 = n4 - 2;
            }
            if (this.slider.isEnabled()) {
                Color[] colorArray = null;
                colorArray = !JTattooUtilities.isActive(this.slider) ? AbstractLookAndFeel.getTheme().getInActiveColors() : AbstractLookAndFeel.getTheme().getSliderColors();
                JTattooUtilities.fillHorGradient(graphics, colorArray, n8 + 2, n7 + 2, n10 - n8 - 2, n9 - n7 - 2);
                Color color = ColorHelper.darker(colorArray[colorArray.length - 1], 5.0);
                Color color2 = ColorHelper.darker(colorArray[colorArray.length - 1], 10.0);
                JTattooUtilities.draw3DBorder(graphics, color, color2, n8 + 1, n7 + 1, n10 - n8 - 1, n9 - n7 - 1);
            } else {
                graphics.setColor(this.slider.getBackground());
                graphics.fillRect(n8, n7, n10 - n8, n9 - n7);
            }
        } else {
            n6 = this.thumbRect.y + this.thumbRect.height / 2;
            n6 -= this.trackRect.y;
            n8 = n2 + 1;
            n10 = n4 - 2;
            if (!this.drawInverted()) {
                n7 = n6;
                n9 = n5 - 2;
            } else {
                n7 = n3 + 1;
                n9 = n6;
            }
            if (this.slider.isEnabled()) {
                Color[] colorArray = null;
                colorArray = !JTattooUtilities.isActive(this.slider) ? AbstractLookAndFeel.getTheme().getInActiveColors() : AbstractLookAndFeel.getTheme().getSliderColors();
                JTattooUtilities.fillVerGradient(graphics, colorArray, n8 + 2, n7 + 2, n10 - n8 - 2, n9 - n7 - 2);
                Color color = ColorHelper.darker(colorArray[colorArray.length - 1], 5.0);
                Color color3 = ColorHelper.darker(colorArray[colorArray.length - 1], 10.0);
                JTattooUtilities.draw3DBorder(graphics, color, color3, n8 + 1, n7 + 1, n10 - n8 - 1, n9 - n7 - 1);
            } else {
                graphics.setColor(this.slider.getBackground());
                graphics.fillRect(n8, n7, n10 - n8 + 1, n9 - n7 + 1);
            }
        }
        graphics.translate(-this.trackRect.x, -this.trackRect.y);
    }

    public void paintTicks(Graphics graphics) {
        boolean bl = JTattooUtilities.isLeftToRight(this.slider);
        Rectangle rectangle = this.tickRect;
        graphics.setColor(AbstractLookAndFeel.getForegroundColor());
        if (this.slider.getOrientation() == 0) {
            int n;
            graphics.translate(0, rectangle.y);
            int n2 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                for (n = this.slider.getMinimum(); n <= this.slider.getMaximum(); n += this.slider.getMinorTickSpacing()) {
                    n2 = this.xPositionForValue(n);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n2);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (n = this.slider.getMinimum(); n <= this.slider.getMaximum(); n += this.slider.getMajorTickSpacing()) {
                    n2 = this.xPositionForValue(n);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n2);
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            graphics.translate(rectangle.x, 0);
            int n = this.slider.getMinimum();
            int n3 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int n4 = 0;
                if (!bl) {
                    n4 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n4, 0);
                }
                while (n <= this.slider.getMaximum()) {
                    n3 = this.yPositionForValue(n);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n3);
                    n += this.slider.getMinorTickSpacing();
                }
                if (!bl) {
                    graphics.translate(-n4, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n = this.slider.getMinimum();
                if (!bl) {
                    graphics.translate(2, 0);
                }
                while (n <= this.slider.getMaximum()) {
                    n3 = this.yPositionForValue(n);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n3);
                    n += this.slider.getMajorTickSpacing();
                }
                if (!bl) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    public void paintThumb(Graphics graphics) {
        Icon icon = null;
        if (this.slider.getOrientation() == 0) {
            if (this.isRollover && this.slider.isEnabled()) {
                icon = this.getThumbHorIconRollover();
            } else if (this.slider.isEnabled()) {
                icon = this.getThumbHorIcon();
            }
        } else if (this.isRollover && this.slider.isEnabled()) {
            icon = this.getThumbVerIconRollover();
        } else if (this.slider.isEnabled()) {
            icon = this.getThumbVerIcon();
        }
        if (icon != null) {
            icon.paintIcon(null, graphics, this.thumbRect.x, this.thumbRect.y);
        }
    }

    protected class MyTrackListener
    extends BasicSliderUI.TrackListener {
        protected MyTrackListener() {
            super(BaseSliderUI.this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            BaseSliderUI.this.isRollover = BaseSliderUI.this.thumbRect.contains(mouseEvent.getPoint());
            BaseSliderUI.this.paintThumb(BaseSliderUI.this.slider.getGraphics());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            boolean bl = BaseSliderUI.this.thumbRect.contains(mouseEvent.getPoint());
            if (bl != BaseSliderUI.this.isRollover) {
                BaseSliderUI.this.isRollover = bl;
                BaseSliderUI.this.paintThumb(BaseSliderUI.this.slider.getGraphics());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            BaseSliderUI.this.isRollover = false;
            BaseSliderUI.this.paintThumb(BaseSliderUI.this.slider.getGraphics());
        }
    }
}

