/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import com.jtattoo.plaf.acryl.icons.ImageHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.plaf.ColorUIResource;

public class AcrylIcons
extends BaseIcons {
    private static Icon iconIcon = null;
    private static Icon maxIcon = null;
    private static Icon minIcon = null;
    private static Icon closeIcon = null;
    private static Icon treeOpenIcon = null;
    private static Icon treeClosedIcon = null;
    private static Icon radioButtonIcon = null;
    private static Icon checkBoxIcon = null;
    private static Icon thumbHorIcon = null;
    private static Icon thumbHorIconRollover = null;
    private static Icon thumbVerIcon = null;
    private static Icon thumbVerIconRollover = null;

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = new TitleButtonIcon(0);
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = new TitleButtonIcon(1);
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = new TitleButtonIcon(2);
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new TitleButtonIcon(3);
        }
        return closeIcon;
    }

    public static Icon getTreeControlIcon(boolean bl) {
        if (!AcrylLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getTreeControlIcon(bl);
        }
        if (bl) {
            if (treeClosedIcon == null) {
                treeClosedIcon = ImageHelper.loadImage("TreeClosedButton.gif");
            }
            return treeClosedIcon;
        }
        if (treeOpenIcon == null) {
            treeOpenIcon = ImageHelper.loadImage("TreeOpenButton.gif");
        }
        return treeOpenIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getThumbHorIcon() {
        if (!AcrylLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getThumbHorIcon();
        }
        if (thumbHorIcon == null) {
            thumbHorIcon = ImageHelper.loadImage("thumb_hor.gif");
        }
        return thumbHorIcon;
    }

    public static Icon getThumbVerIcon() {
        if (!AcrylLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getThumbVerIcon();
        }
        if (thumbVerIcon == null) {
            thumbVerIcon = ImageHelper.loadImage("thumb_ver.gif");
        }
        return thumbVerIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (!AcrylLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getThumbHorIconRollover();
        }
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = ImageHelper.loadImage("thumb_hor_rollover.gif");
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (!AcrylLookAndFeel.getControlColorLight().equals(new ColorUIResource(96, 98, 100))) {
            return BaseIcons.getThumbVerIconRollover();
        }
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = ImageHelper.loadImage("thumb_ver_rollover.gif");
        }
        return thumbVerIconRollover;
    }

    private static class RadioButtonIcon
    implements Icon {
        private static Icon radioIcon = ImageHelper.loadImage("RadioSymbol.gif");
        private static final int WIDTH = 13;
        private static final int HEIGHT = 13;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Color color = AbstractLookAndFeel.getFrameColor();
            graphics2D.setColor(AbstractLookAndFeel.getTheme().getControlShadowColor());
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawOval(n + 1, n2 + 1, 12, 12);
            Shape shape = graphics.getClip();
            Area area = new Area(shape);
            Area area2 = new Area(new Ellipse2D.Double(n, n2, 13.0, 13.0));
            area2.intersect(area);
            graphics2D.setClip(area2);
            if (!abstractButton.isEnabled()) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getDisabledColors(), n, n2, 13, 13);
                color = ColorHelper.brighter(color, 40.0);
            } else if (buttonModel.isRollover()) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), n, n2, 13, 13);
                color = AbstractLookAndFeel.getTheme().getRolloverColor();
            } else if (JTattooUtilities.isFrameActive(abstractButton)) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getDefaultColors(), n, n2, 13, 13);
            } else {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getInActiveColors(), n, n2, 13, 13);
                color = ColorHelper.brighter(color, 40.0);
            }
            graphics2D.setClip(shape);
            graphics2D.setColor(color);
            graphics2D.drawOval(n, n2, 12, 12);
            if (buttonModel.isSelected()) {
                int n3 = 0;
                n3 = buttonModel.isRollover() ? ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getRolloverColorDark()) : ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getControlColorDark());
                if (n3 > 128 || !buttonModel.isEnabled() || !JTattooUtilities.isFrameActive(abstractButton)) {
                    graphics.setColor(Color.black);
                    graphics.fillOval(n + 6 - 2, n2 + 6 - 2, 5, 5);
                } else {
                    int n4 = n + (13 - radioIcon.getIconWidth()) / 2;
                    int n5 = n2 + (13 - radioIcon.getIconHeight()) / 2;
                    radioIcon.paintIcon(component, graphics, n4, n5);
                }
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public int getIconWidth() {
            return 17;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon {
        private static Icon checkIcon = ImageHelper.loadImage("CheckSymbol.gif");
        private static Icon checkPressedIcon = ImageHelper.loadImage("CheckPressedSymbol.gif");
        private static Icon checkInactiveIcon = com.jtattoo.plaf.icons.ImageHelper.loadImage("CheckSymbol.gif");
        private static final int WIDTH = 14;
        private static final int HEIGHT = 14;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Color color = AbstractLookAndFeel.getFrameColor();
            if (!abstractButton.isEnabled()) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getDisabledColors(), n + 1, n2 + 1, 12, 12);
                color = ColorHelper.brighter(color, 40.0);
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover() && !buttonModel.isArmed()) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getRolloverColors(), n + 1, n2 + 1, 12, 12);
                color = AbstractLookAndFeel.getTheme().getRolloverColor();
            } else if (JTattooUtilities.isFrameActive(abstractButton)) {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getDefaultColors(), n + 1, n2 + 1, 12, 12);
            } else {
                JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getInActiveColors(), n + 1, n2 + 1, 12, 12);
                color = ColorHelper.brighter(color, 40.0);
            }
            graphics.setColor(AbstractLookAndFeel.getTheme().getControlShadowColor());
            graphics.drawRect(n, n2, 13, 13);
            graphics.setColor(color);
            graphics.drawLine(n + 1, n2, n + 14 - 2, n2);
            graphics.drawLine(n + 1, n2 + 14 - 1, n + 14 - 2, n2 + 14 - 1);
            graphics.drawLine(n, n2 + 1, n, n2 + 14 - 2);
            graphics.drawLine(n + 14 - 1, n2 + 1, n + 14 - 1, n2 + 14 - 2);
            graphics.setColor(AbstractLookAndFeel.getTheme().getControlShadowColor());
            graphics.drawLine(n + 14, n2 + 2, n + 14, n2 + 14 - 1);
            graphics.drawLine(n + 2, n2 + 14, n + 14 - 1, n2 + 14);
            int n3 = n + (14 - checkInactiveIcon.getIconWidth()) / 2 - 1;
            int n4 = n2 + (14 - checkInactiveIcon.getIconHeight()) / 2 - 1;
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                checkPressedIcon.paintIcon(component, graphics, n3 + 1, n4 + 1);
            } else if (buttonModel.isSelected()) {
                int n5 = 0;
                n5 = buttonModel.isRollover() ? ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getRolloverColorDark()) : ColorHelper.getGrayValue(AbstractLookAndFeel.getTheme().getControlColorDark());
                if (n5 > 128 || !buttonModel.isEnabled() || !JTattooUtilities.isFrameActive(abstractButton)) {
                    checkInactiveIcon.paintIcon(component, graphics, n3 + 1, n4 + 1);
                } else {
                    checkIcon.paintIcon(component, graphics, n3, n4);
                }
            }
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 14;
        }
    }

    private static class TitleButtonIcon
    implements Icon {
        private static Color extraLightGray = new Color(240, 240, 240);
        private static Color closerColorLight = new Color(241, 172, 154);
        private static Color closerColorDark = new Color(224, 56, 2);
        public static final int ICON_ICON_TYP = 0;
        public static final int MIN_ICON_TYP = 1;
        public static final int MAX_ICON_TYP = 2;
        public static final int CLOSE_ICON_TYP = 3;
        private int iconTyp = 0;

        public TitleButtonIcon(int n) {
            this.iconTyp = n;
        }

        public int getIconHeight() {
            return 20;
        }

        public int getIconWidth() {
            return 20;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Object object;
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            JButton jButton = (JButton)component;
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = JTattooUtilities.isActive(jButton);
            boolean bl2 = jButton.getModel().isPressed();
            boolean bl3 = jButton.getModel().isArmed();
            boolean bl4 = jButton.getModel().isRollover();
            ColorUIResource colorUIResource = AbstractLookAndFeel.getTheme().getWindowBorderColor();
            Color color = ColorHelper.brighter(colorUIResource, 60.0);
            Color color2 = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowTitleColorLight(), 40.0);
            Color color3 = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 10.0);
            Color color4 = Color.black;
            if (this.iconTyp == 3) {
                color2 = closerColorLight;
                color3 = closerColorDark;
            }
            if (!bl) {
                color2 = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight(), 40.0);
                color3 = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark(), 10.0);
                color4 = AbstractLookAndFeel.getTheme().getControlShadow();
                colorUIResource = AbstractLookAndFeel.getTheme().getWindowInactiveBorderColor();
                color = ColorHelper.brighter(color, 80.0);
            }
            if (bl2 && bl3) {
                object = ColorHelper.darker(color3, 10.0);
                color3 = ColorHelper.darker(color2, 10.0);
                color2 = object;
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, n3, n4, color3));
                graphics.fillRect(2, 2, n3 - 3, n4 - 3);
            } else if (bl4) {
                color = ColorHelper.brighter(color, 50.0);
                if (this.iconTyp == 3) {
                    color2 = closerColorLight;
                    color4 = color3 = closerColorDark;
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, n3, n4, color3));
                    graphics2D.fillRect(2, 2, n3 - 3, n4 - 3);
                } else {
                    JTattooUtilities.fillHorGradient(graphics2D, AbstractLookAndFeel.getTheme().getRolloverColors(), 2, 2, n3 - 3, n4 - 3);
                }
            }
            if (bl) {
                graphics2D.setColor(colorUIResource);
                graphics2D.drawLine(1, 0, n3 - 2, 0);
                graphics2D.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
                graphics2D.drawLine(0, 1, 0, n4 - 2);
                graphics2D.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
                graphics2D.setColor(color);
                graphics2D.drawRect(1, 1, n3 - 3, n4 - 3);
            }
            object = null;
            if (this.iconTyp == 0) {
                object = new BaseIcons.IconSymbol(extraLightGray, color4, null, new Insets(0, 5, 0, 5));
            } else if (this.iconTyp == 1) {
                object = new BaseIcons.MinSymbol(extraLightGray, color4, null, new Insets(0, 4, 0, 4));
            } else if (this.iconTyp == 2) {
                object = new BaseIcons.MaxSymbol(extraLightGray, color4, null, new Insets(0, 4, 0, 4));
            } else if (this.iconTyp == 3) {
                object = new BaseIcons.CloseSymbol(Color.white, ColorHelper.darker(color4, 50.0), null, new Insets(0, 5, 0, 5));
            }
            if (object != null) {
                object.paintIcon(component, graphics, 0, 0);
            }
        }
    }
}

