/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class AcrylTabbedPaneUI
extends BaseTabbedPaneUI {
    private static Color[] SEP_INACTIVE_COLORS = new Color[]{new Color(200, 200, 200), new Color(230, 230, 230), new Color(220, 220, 220), new Color(200, 200, 200)};

    public static ComponentUI createUI(JComponent jComponent) {
        return new AcrylTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets.bottom = 5;
    }

    protected Color[] getTabColors(int n, boolean bl) {
        if (n >= 0 && n < this.tabPane.getTabCount()) {
            Color color = this.tabPane.getBackgroundAt(n);
            Color[] colorArray = AbstractLookAndFeel.getTheme().getInActiveColors();
            if (JTattooUtilities.isActive(this.tabPane)) {
                colorArray = color instanceof UIResource ? (bl ? AbstractLookAndFeel.getTheme().getDefaultColors() : (n == this.rolloverIndex ? AbstractLookAndFeel.getTheme().getRolloverColors() : AbstractLookAndFeel.getTheme().getTabColors())) : (bl ? (this.tabPane.getTabPlacement() == 3 ? ColorHelper.createColorArr(color, ColorHelper.brighter(color, 50.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(color, 50.0), color, 20)) : (n == this.rolloverIndex ? ColorHelper.createColorArr(ColorHelper.brighter(color, 80.0), ColorHelper.brighter(color, 20.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(color, 40.0), ColorHelper.darker(color, 10.0), 20)));
            }
            return colorArray;
        }
        return AbstractLookAndFeel.getTheme().getTabColors();
    }

    protected Color[] getContentBorderColors(int n) {
        if (JTattooUtilities.isActive(this.tabPane)) {
            Color[] colorArray = new Color[]{ColorHelper.brighter(AcrylLookAndFeel.getControlColorLight(), 20.0), AcrylLookAndFeel.getControlColorLight(), ColorHelper.brighter(AcrylLookAndFeel.getControlColorDark(), 20.0), AcrylLookAndFeel.getControlColorDark(), ColorHelper.darker(AcrylLookAndFeel.getControlColorDark(), 20.0)};
            return colorArray;
        }
        return SEP_INACTIVE_COLORS;
    }

    protected Color getGapColor(int n) {
        if (JTattooUtilities.isActive(this.tabPane) && n == this.tabPane.getSelectedIndex()) {
            Color[] colorArray = AbstractLookAndFeel.getTheme().getDefaultColors();
            return colorArray[colorArray.length - 1];
        }
        return super.getGapColor(n);
    }

    protected Font getTabFont(boolean bl) {
        if (bl) {
            return super.getTabFont(bl).deriveFont(1);
        }
        return super.getTabFont(bl);
    }

    protected void paintRoundedTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n6 = 10;
        if (!JTattooUtilities.isActive(this.tabPane)) {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 60.0));
        } else if (bl) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
        } else {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0));
        }
        graphics.drawLine(n2 + 5, n3, n4 - 5, n3);
        graphics.drawArc(n2, n3, n6, n6, 90, 90);
        graphics.drawArc(n4 - n6, n3, n6, n6, 0, 90);
        graphics.drawLine(n2, n3 + 5 + 1, n2, n5);
        graphics.drawLine(n4, n3 + 5 + 1, n4, n5);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void paintRoundedBottomTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n6 = 10;
        if (!JTattooUtilities.isActive(this.tabPane)) {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 60.0));
        } else if (bl) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
        } else {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 40.0));
        }
        graphics.drawLine(n2 + 5, n5, n4 - 5, n5);
        graphics.drawArc(n2, n5 - n6, n6, n6, 180, 90);
        graphics.drawArc(n4 - n6, n5 - n6, n6, n6, -90, 90);
        graphics.drawLine(n2, n3, n2, n5 - 5 - 1);
        graphics.drawLine(n4, n3, n4, n5 - 5 - 1);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            view.paint(graphics, rectangle);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        } else {
            int n3 = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
                if (bl && JTattooUtilities.isActive(this.tabPane) && this.tabPane.getBackgroundAt(n2) instanceof UIResource) {
                    Color color = ColorHelper.darker(AcrylLookAndFeel.getWindowTitleColorDark(), 30.0);
                    graphics.setColor(color);
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y - 1 + fontMetrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y + 1 + fontMetrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x + 1, rectangle.y - 1 + fontMetrics.getAscent());
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
                    graphics.setColor(AbstractLookAndFeel.getTheme().getWindowTitleForegroundColor());
                } else {
                    graphics.setColor(this.tabPane.getForegroundAt(n2));
                }
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2).brighter());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n2).darker());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }
}

