/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.aluminium.AluminiumLookAndFeel;
import com.jtattoo.plaf.aluminium.icons.ImageHelper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.plaf.UIResource;

public class AluminiumIcons
extends BaseIcons {
    private static final Color foreColor = new Color(32, 32, 32);
    private static final Color shadowColor = new Color(232, 232, 232);
    private static final Color rolloverColor = new Color(196, 0, 0);
    private static Icon iconIcon = null;
    private static Icon maxIcon = null;
    private static Icon minIcon = null;
    private static Icon closeIcon = null;
    private static Icon radioButtonIcon = null;
    private static Icon checkBoxIcon = null;
    private static Icon thumbHorIcon = null;
    private static Icon thumbHorIconRollover = null;
    private static Icon thumbVerIcon = null;
    private static Icon thumbVerIconRollover = null;

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = new BaseIcons.IconSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = new BaseIcons.MinSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = new BaseIcons.MaxSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = new BaseIcons.CloseSymbol(foreColor, shadowColor, rolloverColor, new Insets(0, 0, 1, 0));
        }
        return closeIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getThumbHorIcon() {
        if (thumbHorIcon == null) {
            thumbHorIcon = ImageHelper.loadImage("thumb_hor.gif");
        }
        return thumbHorIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = ImageHelper.loadImage("thumb_hor_rollover.gif");
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIcon() {
        if (thumbVerIcon == null) {
            thumbVerIcon = ImageHelper.loadImage("thumb_ver.gif");
        }
        return thumbVerIcon;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = ImageHelper.loadImage("thumb_ver_rollover.gif");
        }
        return thumbVerIconRollover;
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private ImageIcon radioIcon = com.jtattoo.plaf.icons.ImageHelper.loadImage("RadioSymbol.gif");
        private static final int WIDTH = 14;
        private static final int HEIGHT = 14;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            Color[] colorArray = null;
            colorArray = jRadioButton.isEnabled() ? (jRadioButton.isRolloverEnabled() && buttonModel.isRollover() ? AluminiumLookAndFeel.getTheme().getRolloverColors() : AluminiumLookAndFeel.getTheme().getButtonColors()) : AluminiumLookAndFeel.getTheme().getDisabledColors();
            Shape shape = graphics.getClip();
            Area area = new Area(shape);
            Area area2 = new Area(new Ellipse2D.Double(n, n2, 15.0, 15.0));
            area2.intersect(area);
            graphics2D.setClip(area2);
            JTattooUtilities.fillHorGradient(graphics, colorArray, n, n2, 14, 14);
            graphics2D.setClip(shape);
            if (jRadioButton.isEnabled()) {
                graphics2D.setColor(AluminiumLookAndFeel.getFrameColor());
            } else {
                graphics2D.setColor(ColorHelper.brighter(AluminiumLookAndFeel.getFrameColor(), 20.0));
            }
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawOval(n, n2, 14, 14);
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(Color.white);
            graphics2D.drawOval(n + 1, n2 + 1, 12, 12);
            graphics2D.setComposite(composite);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            if (buttonModel.isSelected()) {
                int n3 = n + (14 - this.radioIcon.getIconWidth()) / 2 + 1;
                int n4 = n2 + (14 - this.radioIcon.getIconHeight()) / 2 + 1;
                this.radioIcon.paintIcon(component, graphics, n3, n4);
            }
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 14;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private ImageIcon checkIcon = com.jtattoo.plaf.icons.ImageHelper.loadImage("CheckSymbol.gif");
        private ImageIcon checkPressedIcon = com.jtattoo.plaf.icons.ImageHelper.loadImage("CheckPressedSymbol.gif");
        private static final int WIDTH = 15;
        private static final int HEIGHT = 15;

        private CheckBoxIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (!JTattooUtilities.isLeftToRight(component)) {
                n += 3;
            }
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            Color[] colorArray = null;
            colorArray = jCheckBox.isEnabled() ? (jCheckBox.isRolloverEnabled() && buttonModel.isRollover() && !buttonModel.isArmed() ? AluminiumLookAndFeel.getTheme().getRolloverColors() : (JTattooUtilities.isFrameActive(jCheckBox) ? (buttonModel.isArmed() && buttonModel.isPressed() ? new Color[]{AluminiumLookAndFeel.getBackgroundColor()} : AluminiumLookAndFeel.getTheme().getButtonColors()) : AluminiumLookAndFeel.getTheme().getInActiveColors())) : AluminiumLookAndFeel.getTheme().getDisabledColors();
            JTattooUtilities.fillHorGradient(graphics, colorArray, n, n2, 15, 15);
            if (jCheckBox.isEnabled()) {
                graphics.setColor(AluminiumLookAndFeel.getFrameColor());
            } else {
                graphics.setColor(ColorHelper.brighter(AluminiumLookAndFeel.getFrameColor(), 20.0));
            }
            graphics.drawRect(n, n2, 15, 15);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(Color.white);
            graphics2D.drawRect(n + 1, n2 + 1, 13, 13);
            graphics2D.setComposite(composite);
            int n3 = n + (15 - this.checkIcon.getIconWidth()) / 2 + 1;
            int n4 = n2 + (15 - this.checkIcon.getIconHeight()) / 2 + 1;
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                this.checkPressedIcon.paintIcon(component, graphics, n3, n4);
            } else if (buttonModel.isSelected()) {
                this.checkIcon.paintIcon(component, graphics, n3, n4);
            }
        }

        public int getIconWidth() {
            return 19;
        }

        public int getIconHeight() {
            return 15;
        }
    }
}

