/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.luna.LunaIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class LunaComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new LunaComboBoxUI();
    }

    public JButton createArrowButton() {
        return new ArrowButton();
    }

    protected void setButtonBorder() {
    }

    static class ArrowButton
    extends NoFocusButton {
        private static final Color loFrameColor = new Color(240, 240, 244);

        public ArrowButton() {
            super(LunaIcons.getComboBoxIcon());
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = this.getModel().isPressed();
            boolean bl2 = this.getModel().isRollover();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color[] colorArray = AbstractLookAndFeel.getTheme().getThumbColors();
            Color color = colorArray[0];
            Color color2 = colorArray[colorArray.length - 1];
            if (bl) {
                color = ColorHelper.darker(color, 5.0);
                color2 = ColorHelper.darker(color2, 5.0);
            } else if (bl2) {
                color = ColorHelper.brighter(color, 20.0);
                color2 = ColorHelper.brighter(color2, 20.0);
            }
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, n, n2, color2));
            graphics.fillRect(0, 0, n, n2);
            graphics2D.setPaint(null);
            if (JTattooUtilities.isLeftToRight(this)) {
                JTattooUtilities.draw3DBorder(graphics, Color.white, loFrameColor, 1, 0, n - 1, n2);
            } else {
                JTattooUtilities.draw3DBorder(graphics, Color.white, loFrameColor, 0, 0, n - 1, n2);
            }
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(color2);
            if (JTattooUtilities.isLeftToRight(this)) {
                graphics.drawLine(2, 1, n - 2, 1);
                graphics.drawLine(2, 2, 2, n2 - 2);
            } else {
                graphics.drawLine(1, 1, n - 3, 1);
                graphics.drawLine(1, 2, 1, n2 - 2);
            }
            graphics2D.setComposite(composite);
            int n3 = (n - this.getIcon().getIconWidth()) / 2 + 1;
            int n4 = (n2 - this.getIcon().getIconHeight()) / 2;
            if (this.getModel().isPressed() && this.getModel().isArmed()) {
                this.getIcon().paintIcon(this, graphics, n3 + 1, n4 + 1);
            } else {
                this.getIcon().paintIcon(this, graphics, n3, n4);
            }
        }
    }
}

