/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class MintButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MintButtonUI();
    }

    protected void paintBackground(Graphics graphics, AbstractButton abstractButton) {
        Object object;
        if (!abstractButton.isContentAreaFilled() || abstractButton.getParent() instanceof JMenuBar) {
            return;
        }
        if (!abstractButton.isBorderPainted() || !(abstractButton.getBorder() instanceof UIResource)) {
            super.paintBackground(graphics, abstractButton);
            return;
        }
        if (abstractButton.getWidth() < 32 || abstractButton.getHeight() < 16) {
            ButtonModel buttonModel = abstractButton.getModel();
            ColorUIResource colorUIResource = MintLookAndFeel.getTheme().getButtonBackgroundColor();
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource = MintLookAndFeel.getTheme().getSelectionBackgroundColor();
            } else if (buttonModel.isRollover()) {
                colorUIResource = MintLookAndFeel.getTheme().getRolloverColor();
            }
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
            JTattooUtilities.draw3DBorder(graphics, Color.white, Color.lightGray, 0, 0, abstractButton.getWidth(), abstractButton.getHeight());
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = abstractButton.getWidth() - 2;
        int n2 = abstractButton.getHeight() - 2;
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            ColorUIResource colorUIResource = MintLookAndFeel.getTheme().getSelectionBackgroundColor();
            graphics2D.setColor(colorUIResource);
            graphics2D.fillRoundRect(0, 0, n, n2, n2, n2);
            graphics2D.setColor(ColorHelper.darker(colorUIResource, 40.0));
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, n2, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            return;
        }
        Color[] colorArray = MintLookAndFeel.getTheme().getButtonColors();
        if (!buttonModel.isEnabled()) {
            colorArray = MintLookAndFeel.getTheme().getDisabledColors();
        } else if (buttonModel.isRollover()) {
            object = MintLookAndFeel.getTheme().getRolloverColors();
            colorArray = new Color[((Color[])object).length];
            System.arraycopy(object, 0, colorArray, 0, colorArray.length);
            colorArray[colorArray.length - 2] = ColorHelper.darker(colorArray[colorArray.length - 2], 15.0);
        }
        object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = abstractButton.getParent().getBackground();
        graphics2D.setColor(ColorHelper.darker(color, 6.0));
        graphics2D.drawRoundRect(2, 2, n - 1, n2 - 1, n2, n2);
        graphics2D.setColor(ColorHelper.darker(color, 18.0));
        graphics2D.drawRoundRect(1, 1, n - 1, n2 - 1, n2, n2);
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        for (int i = colorArray.length - 1; i >= 0; --i) {
            graphics2D.setColor(colorArray[i]);
            graphics2D.fillRoundRect(n3, n4, n5, n6, n6, n6);
            --n6;
            --n5;
            if ((i + 1) % 4 == 0) {
                ++n3;
                ++n4;
            }
            if (n6 == 0) break;
        }
        graphics2D.setColor(Color.white);
        graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, n2 - 2, n2 - 2);
        graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, n2 - 2, n2 - 2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(AbstractLookAndFeel.getFocusColor());
        int n = abstractButton.getHeight() - 6;
        graphics2D.drawRoundRect(2, 2, abstractButton.getWidth() - 7, abstractButton.getHeight() - 7, n, n);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }
}

