/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.painter.utils.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.icon.GlowingIcon;

public class SubstanceOptionPaneUI
extends BasicOptionPaneUI {
    private static SubstanceFillBackgroundDelegate bgDelegate;
    private OptionPaneLabel substanceIconLabel;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceOptionPaneUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        bgDelegate.updateIfOpaque(g, c);
    }

    @Override
    protected void addIcon(Container top) {
        Icon sideIcon;
        Icon icon = sideIcon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (sideIcon == null && this.optionPane != null) {
            sideIcon = super.getIconForType(this.optionPane.getMessageType());
        }
        if (sideIcon != null) {
            if (!SubstanceLookAndFeel.isToUseConstantThemesOnDialogs()) {
                sideIcon = new ImageIcon(SubstanceImageCreator.getColorSchemeImage(null, sideIcon, SubstanceColorSchemeUtilities.getColorScheme(this.optionPane, ComponentState.ACTIVE)));
            }
            this.substanceIconLabel = new OptionPaneLabel();
            this.substanceIconLabel.setIcon(new GlowingIcon(sideIcon, this.substanceIconLabel));
            this.substanceIconLabel.setName("OptionPane.iconLabel");
            this.substanceIconLabel.setVerticalAlignment(1);
            top.add((Component)this.substanceIconLabel, "Before");
        }
    }

    @Override
    protected Icon getIconForType(int messageType) {
        switch (messageType) {
            case 0: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-error.png");
            }
            case 1: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-information.png");
            }
            case 2: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-warning.png");
            }
            case 3: {
                return SubstanceCoreUtilities.getIcon("resource/32/help-browser.png");
            }
        }
        return null;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        if (this.substanceIconLabel != null) {
            FadeTracker.getInstance().trackFadeLooping(FadeKind.ICON_GLOW, LafWidgetUtilities.getAnimationKind(this.optionPane).derive(0.1f), this.substanceIconLabel, null, false, null, 3, true);
        }
    }

    static {
        FadeConfigurationManager.getInstance().allowFades(FadeKind.ICON_GLOW, OptionPaneLabel.class);
        bgDelegate = new SubstanceFillBackgroundDelegate();
    }

    protected static class OptionPaneLabel
    extends JLabel {
        protected OptionPaneLabel() {
        }
    }
}

