/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsToggleButtonUI;
import com.pagosoft.plaf.PgsUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ToolBarToggleButtonUI
extends PgsToggleButtonUI {
    private static ToolBarToggleButtonUI INSTANCE = new ToolBarToggleButtonUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setBorderPainted(false);
        abstractButton.setOpaque(false);
        abstractButton.setMargin(UIManager.getInsets("ToolBarButton.margin"));
        abstractButton.putClientProperty("rolloverBackground", UIManager.getColor("ToolBarButton.rolloverBackground"));
        abstractButton.putClientProperty("rolloverBorderColor", UIManager.get("ToolBarButton.rolloverBorderColor"));
        abstractButton.putClientProperty("pgs.isFlat", UIManager.get("ToolBarButton.isFlat"));
        abstractButton.putClientProperty("gradientStart", UIManager.get("ToolBarButton.gradientStart"));
        abstractButton.putClientProperty("gradientEnd", UIManager.get("ToolBarButton.gradientEnd"));
        abstractButton.putClientProperty("rollover.gradientStart", UIManager.get("ToolBarButton.rolloverGradientStart"));
        abstractButton.putClientProperty("rollover.gradientEnd", UIManager.get("ToolBarButton.rolloverGradientEnd"));
        abstractButton.putClientProperty("selected.gradientStart", UIManager.get("ToolBarButton.selectedGradientStart"));
        abstractButton.putClientProperty("selected.gradientEnd", UIManager.get("ToolBarButton.selectedGradientEnd"));
        Icon icon = abstractButton.getIcon();
        if (icon != null && icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            if (abstractButton.getDisabledIcon() == null) {
                abstractButton.setDisabledIcon(PgsUtils.getDisabledButtonIcon(image));
            }
            if (abstractButton.getDisabledSelectedIcon() == null) {
                abstractButton.setDisabledSelectedIcon(PgsUtils.getDisabledButtonIcon(image));
            }
            if (abstractButton.getRolloverIcon() == null) {
                abstractButton.setRolloverIcon(PgsUtils.getToolBarIcon(image));
            }
            if (abstractButton.getRolloverSelectedIcon() == null) {
                abstractButton.setRolloverSelectedIcon(PgsUtils.getToolBarIcon(image));
            }
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (jComponent.isEnabled() && abstractButton.getModel().isRollover()) {
            if (Boolean.TRUE.equals(jComponent.getClientProperty("pgs.isFlat"))) {
                graphics.setColor((Color)jComponent.getClientProperty("rolloverBackground"));
                graphics.fillRect(0, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
                graphics.setColor((Color)jComponent.getClientProperty("rolloverBorderColor"));
                graphics.drawRect(0, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
            } else {
                PgsUtils.drawGradient(graphics, jComponent, "rollover", 1, 1, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
                PgsUtils.drawButtonBorder(graphics, 0, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1, (Color)jComponent.getClientProperty("rolloverBorderColor"));
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (Boolean.TRUE.equals(abstractButton.getClientProperty("pgs.isFlat"))) {
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        } else {
            PgsUtils.drawGradient(graphics, abstractButton, "selected", 1, 1, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
        }
        super.paintButtonPressed(graphics, abstractButton);
        PgsUtils.drawButtonBorder(graphics, 0, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1, (Color)abstractButton.getClientProperty("rolloverBorderColor"));
    }
}

