/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceMap;

public final class AppPrefs {
    private static final Logger logger = Logger.getLogger(AppPrefs.class.getName());
    private final String propertiesFileName;
    private static volatile Preferences properties;
    private final ApplicationContext context;
    private String userNode;

    AppPrefs(ApplicationContext applicationContext, Map<String, String> map, boolean bl) {
        this.context = applicationContext;
        String string = applicationContext.getResourceMap().getString("Application.id", new Object[0]);
        if (string == null || string.isEmpty()) {
            throw new IllegalStateException("Config property Application.ID is empty!");
        }
        this.propertiesFileName = string.toLowerCase() + ".xml";
        properties = this.loadProperties();
        if (bl) {
            try {
                properties.clear();
            }
            catch (BackingStoreException backingStoreException) {
                LogUtils.processException(logger, backingStoreException);
            }
        }
        if (!map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string2 = entry.getValue();
                if ("default".equals(string2)) {
                    properties.remove(entry.getKey());
                    continue;
                }
                properties.put(entry.getKey(), string2);
            }
        }
    }

    public static int getProperty(String string, int n) {
        return AppPrefs.getPreferences().getInt(string, n);
    }

    public static boolean getProperty(String string, boolean bl) {
        return AppPrefs.getPreferences().getBoolean(string, bl);
    }

    public static String getProperty(String string) {
        return AppPrefs.getPreferences().get(string, null);
    }

    public static void storeProperty(String string, boolean bl) {
        AppPrefs.getPreferences().putBoolean(string, bl);
    }

    public static void storeProperty(String string, String string2) {
        AppPrefs.getPreferences().put(string, string2);
    }

    public static void storeProperty(String string, int n) {
        AppPrefs.getPreferences().putInt(string, n);
    }

    public static String getProperty(String string, String string2) {
        return AppPrefs.getPreferences().get(string, string2);
    }

    public static void removeProperty(String string) {
        AppPrefs.getPreferences().remove(string);
    }

    public void store() {
        OutputStream outputStream = null;
        try {
            if (!AppPrefs.getProperty("proxy.savepassword", false)) {
                AppPrefs.removeProperty("proxy.password");
            }
            LocalStorage localStorage = this.context.getLocalStorage();
            File file = localStorage.getDirectory();
            file.mkdirs();
            outputStream = new FileOutputStream(new File(file, this.propertiesFileName));
            AppPrefs.getPreferences().exportNode(outputStream);
            outputStream.close();
            logger.config("Preferences were saved successfuly");
        }
        catch (IOException iOException) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException2) {
                logger.log(Level.SEVERE, iOException.getMessage(), iOException2);
            }
            logger.severe("Couldn't save app getPreferences(). This is a fatal error. Please reinstall the application.");
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private String getUserNode() {
        if (this.userNode == null) {
            ResourceMap resourceMap = this.context.getResourceMap();
            String string = resourceMap.getString("Application.vendorId", new Object[0]);
            String string2 = resourceMap.getString("Application.id", new Object[0]);
            if (string.isEmpty() || string2.isEmpty()) {
                logger.warning("AppPrefs - vendor or application ID is empty");
            }
            this.userNode = string.toLowerCase() + "/" + string2.toLowerCase();
        }
        return this.userNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences loadProperties() {
        LocalStorage localStorage = this.context.getLocalStorage();
        File file = localStorage.getDirectory();
        File file2 = new File(file, this.propertiesFileName);
        if (!file2.exists()) {
            logger.log(Level.CONFIG, "File with user settings " + file2 + " was not found. First run. Using default settings");
            return Preferences.userRoot().node(this.getUserNode());
        }
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(file, this.propertiesFileName));
            Preferences.importPreferences(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.CONFIG, "User preferences file was not found (first application start?)");
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        return Preferences.userRoot().node(this.getUserNode());
    }

    public static Preferences getPreferences() {
        if (properties == null) {
            throw new IllegalStateException("Properties were not initialized yet");
        }
        return properties;
    }
}

