/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.application.ProxyHelper;
import cz.vity.freerapid.core.application.SubmitErrorInfo;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.jdesktop.application.Application;

public class SubmitErrorInfoTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(SubmitErrorInfoTask.class.getName());
    private final SubmitErrorInfo errorInfo;

    public SubmitErrorInfoTask(SubmitErrorInfo submitErrorInfo) {
        super(Application.getInstance());
        this.errorInfo = submitErrorInfo;
        this.setUserCanCancel(false);
        ProxyHelper.initProxy();
    }

    protected Void doInBackground() throws Exception {
        HttpURLConnection httpURLConnection = null;
        this.message("message.connecting", new Object[0]);
        try {
            String string = AppPrefs.getProperty("weburlSubmitError", "http://wordrider.net/posterror.php");
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            logger.info("Connected to WordRider.net, Writing params");
            String string2 = this.errorInfo.toURLPostData();
            logger.info("Posting data:" + string2);
            this.message("message.sending", new Object[0]);
            dataOutputStream.write(string2.getBytes());
            dataOutputStream.close();
            httpURLConnection.getInputStream().close();
            logger.info("disconnecting");
            this.message("message.disconnect", new Object[0]);
            httpURLConnection.disconnect();
        }
        catch (UnknownHostException unknownHostException) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw unknownHostException;
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            throw iOException;
        }
        return null;
    }
}

