/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CheckForNewVersionTask;
import cz.vity.freerapid.gui.dialogs.AboutDialog;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import java.awt.event.ActionEvent;
import org.jdesktop.application.Action;

public class HelpActions {
    public static final String CONTEXT_DIALOG_HELPPROPERTY = "contextDialogHelp";
    private MainApp app = MainApp.getInstance(MainApp.class);
    public static final String CONTEXT_DIALOG_HELP_ACTION = "contextDialogHelpAction";

    @Action
    public void paypalSupportAction() {
        Browser.openBrowser(AppPrefs.getProperty("paypal", "http://wordrider.net/freerapid/paypal"));
    }

    @Action
    public void help() {
        Swinger.showInformationDialog(this.app.getContext().getResourceMap().getString("notImplementedYet", new Object[0]));
    }

    @Action
    public void checkForNewVersion() {
        this.app.getContext().getTaskService().execute(new CheckForNewVersionTask(true));
    }

    @Action
    public void visitHomepage() {
        Browser.showHomepage();
    }

    @Action
    public void showDemo() {
        Browser.openBrowser(AppPrefs.getProperty("demoURL", "http://wordrider.net/freerapid/demo"));
    }

    @Action
    public void contextDialogHelpAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Browser.openBrowser(string);
    }

    @Action
    public void about() {
        AboutDialog aboutDialog = new AboutDialog(this.app.getMainFrame());
        this.app.prepareDialog(aboutDialog, true);
    }
}

