/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.models.NaiiveComboModel;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

abstract class AppDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(AppDialog.class.getName());
    public static final int RESULT_OK = 0;
    static final int RESULT_CANCEL = 1;
    int result = 1;
    private ActionMap actionMap = null;

    public AppDialog(Dialog dialog, boolean bl) throws HeadlessException {
        super(dialog, bl);
    }

    public AppDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
    }

    public void doClose() {
        this.dispose();
    }

    public final int getModalResult() {
        return this.result;
    }

    protected AbstractButton getBtnCancel() {
        return null;
    }

    protected AbstractButton getBtnOK() {
        return null;
    }

    public MainApp getApp() {
        return MainApp.getInstance(MainApp.class);
    }

    protected void inject() {
        Application application = Application.getInstance(Application.class);
        ApplicationContext applicationContext = application.getContext();
        applicationContext.getResourceMap(this.getClass()).injectComponents(this);
    }

    @Override
    protected final JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppDialog.this.doCancel(actionEvent);
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AppDialog.this.windowIsClosing();
            }
        });
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton;
                if (AppDialog.this.getFocusOwner() instanceof AbstractButton) {
                    abstractButton = (AbstractButton)AppDialog.this.getFocusOwner();
                    if (abstractButton instanceof JToggleButton) {
                        JToggleButton jToggleButton = (JToggleButton)abstractButton;
                        if (!jToggleButton.isSelected()) {
                            AppDialog.doButtonAction(abstractButton, actionEvent);
                            return;
                        }
                    } else {
                        AppDialog.doButtonAction(abstractButton, actionEvent);
                        return;
                    }
                }
                if ((abstractButton = AppDialog.this.getBtnOK()) != null) {
                    actionEvent.setSource(abstractButton);
                    AppDialog.doButtonAction(abstractButton, actionEvent);
                }
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        jRootPane.registerKeyboardAction(actionListener2, keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(10, 2);
        jRootPane.registerKeyboardAction(actionListener2, keyStroke, 2);
        return jRootPane;
    }

    protected void windowIsClosing() {
    }

    private void doCancel(ActionEvent actionEvent) {
        AbstractButton abstractButton = this.getBtnCancel();
        if (abstractButton != null) {
            AppDialog.doButtonAction(abstractButton, actionEvent);
        }
    }

    private static void doButtonAction(AbstractButton abstractButton, ActionEvent actionEvent) {
        Action action = abstractButton.getAction();
        if (action != null && action.isEnabled()) {
            abstractButton.doClick();
        }
    }

    void setResult(int n) {
        this.result = n;
    }

    protected ResourceMap getResourceMap() {
        return Swinger.getResourceMap(this.getClass(), AppDialog.class);
    }

    static void locateOnOpticalScreenCenter(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component.getToolkit().getScreenSize();
        component.setLocation((dimension2.width - dimension.width) / 2, (int)((double)(dimension2.height - dimension.height) * 0.45));
    }

    protected String[] getList(String string) {
        return (String[])this.getResourceMap().getObject(string + "_list", String[].class);
    }

    protected void setComboModelFromResource(JComboBox jComboBox) {
        String string = jComboBox.getName();
        assert (string != null && string.length() > 0);
        jComboBox.setModel(new NaiiveComboModel(this.getList(string)));
    }

    protected boolean validateNonEmpty(JTextComponent jTextComponent) {
        String string;
        Document document = jTextComponent.getDocument();
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
            return false;
        }
        return this.validateNonEmpty(string);
    }

    protected boolean validateNonEmpty(JTextField jTextField, String string) {
        if (!this.validateNonEmpty(string)) {
            Swinger.inputFocus(jTextField);
            return false;
        }
        return true;
    }

    protected boolean validateNonEmpty(String string) {
        return string.trim().length() > 0;
    }

    protected Action setAction(AbstractButton abstractButton, String string) {
        Action action = this.getActionMap().get(string);
        abstractButton.setAction(action);
        Object object = action.getValue("AcceleratorKey");
        if (object != null) {
            this.registerKeyboardAction(action);
            Object object2 = action.getValue("ShortDescription");
            if (object2 != null) {
                action.putValue("ShortDescription", object2.toString() + " (" + SwingUtils.keyStroke2String((KeyStroke)object) + ")");
            }
        }
        return action;
    }

    protected ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = Swinger.getActionMap(this.getClass(), this);
            return this.actionMap;
        }
        return this.actionMap;
    }

    protected void setContextHelp(AbstractButton abstractButton, String string) {
        Action action = this.getActionMap().get("contextDialogHelpAction");
        abstractButton.setAction(action);
        abstractButton.setActionCommand(string);
        abstractButton.putClientProperty("contextDialogHelp", string);
        this.rootPane.registerKeyboardAction(action, string, (KeyStroke)action.getValue("AcceleratorKey"), 2);
    }

    protected void registerKeyboardAction(String string) {
        this.registerKeyboardAction(this.getActionMap().get(string));
    }

    protected void registerKeyboardAction(Action action) {
        this.registerKeyboardAction(action, (KeyStroke)action.getValue("AcceleratorKey"));
    }

    protected void registerKeyboardAction(Action action, KeyStroke keyStroke) {
        this.rootPane.registerKeyboardAction(action, keyStroke, 2);
    }
}

