/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import cz.vity.freerapid.swing.SwingUtils;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

class CompoundUndoManager
extends UndoManager
implements UndoableEditListener {
    public CompoundEdit compoundEdit;
    private JTextComponent editor;
    private int lastOffset;

    public CompoundUndoManager(JTextComponent jTextComponent) {
        this.editor = jTextComponent;
        jTextComponent.getDocument().addUndoableEditListener(this);
        jTextComponent.getActionMap().put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CompoundUndoManager.this.canUndo()) {
                    CompoundUndoManager.this.undo();
                }
            }
        });
        jTextComponent.getActionMap().put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CompoundUndoManager.this.canRedo()) {
                    CompoundUndoManager.this.redo();
                }
            }
        });
        jTextComponent.getInputMap().put(SwingUtils.getCtrlKeyStroke(90), "undo");
        jTextComponent.getInputMap().put(SwingUtils.getCtrlShiftKeyStroke(90), "redo");
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
            return;
        }
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEditEvent.getEdit();
        int n = this.editor.getCaretPosition() - this.lastOffset;
        if (Math.abs(n) == 1 || defaultDocumentEvent.getType().equals(DocumentEvent.EventType.CHANGE)) {
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            this.lastOffset += n;
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
    }

    private CompoundEdit startCompoundEdit(UndoableEdit undoableEdit) {
        this.lastOffset = this.editor.getCaretPosition();
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(undoableEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (CompoundUndoManager.this.compoundEdit != null) {
                CompoundUndoManager.this.compoundEdit.end();
            }
            super.undo();
            CompoundUndoManager.this.compoundEdit = null;
        }
    }
}

