/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.filechooser;

import cz.vity.freerapid.gui.dialogs.filechooser.IFileType;
import cz.vity.freerapid.gui.dialogs.filechooser.JAppFileChooser;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import javax.swing.filechooser.FileFilter;

final class EnhancedFileFilter
extends FileFilter
implements IFileType {
    private final Object[] extensions;
    private final String description;

    public static EnhancedFileFilter createAllFilesFilter() {
        return EnhancedFileFilter.createFilter(new String[0], "allFiles");
    }

    public static EnhancedFileFilter createFilter(String[] stringArray, String string) {
        return new EnhancedFileFilter(stringArray, string);
    }

    public EnhancedFileFilter(String[] stringArray, String string) {
        this.extensions = stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("*.").append(stringArray[i]);
            if (i + 1 == n) continue;
            stringBuilder.append(',');
        }
        if (stringArray.length == 0) {
            stringBuilder.append("*.*");
        }
        this.description = Swinger.getResourceMap(JAppFileChooser.class).getString(string, stringBuilder.toString());
    }

    @Override
    public final String getExtension() {
        return this.extensions[0].toString();
    }

    @Override
    public final boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.extensions.length == 0) {
            return true;
        }
        String string = Utils.getExtension(file);
        if (string != null) {
            for (Object object : this.extensions) {
                if (!string.equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }
}

