/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.DelayedReadValueModel;
import com.jgoodies.binding.value.ValueModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.FileHistoryItem;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskService;

public class FileHistoryManager
extends AbstractBean
implements Application.ExitListener {
    private static final Logger logger = Logger.getLogger(FileHistoryManager.class.getName());
    private final ManagerDirector director;
    private final ApplicationContext context;
    private final ArrayListModel<FileHistoryItem> items = new ArrayListModel();
    private boolean loaded = false;
    private static final String FILES_LIST_XML = "history.xml";
    private int dataChanged = 0;
    private final Object saveFileLock = new Object();

    public FileHistoryManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.director = managerDirector;
        this.context = applicationContext;
        this.context.getApplication().addExitListener(this);
        this.init();
    }

    private void init() {
        if (AppPrefs.getProperty("autosaveEnabled", true)) {
            PropertyAdapter propertyAdapter = new PropertyAdapter((Object)this, "dataChanged", true);
            int n = AppPrefs.getProperty("autosaveTime", 10);
            DelayedReadValueModel delayedReadValueModel = new DelayedReadValueModel((ValueModel)propertyAdapter, n * 1000, true);
            delayedReadValueModel.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FileHistoryManager.this.saveListToFileOnBackground();
                }
            });
        }
    }

    private void saveListToFileOnBackground() {
        TaskService taskService = this.director.getTaskServiceManager().getTaskService("workWithFile");
        taskService.execute(new Task(this.context.getApplication()){

            protected Object doInBackground() throws Exception {
                Thread.currentThread().setPriority(1);
                ArrayListModel arrayListModel = new ArrayListModel(FileHistoryManager.this.getItems());
                FileHistoryManager.this.saveToFile((ArrayListModel<FileHistoryItem>)arrayListModel);
                return null;
            }

            @Override
            protected void failed(Throwable throwable) {
                LogUtils.processException(logger, throwable);
            }
        });
    }

    @Override
    public boolean canExit(EventObject eventObject) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void willExit(EventObject eventObject) {
        FileHistoryManager fileHistoryManager = this;
        synchronized (fileHistoryManager) {
            if (!this.loaded) {
                return;
            }
            this.saveToFile(this.items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(ArrayListModel<FileHistoryItem> arrayListModel) {
        Object object = this.saveFileLock;
        synchronized (object) {
            logger.info("=====Saving download history into XML file=====");
            LocalStorage localStorage = this.context.getLocalStorage();
            File file = new File(localStorage.getDirectory(), FILES_LIST_XML);
            try {
                if (AppPrefs.getProperty("makeFileBackups", true)) {
                    FileUtils.makeBackup(file);
                }
                localStorage.save(arrayListModel, FILES_LIST_XML);
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
            finally {
                logger.info("=====Saving download history finished =====");
            }
        }
    }

    private List<FileHistoryItem> loadList(File file) throws IOException {
        LinkedList<FileHistoryItem> linkedList = new LinkedList<FileHistoryItem>();
        LocalStorage localStorage = this.context.getLocalStorage();
        if (!file.exists()) {
            return linkedList;
        }
        Object object = localStorage.load(FILES_LIST_XML);
        if (object instanceof ArrayListModel) {
            return (List)object;
        }
        return linkedList;
    }

    public synchronized ArrayListModel<FileHistoryItem> getItems() {
        if (!this.loaded) {
            this.loadFileHistoryList();
            this.loaded = true;
        }
        return this.items;
    }

    private void loadFileHistoryList() {
        List<FileHistoryItem> list = null;
        File file = new File(this.context.getLocalStorage().getDirectory(), FILES_LIST_XML);
        if (file.exists()) {
            try {
                list = this.loadList(file);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                logger.info("Trying to renew file from backup");
                try {
                    FileUtils.renewBackup(file);
                    list = this.loadList(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception exception2) {
                    LogUtils.processException(logger, exception);
                }
            }
            if (list != null) {
                this.items.addAll(list);
            }
        }
        this.items.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                FileHistoryManager.this.fireDataChanged();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                FileHistoryManager.this.fireDataChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
    }

    public synchronized void addHistoryItem(DownloadFile downloadFile, File file) {
        if (AppPrefs.getProperty("useHistory", true)) {
            this.getItems().add((Object)new FileHistoryItem(downloadFile, file));
        }
    }

    public synchronized void clearHistory() {
        this.getItems().clear();
    }

    public synchronized void removeItem(FileHistoryItem fileHistoryItem) {
        this.getItems().remove((Object)fileHistoryItem);
    }

    public synchronized void removeItemByIndex(int n) {
        this.getItems().remove(n);
    }

    public List<FileHistoryItem> getSelectionToList(int[] nArray) {
        return this.selectionToList(nArray);
    }

    private List<FileHistoryItem> selectionToList(int[] nArray) {
        ArrayList<FileHistoryItem> arrayList = new ArrayList<FileHistoryItem>();
        ArrayListModel<FileHistoryItem> arrayListModel = this.getItems();
        for (int n : nArray) {
            arrayList.add((FileHistoryItem)arrayListModel.get(n));
        }
        return arrayList;
    }

    public synchronized void removeSelected(int[] nArray) {
        ArrayListModel<FileHistoryItem> arrayListModel = this.getItems();
        List<FileHistoryItem> list = this.getSelectionToList(nArray);
        for (FileHistoryItem fileHistoryItem : list) {
            arrayListModel.remove((Object)fileHistoryItem);
        }
    }

    private void fireDataChanged() {
        this.firePropertyChange("dataChanged", this.dataChanged, ++this.dataChanged);
    }

    public int getDataChanged() {
        return this.dataChanged;
    }
}

