/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.beans.PropertyConnector;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.actions.FileActions;
import cz.vity.freerapid.gui.actions.HelpActions;
import cz.vity.freerapid.gui.actions.ViewActions;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;

public class MenuManager {
    private JMenuBar menuBar;
    private final ApplicationContext context;
    private final ManagerDirector director;
    private static final String SELECTED_TEXT_PROPERTY = "selectedText";
    private static final String MENU_SEPARATOR = "---";
    private final FileActions fileActions;
    private static final String RADIO = "*";
    private static final String RADIO2 = "*2";
    private static final String CHECKED = "!";
    private ViewActions viewActions;
    private JMenu useConnections;

    public FileActions getFileActions() {
        return this.fileActions;
    }

    public MenuManager(ApplicationContext applicationContext, ManagerDirector managerDirector) {
        this.context = applicationContext;
        this.director = managerDirector;
        this.fileActions = new FileActions();
        Swinger.initActions((Object)this.fileActions, applicationContext);
        this.viewActions = new ViewActions();
        Swinger.initActions(this.viewActions, applicationContext);
        Swinger.initActions(new HelpActions(), applicationContext);
    }

    private void init() {
        Object[] objectArray = new Object[]{"addNewLinksAction", MENU_SEPARATOR, "quit"};
        Object[] objectArray2 = new Object[]{"downloadInformationAction", MENU_SEPARATOR, "openFileAction", "deleteFileAction", "openDirectoryAction", MENU_SEPARATOR, "resumeAction", "pauseAction", "cancelAction", MENU_SEPARATOR, "removeCompletedAction", MENU_SEPARATOR, "selectAllAction", "invertSelectionAction", MENU_SEPARATOR, "sortbyNameAction", MENU_SEPARATOR, "topAction", "upAction", "downAction", "bottomAction", MENU_SEPARATOR, "removeSelectedAction"};
        Object[] objectArray3 = new Object[]{"*2shutdownDisabledAction", MENU_SEPARATOR, "*2shutdownQuitAction", "*2shutdownHibernateAction", "*2shutdownStandByAction", "*2shutdownRebootAction", "*2shutdownShutdownAction"};
        JMenu jMenu = MenuManager.createMenu("autoShutdownMenu", objectArray3);
        Object[] objectArray4 = new Object[]{"options", MENU_SEPARATOR, "!monitorClipboardAction", MENU_SEPARATOR, this.createConnectionsMenu(), MENU_SEPARATOR, jMenu};
        Object[] objectArray5 = new Object[]{"showDownloadHistoryAction", MENU_SEPARATOR, "!showCompletedAction", MENU_SEPARATOR, "!showToolbar", "!showStatusBar"};
        Object[] objectArray6 = new Object[]{"help", MENU_SEPARATOR, "showDemo", "visitHomepage", MENU_SEPARATOR, "checkForNewVersion", MENU_SEPARATOR, "paypalSupportAction", MENU_SEPARATOR, "about"};
        boolean bl = Utils.isWindows();
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                StringBuilder stringBuilder = new StringBuilder();
                for (MenuElement menuElement : menuElementArray) {
                    JMenuItem jMenuItem;
                    Action action;
                    if (menuElement instanceof ComboPopup) {
                        return;
                    }
                    if (!(menuElement.getComponent() instanceof JMenuItem) || (action = (jMenuItem = (JMenuItem)menuElement.getComponent()).getAction()) == null) continue;
                    String string = (String)action.getValue("LongDescription");
                    if (string != null) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(" - ");
                        }
                        stringBuilder.append(string);
                        continue;
                    }
                    Object object = action.getValue("ShortDescription");
                    if (object == null) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" - ");
                    }
                    stringBuilder.append(object);
                }
                MenuManager.this.menuBar.putClientProperty(MenuManager.SELECTED_TEXT_PROPERTY, menuElementArray.length != 0 ? stringBuilder.toString() : "cancel");
            }
        });
        this.menuBar.add(MenuManager.createMenu("fileMenu", objectArray));
        this.menuBar.add(MenuManager.createMenu("downloadsMenu", objectArray2));
        this.menuBar.add(MenuManager.createMenu("connectionsMenu", objectArray4));
        this.menuBar.add(MenuManager.createMenu("viewMenu", objectArray5));
        this.menuBar.add(MenuManager.createMenu("helpMenu", objectArray6));
        this.menuBar.putClientProperty(SELECTED_TEXT_PROPERTY, "");
        ApplicationActionMap applicationActionMap = this.context.getActionMap();
        applicationActionMap.get("showCompletedAction").putValue("SwingSelectedKey", this.viewActions.isShowCompleted());
        applicationActionMap.get("monitorClipboardAction").putValue("SwingSelectedKey", this.viewActions.isClipboardMonitoringSelected());
        JRootPane jRootPane = this.director.getMainFrame().getRootPane();
        jRootPane.registerKeyboardAction(Swinger.getAction("showDownloadHistoryAction"), SwingUtils.getCtrlKeyStroke(72), 2);
        if (bl) {
            this.selectAutoShutDownMenu(applicationActionMap);
        }
        if (AppPrefs.getProperty("autoshutdownDisabledWhenExecuted", true)) {
            AppPrefs.storeProperty("autoshutdown", 0);
        }
    }

    private void selectAutoShutDownMenu(ApplicationActionMap applicationActionMap) {
        String string = this.getSelectedShutDownAction();
        applicationActionMap.get(string).putValue("SwingSelectedKey", Boolean.TRUE);
    }

    public String getSelectedShutDownAction() {
        String string;
        int n = AppPrefs.getProperty("autoshutdown", 0);
        switch (n) {
            case 1: {
                string = "shutdownQuitAction";
                break;
            }
            case 5: {
                string = "shutdownHibernateAction";
                break;
            }
            case 3: {
                string = "shutdownRebootAction";
                break;
            }
            case 4: {
                string = "shutdownShutdownAction";
                break;
            }
            case 2: {
                string = "shutdownStandByAction";
                break;
            }
            default: {
                string = "shutdownDisabledAction";
            }
        }
        return string;
    }

    private JMenu createConnectionsMenu() {
        this.useConnections = new JMenu();
        this.useConnections.setName("useConnectionsMenu");
        this.updateConnectionSettings(this.director.getClientManager().getAvailableConnections());
        return this.useConnections;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new JMenuBar();
            this.init();
        }
        return this.menuBar;
    }

    private static JMenu createMenu(String string, Object[] objectArray) {
        JMenu jMenu = new JMenu();
        return MenuManager.processMenu(jMenu, string, objectArray);
    }

    private static JMenu processMenu(JMenu jMenu, String string, Object[] objectArray) {
        jMenu.setName(string);
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        for (Object object : objectArray) {
            JMenuItem jMenuItem;
            if (object instanceof JMenu) {
                jMenu.add((JMenu)object);
                continue;
            }
            if (MENU_SEPARATOR.equals(object)) {
                jMenu.addSeparator();
                buttonGroup = new ButtonGroup();
                continue;
            }
            String string2 = (String)object;
            if (string2.startsWith(RADIO2)) {
                string2 = string2.substring(RADIO2.length());
                jMenuItem = new JRadioButtonMenuItem();
                buttonGroup2.add(jMenuItem);
            } else if (string2.startsWith(RADIO)) {
                string2 = string2.substring(RADIO.length());
                jMenuItem = new JRadioButtonMenuItem();
                buttonGroup.add(jMenuItem);
            } else if (string2.startsWith(CHECKED)) {
                string2 = string2.substring(CHECKED.length());
                jMenuItem = new JCheckBoxMenuItem();
            } else {
                jMenuItem = new JMenuItem();
            }
            jMenuItem.setAction(Swinger.getAction(string2));
            jMenuItem.setToolTipText(null);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public static JPopupMenu processMenu(JPopupMenu jPopupMenu, String string, Object[] objectArray) {
        jPopupMenu.setName(string);
        for (Object object : objectArray) {
            if (MENU_SEPARATOR.equals(object)) {
                jPopupMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setAction(Swinger.getAction(object));
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public void updateConnectionSettings(List<ConnectionSettings> list) {
        this.useConnections.removeAll();
        for (final ConnectionSettings connectionSettings : list) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(connectionSettings.toString());
            PropertyConnector propertyConnector = PropertyConnector.connect((Object)connectionSettings, (String)"enabled", (Object)jCheckBoxMenuItem, (String)"selected");
            propertyConnector.updateProperty2();
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MenuManager.this.director.getClientManager().setConnectionEnabled(connectionSettings, !connectionSettings.isEnabled());
                    MenuManager.this.director.getDataManager().checkQueue();
                }
            });
            this.useConnections.add(jCheckBoxMenuItem);
        }
    }
}

