/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.ToolbarSeparator;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.JXFrame;

public class ToolbarManager
implements PropertyChangeListener {
    private final JPanel toolbarPanel = new JPanel(new BorderLayout());
    private static final Dimension buttonDimension = new Dimension(74, 68);
    private JToolBar toolbar = new JToolBar("mainToolbar");
    private float fontSize;

    public ToolbarManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.toolbarPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        javax.swing.Action action = applicationContext.getActionMap().get("showToolbar");
        action.putValue("SwingSelectedKey", true);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SwingSelectedKey".equals(propertyChangeEvent.getPropertyName())) {
                    ToolbarManager.this.setToolBarVisible((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.fontSize = applicationContext.getResourceMap().getFloat("buttonBarFontSize").floatValue();
        this.createToolbar();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("done".equals(string) || "started".equals(string)) {
            // empty if block
        }
    }

    private void createToolbar() {
        this.toolbarPanel.add(this.toolbar);
        this.toolbarPanel.setPreferredSize(new Dimension(400, 50));
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.getButton(Swinger.getAction("addNewLinksAction")));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(this.getButton(Swinger.getAction("resumeAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("pauseAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("cancelAction")));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(this.getButton(Swinger.getAction("topAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("upAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("downAction")));
        this.toolbar.add(this.getButton(Swinger.getAction("bottomAction")));
        this.toolbar.add(Box.createGlue());
        AbstractButton abstractButton = this.getButton(Swinger.getAction("paypalSupportAction"));
        abstractButton.setOpaque(false);
        abstractButton.setRolloverEnabled(false);
        abstractButton.setBackground(null);
        abstractButton.setText(null);
        abstractButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.toolbar.add(abstractButton);
        this.toolbar.add(Box.createHorizontalStrut(18));
    }

    private void setToolBarVisible(boolean bl) {
        this.toolbarPanel.setVisible(bl);
    }

    public JComponent getComponent() {
        return this.toolbarPanel;
    }

    private AbstractButton getToggleButton(javax.swing.Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        return this.setButtonProperties(jToggleButton, action);
    }

    private AbstractButton getButton(javax.swing.Action action) {
        JButton jButton = new JButton(action);
        return this.setButtonProperties(jButton, action);
    }

    private AbstractButton setButtonProperties(AbstractButton abstractButton, javax.swing.Action action) {
        abstractButton.setRolloverEnabled(true);
        abstractButton.setIconTextGap(0);
        Object object = action.getValue("ShortDescription");
        String string = (String)action.getValue("Name");
        if (string != null && string.endsWith("...")) {
            string = string.substring(0, string.length() - 3);
        }
        abstractButton.setText(string);
        Font font = abstractButton.getFont();
        abstractButton.setFont(font.deriveFont(this.fontSize));
        abstractButton.setVerticalTextPosition(3);
        abstractButton.setHorizontalTextPosition(0);
        abstractButton.setMinimumSize(buttonDimension);
        abstractButton.setPreferredSize(buttonDimension);
        abstractButton.setMaximumSize(buttonDimension);
        Object object2 = action.getValue("AcceleratorKey");
        if (object != null && object2 != null) {
            abstractButton.setToolTipText(object.toString() + " (" + SwingUtils.keyStroke2String((KeyStroke)object2) + ")");
        }
        abstractButton.setMnemonic(0);
        abstractButton.setFocusable(false);
        return abstractButton;
    }

    private void setWorkingProgress(boolean bl) {
        JXFrame jXFrame = (JXFrame)MainApp.getInstance(MainApp.class).getMainFrame();
        jXFrame.setWaiting(bl);
    }

    @Action
    public void paypalSupportAction() {
    }
}

