/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.HttpFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

public final class DownloadClient
implements HttpDownloadClient {
    private static final Logger logger = Logger.getLogger(DownloadClient.class.getName());
    protected HttpClient client = new HttpClient();
    protected String referer = "";
    protected String asString;
    private int redirect;
    private volatile ConnectionSettings settings;

    @Override
    public void initClient(ConnectionSettings connectionSettings) {
        this.settings = connectionSettings;
        HttpClientParams httpClientParams = this.client.getParams();
        httpClientParams.setCookiePolicy("compatibility");
        httpClientParams.setHttpElementCharset("UTF-8");
        this.client.setHttpConnectionManager((HttpConnectionManager)new SimpleHttpConnectionManager(true));
        HttpState httpState = new HttpState();
        if (connectionSettings.isProxySet()) {
            HostConfiguration hostConfiguration = new HostConfiguration();
            hostConfiguration.setProxy(connectionSettings.getProxyURL(), connectionSettings.getProxyPort());
            this.client.setHostConfiguration(hostConfiguration);
            if (connectionSettings.getUserName() != null) {
                httpState.setProxyCredentials(AuthScope.ANY, (Credentials)new NTCredentials(connectionSettings.getUserName(), connectionSettings.getPassword(), "", ""));
            }
        } else {
            this.client.setHostConfiguration(new HostConfiguration());
        }
        httpClientParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
        this.client.setState(httpState);
    }

    private boolean hasAuthentification() {
        if (this.settings == null) {
            throw new IllegalStateException("Client not initialized");
        }
        return this.settings.isProxySet() && this.settings.getUserName() != null;
    }

    protected void setDefaultsForMethod(HttpMethod httpMethod) {
        httpMethod.setRequestHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.9.0.1) Gecko/2008070208 Firefox/3.0.1");
        httpMethod.setRequestHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        httpMethod.setRequestHeader("Accept-Language", "cs,en-us;q=0.7,en;q=0.3");
        httpMethod.setRequestHeader("Accept-Charset", "windows-1250,utf-8;q=0.7,*;q=0.7");
        httpMethod.setRequestHeader("Accept-Encoding", "gzip,deflate");
        httpMethod.setRequestHeader("Keep-Alive", "30");
        if (this.referer.length() > 0) {
            httpMethod.setRequestHeader("Referer", this.referer);
        }
        httpMethod.setFollowRedirects(false);
    }

    @Override
    public PostMethod getPostMethod(String string) {
        PostMethod postMethod = new PostMethod(string);
        this.setDefaultsForMethod((HttpMethod)postMethod);
        postMethod.setDoAuthentication(this.hasAuthentification());
        return postMethod;
    }

    @Override
    public String getReferer() {
        return this.referer;
    }

    @Override
    public InputStream makeFinalRequestForFile(HttpMethod httpMethod, HttpFile httpFile) throws IOException {
        String string;
        this.asString = "";
        this.toString(httpMethod);
        this.client.executeMethod(httpMethod);
        int n = httpMethod.getStatusCode();
        if (n != 200) {
            logger.warning("Loading file failed - invalid HTTP return status code:" + n);
            this.updateAsString(httpMethod);
            return null;
        }
        boolean bl = true;
        Header header = httpMethod.getResponseHeader("Content-Type");
        if (header == null) {
            bl = false;
            logger.warning("No Content-Type!");
        } else {
            boolean bl2;
            string = header.getValue();
            boolean bl3 = string.startsWith("image/");
            boolean bl4 = bl2 = string.startsWith("audio/") || string.startsWith("video/");
            if (!(string.startsWith("application/") || bl3 || bl2)) {
                bl = false;
                logger.warning("Suspicious Content-Type:" + header.getValue());
            } else {
                Header header2 = httpMethod.getResponseHeader("Content-Length");
                if (header2 == null) {
                    bl = false;
                    logger.warning("No Content-Length in header");
                } else {
                    httpFile.setFileSize(Long.valueOf(header2.getValue()));
                }
            }
        }
        string = this.getFileName(httpMethod);
        if (string != null) {
            httpFile.setFileName(string);
        }
        if (bl) {
            return httpMethod.getResponseBodyAsStream();
        }
        logger.warning("Loading file failed");
        this.updateAsString(httpMethod);
        return null;
    }

    private String getFileName(HttpMethod httpMethod) {
        Header header = httpMethod.getResponseHeader("Content-Disposition");
        if (header != null && header.getValue().toLowerCase().contains("attachment")) {
            String string = header.getValue();
            String string2 = "filename=";
            String string3 = string.toLowerCase();
            int n = string3.lastIndexOf(string2);
            if (n >= 0) {
                String string4 = string.substring(n + string2.length());
                if (string4.startsWith("\"") && string4.endsWith("\"")) {
                    string4 = string4.substring(1, string4.length() - 1);
                }
                if (string4.matches(".*%[0-9A-Fa-f]+.*")) {
                    try {
                        string4 = URLDecoder.decode(string4, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.warning("Unsupported encoding");
                    }
                }
                return string4;
            }
            string2 = "filename\\*=UTF-8''";
            n = string3.lastIndexOf(string2);
            if (n >= 0) {
                String string5 = string.substring(n + string2.length());
                if (!string5.isEmpty()) {
                    try {
                        return URLDecoder.decode(string5, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        logger.warning("Unsupported encoding");
                    }
                }
            } else {
                logger.warning("File name was not found in:" + string);
            }
        }
        return null;
    }

    @Override
    public InputStream makeRequestForFile(HttpMethod httpMethod) throws IOException {
        this.toString(httpMethod);
        this.client.executeMethod(httpMethod);
        int n = httpMethod.getStatusCode();
        if (n == 200) {
            String string;
            Header header = httpMethod.getResponseHeader("Content-Type");
            if (header == null) {
                logger.warning("No Content-Type!");
            } else {
                string = header.getValue();
                if (!string.startsWith("application/") && !string.startsWith("image/")) {
                    logger.warning("Suspicious Content-Type:" + string);
                }
            }
            string = httpMethod.getResponseHeader("Content-Encoding");
            if (null != string && "gzip".equals(string.getValue())) {
                logger.info("Found gzip Stream");
                return new GZIPInputStream(httpMethod.getResponseBodyAsStream());
            }
            return httpMethod.getResponseBodyAsStream();
        }
        logger.warning("Loading file failed");
        this.updateAsString(httpMethod);
        return null;
    }

    @Override
    public int makeRequest(HttpMethod httpMethod) throws IOException {
        this.asString = "";
        this.client.executeMethod(httpMethod);
        int n = httpMethod.getStatusCode();
        if (n == 500 || n == 403) {
            logger.severe("Status code je 500");
        } else if (n >= 500) {
            logger.severe("Status code > 500:" + n);
        }
        boolean bl = this.isRedirect(n);
        if (bl && this.redirect != 1) {
            this.redirect = 1;
            Header header = httpMethod.getResponseHeader("location");
            if (header != null) {
                String string = header.getValue();
                if (string == null || "".equals(string)) {
                    string = "/";
                }
                logger.info("Redirect target: " + string);
                this.setReferer(string);
                GetMethod getMethod = this.getGetMethod(string);
                int n2 = this.makeRequest((HttpMethod)getMethod);
                logger.info("Redirect: " + getMethod.getStatusLine().toString());
                return n2;
            }
            logger.info("Invalid redirect");
            System.exit(1);
        } else {
            this.redirect = 0;
            this.updateAsString(httpMethod);
        }
        httpMethod.releaseConnection();
        return n;
    }

    private void updateAsString(HttpMethod httpMethod) throws IOException {
        Header header = httpMethod.getResponseHeader("Content-Encoding");
        this.asString = "";
        if (null != header) {
            if ("gzip".equals(header.getValue())) {
                logger.info("Extracting GZIP");
                this.asString = this.inflate(httpMethod.getResponseBodyAsStream());
            }
        } else {
            this.asString = this.streamToString(httpMethod.getResponseBodyAsStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String streamToString(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[4000];
        try {
            int n;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error during reading content of page", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return "";
    }

    protected boolean isRedirect(int n) {
        return n == 302 || n == 301 || n == 303 || n == 307;
    }

    @Override
    public GetMethod getGetMethod(String string) {
        GetMethod getMethod = new GetMethod(string);
        this.setDefaultsForMethod((HttpMethod)getMethod);
        getMethod.setDoAuthentication(this.hasAuthentification());
        return getMethod;
    }

    protected void toString(HttpMethod httpMethod) {
        logger.info("===============HTTP METHOD===============");
        String string = httpMethod.getPath();
        logger.info("path = " + string);
        PostMethod postMethod = httpMethod.getRequestHeaders();
        StringBuilder stringBuilder = new StringBuilder();
        for (Header header : postMethod) {
            if (header == null) continue;
            stringBuilder.append(header.toString());
        }
        logger.info("header = \n" + stringBuilder.toString().trim());
        if (httpMethod instanceof PostMethod) {
            NameValuePair[] nameValuePairArray;
            PostMethod postMethod2 = (PostMethod)httpMethod;
            stringBuilder = new StringBuilder();
            for (NameValuePair nameValuePair : nameValuePairArray = postMethod2.getParameters()) {
                stringBuilder.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue()).append("\n");
            }
        }
        logger.info("post parameters: \n" + stringBuilder.toString().trim());
        logger.info("query string = " + httpMethod.getQueryString());
        logger.info("=========================================");
    }

    protected String inflate(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4000];
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = gZIPInputStream.read(byArray)) != -1) {
            stringBuilder.append(new String(byArray, 0, n, "UTF-8"));
        }
        return stringBuilder.toString();
    }

    @Override
    public void setReferer(String string) {
        logger.info("Setting referer to " + string);
        this.referer = string;
    }

    @Override
    public ConnectionSettings getSettings() {
        return this.settings;
    }

    @Override
    public HttpClient getHTTPClient() {
        return this.client;
    }

    @Override
    public String getContentAsString() {
        return this.asString;
    }
}

