/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class EditorPaneLinkDetector
extends JEditorPane {
    private static final Logger logger = Logger.getLogger(EditorPaneLinkDetector.class.getName());
    private static final String EXAMPLE = "";
    private static final Pattern REGEXP_URL = Pattern.compile("(http|https)://([a-zA-Z0-9\\.\\-]+(:[a-zA-Z0-9\\.:&%\\$\\-]+)*@)?((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9])|([a-zA-Z0-9\\-]+\\.)*[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,4})(:[0-9]+)?(/[^/][a-zA-Z0-9\\.:,\\?'\\\\/\\+&%\\$#=~_\\-@]*)*");

    public EditorPaneLinkDetector() {
        final SyntaxDocument syntaxDocument = new SyntaxDocument();
        this.setEditorKit(new StyledEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return syntaxDocument;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
                if (jTextComponent.isEditable()) {
                    return;
                }
                StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
                Object object = styledDocument.getCharacterElement(jTextComponent.viewToModel(mouseEvent.getPoint())).getAttributes().getAttribute("EMAIL");
                if (object != null) {
                    mouseEvent.consume();
                    String string = object.toString();
                    logger.info("EditorPaneLinkDetector opening email " + mouseEvent);
                    Browser.openBrowser("mailto:" + string);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 17) {
                    if (EditorPaneLinkDetector.this.isEditable()) {
                        EditorPaneLinkDetector.this.setEditable(false);
                    }
                } else if (!EditorPaneLinkDetector.this.isEditable()) {
                    EditorPaneLinkDetector.this.setEditable(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 17) {
                    EditorPaneLinkDetector.this.setEditable(true);
                }
            }
        });
        this.insertExampleEmail(syntaxDocument);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                if (EditorPaneLinkDetector.EXAMPLE.equals(jTextComponent.getText())) {
                    jTextComponent.setText(EditorPaneLinkDetector.EXAMPLE);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                if (jTextComponent.getText().length() <= 0) {
                    EditorPaneLinkDetector.this.insertExampleEmail((StyledDocument)jTextComponent.getDocument());
                }
            }
        });
    }

    public void setURLList(List<URL> list) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (URL uRL : list) {
            linkedList.add(uRL.toExternalForm());
        }
        this.setURLs(linkedList);
    }

    private void insertExampleEmail(StyledDocument styledDocument) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.GRAY);
        try {
            styledDocument.insertString(0, EXAMPLE, simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
        }
    }

    public void setURLs(List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        Document document = this.getDocument();
        String string = EXAMPLE;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        string = string.trim();
        stringBuilder.append(string);
        if (string.length() > 0) {
            stringBuilder.append('\n');
        }
        for (String string2 : list) {
            stringBuilder.append(string2).append('\n');
        }
        String string3 = stringBuilder.toString();
        try {
            this.setText(EXAMPLE);
            document.insertString(0, string3, null);
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
        }
    }

    public void setURLs(String string) {
        Pattern pattern = REGEXP_URL;
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (EXAMPLE.equals(string2)) continue;
            arrayList.add(string2);
        }
        this.setURLs(arrayList);
    }

    public List<URL> getURLs() {
        String string = this.getText();
        Pattern pattern = REGEXP_URL;
        Matcher matcher = pattern.matcher(string);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (EXAMPLE.equals(string2)) continue;
            try {
                arrayList.add(new URL(string2));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return arrayList;
    }

    public List<String> getURLsAsStringList() {
        String string = this.getText();
        Pattern pattern = REGEXP_URL;
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (EXAMPLE.equals(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    static /* synthetic */ Pattern access$200() {
        return REGEXP_URL;
    }

    static class SyntaxDocument
    extends DefaultStyledDocument {
        private DefaultStyledDocument doc = this;
        private Element rootElement = this.doc.getDefaultRootElement();
        private MutableAttributeSet normal;
        private MutableAttributeSet keyword;
        private static final Pattern EMAIL_PATTERN = EditorPaneLinkDetector.access$200();
        private static final String DELIMITERS = " ";

        public SyntaxDocument() {
            this.putProperty("__EndOfLine__", "\n");
            this.normal = new SimpleAttributeSet();
            StyleConstants.setForeground(this.normal, Color.RED);
            this.keyword = new SimpleAttributeSet();
            StyleConstants.setForeground(this.keyword, Color.BLUE);
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            if (string.equals(EditorPaneLinkDetector.EXAMPLE)) {
                return;
            }
            this.processChangedLines(n, string.length());
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            this.processChangedLines(n, 0);
        }

        public void processChangedLines(int n, int n2) throws BadLocationException {
            String string = this.doc.getText(0, this.doc.getLength());
            int n3 = this.rootElement.getElementIndex(n);
            int n4 = this.rootElement.getElementIndex(n + n2);
            for (int i = n3; i <= n4; ++i) {
                this.applyHighlighting(string, i);
            }
        }

        private void applyHighlighting(String string, int n) throws BadLocationException {
            int n2 = this.rootElement.getElement(n).getStartOffset();
            int n3 = this.rootElement.getElement(n).getEndOffset() - 1;
            int n4 = n3 - n2;
            int n5 = string.length();
            if (n3 >= n5) {
                n3 = n5 - 1;
            }
            this.doc.setCharacterAttributes(n2, n4, this.normal, true);
            this.checkForTokens(string, n2, n3);
        }

        private void checkForTokens(String string, int n, int n2) {
            while (n <= n2) {
                while (this.isDelimiter(string.substring(n, n + 1))) {
                    if (n < n2) {
                        ++n;
                        continue;
                    }
                    return;
                }
                n = this.getOtherToken(string, n, n2);
            }
        }

        private int getOtherToken(String string, int n, int n2) {
            int n3;
            for (n3 = n + 1; n3 <= n2 && !this.isDelimiter(string.substring(n3, n3 + 1)); ++n3) {
            }
            String string2 = string.substring(n, n3);
            if (this.isKeyword(string2)) {
                this.keyword.addAttribute("EMAIL", string2);
                this.doc.setCharacterAttributes(n, n3 - n, this.keyword, false);
            }
            return n3 + 1;
        }

        protected boolean isDelimiter(String string) {
            return Character.isWhitespace(string.charAt(0)) || DELIMITERS.indexOf(string) != -1;
        }

        protected boolean isKeyword(String string) {
            Matcher matcher = EMAIL_PATTERN.matcher(string);
            if (matcher.find()) {
                try {
                    new URL(matcher.group());
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

