/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.components;

import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class MemoryIndicator
extends JPanel {
    private final JProgressBar progressBar;

    public MemoryIndicator() {
        this.setLayout(new BoxLayout(this, 2));
        this.progressBar = new JProgressBar();
        this.add(this.progressBar);
        JButton jButton = ComponentFactory.getToolbarButton();
        jButton.setName("btnGC");
        Swinger.getResourceMap().injectComponent(jButton);
        jButton.setIconTextGap(0);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                    }
                }).start();
            }
        });
        this.add(jButton);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setStringPainted(true);
        this.updateInfo();
        final Timer timer = new Timer(2500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryIndicator.this.updateInfo();
            }
        });
        timer.start();
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    timer.start();
                } else {
                    timer.stop();
                }
            }
        });
    }

    private void updateInfo() {
        Runtime runtime = Runtime.getRuntime();
        int n = (int)(runtime.maxMemory() / 1024L / 1024L);
        long l = runtime.totalMemory() - runtime.freeMemory();
        l = l / 1024L / 1024L;
        String string = Swinger.getResourceMap().getString("memoryIndicator", l, n);
        this.progressBar.setMaximum(n);
        this.progressBar.setValue((int)l);
        this.progressBar.setString(string);
    }
}

